Program PQROT; 
uses
{$if defined(go32v2) or defined(msdos)}
   graph, crt, dos;
{$else}
   ptcgraph, ptccrt, dos;
{$endif} 

// ptcgraph and ptccrt are part of ptcpas which is distributed in the fpc package version 2.6.4;
// The combination of graph, wincrt, dos for windows is not supported anymore since 
// PQROT version 2.20 (The key code alternatives for F1 to F9, #101 to #109 were discarded)
{---------------------------------------------------------------
This is the free pascal version (2.0) of PQROT.PAS originally programmed by Andreas Zollorsch 
in Turbo Pascal (TP). Andreas had tried to keep one basic source text for both versions,
TP and free pascal / ppc386, with comments and switches for converting one 
version into the other. I've cleared that and removed (most) unnecessary leftovers from 
the TP version. 

The first free pascal version of PQROT (1.5) was designed for Windows only because it 
used Units GRAPH and WINCRT which are not available for other platforms (at least I thought so). 

In version 1.6 GRAPH was replaced by PTCGRAPH which is available for Windows and Linux, and 
possibly later also for Mac OS X. Moreover, PTCGRAPH now allows resizing the graphic window 
in the Windows version. Similarly, PTCCRT replaced WINCRT both of which, different from CRT,
allow to access the keyboard without shifting the focus on the console window. 

Version 1.7 can be compiled not only with PTCGRAPH / PTCCRT but with GRAPH / WINCRT as well. 
The only difference between the two versions of the pairs of units that had to be taken care of
consist in different key codes for the function keys. Therefore in 1.7 every action following a 
function key pressing is activated with either of the two respective key codes.  
Additional key alternatives were introduced as workaround for a bug in PTCCRT that did not allow to
read DEL and INS keys, but most of them removed again after updating PTCPas to 0.99.13 in which
the DEL/INS bug was cleared.  

Version 1.8 cleared a little bug that prevented finding the LITT.CHR in the Linux version.

In Version 1.9 ESC-1 to ESC-9 were implemented as alternative key strokes for F1 to F9.

In Version 2.0 Windows key codes for F1 to F9 (#101 to #109) were discarded, and additional
key code alternatives (END, HOME, DEL, INS) implemented.

I highly appreciated the assistance from Thomas Trautmann (TT) who 
found and implemented the PTCGRAPH solution for creating a preliminary PQROT 
version for Linux. Thanks are due also to Nikolay Nikolov for providing PTCPas, and for 
assistance. 

Font selection:
The font is defined as the 1st parameter of SetTextStyle command. It was set by Andreas to 2
in all instances but one. I changed the "2" to CONST ft, which I set to various
pre-defined constants according to http://www.freepascal.org/docs-html/rtl/graph/settextstyle.html,
hoping that using a pre-set font would supersede the required .CHR file in the executable folder. 
The finally chosen SmallFont obviously is the same as the previous value 2, and refers to the file
LITT.CHR (little font - note spelling, capital letters required under Linux!) that remains necessary.
 
Case sensitivity in file names:
Since the new version of this code (PQROT 1.6) can be ported to other platforms than Windows, 
case sensitivity in input file names is an issue now. Therefore I tried to make sure that PQROT 
takes and does not modify the case of the 'project' part of the file name as provided by the user 
or PQMethod. The extension part (.unr, .rot, .hro, .dat) is expected to be in small letters since 
PQMETHOD as well as PQROT use this version when outputting the files. 
 
Peter.Schmolck@web.de (SMK), 19.04.2014
----------------------------------------------------------------}


CONST fs = 4;
CONST ft = SmallFont;


Type matrix = Record
                spalte, zeile: integer;
                inhalt: array [1..400,1..8] Of real;
              End;
     punkt = Record
               x,y: integer;
             End;
     markvector = array[1..400] Of boolean;
     flaggingmatrix = array[1..400,1..8] Of boolean;
     namenvector = array[1..400] Of string[8];

VAR
  gd,gm					: integer;
  m					: matrix;
  flags					: flaggingmatrix;
  names					: namenvector; high: markvector;
  bgipfad,pfad,ext,strp,str1,str2,datei	: string;
  ch,ch2				: char;
  puffer				: array[1..2] Of string;
  q, changes, qs, commando		: boolean;
  t			 		: byte;
  Nitems				: byte;

//TT Var 
//TT    Multx, Divx, Multy, Divy: Word;


procedure reduce_string (VAR st:string; h:integer);
VAR st2 : string;
    i:integer;

BEGIN
 setcolor (white);
 outtextxy (80,250,st);
 setcolor (black);
 if length(st) <= h then begin st := ''; end
 ELSE BEGIN
 st2 := '';
 for i := 1 to length(st)-h do
    st2 := st2 + st[i];
 st := st2;
 END;
END;




Procedure checkfile (d: string; VAR s1,s2,s3:string);
var
c:char;
i: integer;
e:boolean;

BEGIN
 s1 := '';
 s2 := '';
 s3 := '';
 e := false;
 for i := 1 to length(d) do begin
//SMK      c := upcase(d[i]); (upcase'ing seems relevant only for the extension; see matrixeinlesen)
       c := (d[i]);

      if ((c = '.') or e)and(length(d)-i <= 3)and((d[i+2] <> '\')and(d[i+2] <> '/')) then
//      if ((c = '.') or e)and(length(d)-i <= 3)and(d[i+2] <> '/') then
      begin
       s3 := s3+c; e := true; end
       else begin
      s2 := s2 + c;
      if (c = '\')or(c = '/') then begin s1 := s1 + s2; s2 := ''; end;
//      if c = '/' then begin s1 := s1 + s2; s2 := ''; end;
      end;
 end;
END;

Procedure opengwindow(x1,y1,x2,y2:integer);
BEGIN
  setfillstyle(1, white);
  setcolor (black);
  bar(x1,y1,x2,y2);
  rectangle (x1,y1,x2,y2);
END;

Procedure errormsg(em: string; big:byte);
BEGIN
  setcolor (red);
  settextstyle (ft,0,fs+big);
  outtextxy (80,220,em);
  settextstyle (ft,0,fs);
  delay (2000);
END;

function wannasave: char;
VAR ch: char;
BEGIN
    opengwindow(50,200,590,280);
    outtextxy(80,220, 'Data has been modified. Save?');
                 Repeat
                   ch := readkey;
                   If upcase(ch) In ['N','Y',chr(27)] Then
                     Begin
                       outtextxy (100,250,ch);
                     End;
                 Until upcase(ch) In ['N','Y',chr(27)];
                 if ch <> chr(27) then begin
                 delay (1000);
                 end;
    wannasave := upcase(ch);
END;


Procedure hilfe(h:byte);

Begin
  If h <> 3 Then
    Begin
     opengwindow(100,100,540,380);
    End;
  If h= 1 Then
    Begin
      outtextxy (110,110, 'Hand-Rotation-Help:');
      outtextxy (110,130, 'Page Up  : Rotate the axes by + 90');
      outtextxy (110,150, 'Page Down: Rotate the axes by - 90');
      outtextxy (110,170, 'Insert or Up  : Choose the points to be highlighted');
      outtextxy (110,190, '+             : Increase rotation speed');
      outtextxy (110,210, '-             : Decrease rotation speed');
      outtextxy (110,230, 'ESC           : Discard changes');
      outtextxy (110,250, 'Enter         : Accept changes');
      ch := readkey;
    End;
  If h = 2 Then
    Begin
      outtextxy (110,110, 'PQROT 2.0 for Windows etc.');
      outtextxy (130,130, 'High-resolution hand-rotation Add-on for PQMethod:');
      outtextxy (150,150, 'written by Andreas Zollorsch & Peter.Schmolck@web.de');
      outtextxy (110,210, 'If red arrows are shown you can scroll the screen:');
      outtextxy (110,230, 'Arrow Up      : Scroll up');
      outtextxy (110,250, 'Arrow Down    : Scroll down');
      outtextxy (110,270, 'Pg Up         : Scroll fast up');
      outtextxy (110,290, 'Pg Down       : Scroll fast down');
      outtextxy (110,310, 'Home or ESC-h : Go to the first line of values');
      outtextxy (110,330, 'End  or ESC-e : Go to the last line of values');
      ch := readkey;
    End;
  If h = 3 Then
    Begin
      writeln (' PQRot 2.0 for Windows etc.');
      writeln (' A high-resolution hand-rotation Add-on for PQMethod');
      writeln (' written by Andreas Zollorsch & Peter.Schmolck@web.de');
      writeln;
      writeln ('Usage:');
      writeln ('pqrot [/?] [/qs] [<study>[.<ext>]]');
      writeln ('    Options:');
      writeln ('         /?: Displays this help view');
      writeln ('        /qs: Quickstart');
      writeln ('             Gets you directly to the main screen');
      writeln ('    <study>: A PQMethod study name with or without path');
      writeln ('      <ext>: one of: .unr / .rot / .hro');
    End;

End;

Procedure make_qan;
var dat,str_h,str_m,str_y,str_mon,str_d:string;
    f: text;
    h,m,s,s100:word;
    year,month,day,dow:word;

BEGIN
      if q then begin
      dat := datei + '.qan';
      gettime(h,m,s,s100);
      getdate(year,month,day,dow);
      str(h,str_h); str(m,str_m); str(year,str_y);str(month,str_mon);str(day,str_d);
      if h in [0..9] then str_h := '0'+str_h;
      if m in [0..9] then str_m := '0'+str_m;
      assign (f,pfad+dat);
      rewrite(f);
      writeln (f,'  FTR#1  FTR#2  ANGLE     '+'Generated By PQROT ['+str_h+
      ':'+str_m+', '+str_mon+'/'+str_d+'/'+str_y+']');
      close(f);
      q := false;
      end;
end;


Procedure sicherheitskopie(dateiname:String; Var m:matrix);

Var 
  f: text;
  i,x: integer;
  z,st: string;

Begin
  dateiname := dateiname + '.hro';
  assign (f,pfad+dateiname);
  rewrite (f);
  writeln (f, puffer[1]);
  writeln (f, puffer[2]);
  For i := 1 To m.spalte Do
    Begin
      z := '  ';
      x := 1;
      Repeat
        str(m.inhalt[i,x]:8:5, st);
        z := z + st[1]+st[3]+st[4]+st[5]+st[6]+st[7]+ st[8]+ '   ';
        x := x +1;
      Until x = m.zeile+1;
      x := 1;
      Repeat
        If flags[i,x] Then z[(x-1)*10+10] := 'X';
        x := x+1;
      Until x=m.zeile+1;
      writeln (f,z);
    End;

  close (f);
End;

Procedure look_up_name(dateiname:String; Var n:namenvector);

Var i: integer;
    DirInfo: Searchrec;
    f: text;
    z : string;

Begin
   For i := 1 To 400 Do
     n[i] := '';
   dateiname := dateiname+ '.dat';
   FindFirst(pfad+dateiname,Archive,DirInfo);
   If DosError = 0 Then
     Begin
       assign (f,pfad+dateiname);
       reset(f);
       readln(f,z);
       readln(f,z);
       i := 1;
       while not eof(f) Do
       Begin
         readln (f,z);
         n[i] := z[1]+z[2]+z[3]+z[4]+z[5]+z[6]+z[7]+z[8];
         i := i+1;
       End;
     End;
     close(f);
End;




Procedure matrixeinlesen (dateiname:String; Var m:matrix);

Var 
  f: text;
  h1,h2,h3,dat: string;
  z: string;
  i,j,error: integer;
  ch,limit: char;
  l: string;
  x,err: integer;
  previous: boolean;
  DirInfo: SearchRec;

Procedure errormessage;
Begin
                      opengwindow(50,200,590,280);
                      errormsg('There are errors in this file !',1);
                      m.spalte := 0;
                      m.zeile := 0;
                      commando := false;
end;


Begin
       opengwindow(80,180,560,300);
//SMK: upcase'ing here instead of in proc. checkfile
       if (upcase(ext) <> '.UNR') AND (upcase(ext) <> '.ROT') AND (upcase(ext) <> '.HRO') then BEGIN
       outtextxy (100,220,'Is this the continuation of a previous rotation? (Y/N)');
       Repeat
         ch := readkey;
         If upcase(ch) In ['N','Y'] Then
           Begin
                      val (ch,x,err);
                      outtextxy (100,250,ch);
           End;
       Until upcase(ch) In ['N','Y'];
       delay (800);
       If upcase (ch) = 'N' Then previous := false
  Else previous := true;
  END
  else begin
   if upcase(ext) ='.UNR' then previous := false else previous := true;
  end;

  dat := dateiname;
  If previous Then
    Begin
      if upcase(ext) <> '.HRO' then FindFirst(pfad+dateiname+'.rot', Archive, DirInfo);
      If DosError = 0 Then dateiname := dateiname+ '.rot'
      Else
        dateiname := dateiname+ '.hro';
      if upcase(ext)= '.HRO' then dateiname := dat+ '.hro';
    End
    Else
      dateiname := dateiname+ '.unr';
  assign(f, pfad+dateiname);
 {$I-}
  reset(f);
  close(f);
 {$I+}
  If IOREsult <> 0 Then
    Begin
       opengwindow(50,200,590,280);
       errormsg('             File Not Found Error !!!',2);
       commando := false;
       exit;
    End;
  datei := dat;
  reset(f);
  readln(f, z);                        (* Matrixparameter einlesen *)
  puffer[1] := z;
  h1 := z[1]+ z[2] + z[3];
  h2 := z[4]+ z[5] + z[6];
   h3 := z[7]+ z[8] + z[9];

  val (h1, m.zeile, error);
  If error <> 0 Then
    Begin            errormessage;
                     exit;
                     End;
  val (h2, m.spalte, error);
  If error <> 0 Then
    Begin            errormessage;
                     exit;
                    End;

   val (h3, Nitems, error);
   If error <> 0 Then Begin
      errormessage;
      exit;
   End;

    For i := 1 To 400 Do
      For j := 1 To 8 Do
        flags[i,j] := false;

  readln (f,z);
  puffer[2] := z;
  For i := 1 To m.spalte Do
    Begin
      readln (f,z);
      For j := 1 To m.zeile Do
        Begin
          h1 := z[(j-1)*10+1] +z[(j-1)*10+2] +z[(j-1)*10 +3]+z[(j-1)*10 +4]
                + z[(j-1)*10 +5]+z[(j-1)*10 +6]
                + z[(j-1)*10 +7]+z[(j-1)*10 +8]+z[(j-1)*10 +9];

          If z[(j-1)*10 +10] = 'X' Then flags[i,j] := true;

          val (h1, m.inhalt[i,j], error);
          If error <> 0 Then
            Begin       errormessage;
                        exit;
                       End;
        End;
    End;


  close(f);

  if (not previous) then BEGIN
       str(m.zeile,l);
       limit := l[1];
       opengwindow(80,180,560,300);
       outtextxy (100,200,'This file contains '+limit+' factors...');
       outtextxy (100,220,'How many factors to keep for rotation?');
       setcolor (black);
       Repeat
         ch := readkey;
         If (ch In['1'..limit]) Then
           Begin
                      val (ch,x,err);
                      outtextxy (100,250,ch);
           End;
       Until ch In ['1'..limit];
       delay (800);

       m.zeile := x;
    End;
  look_up_name(datei,names);
  changes := false;
  q := true;
End;

Procedure matrixspeichern(dateiname:String; Var m:matrix);

Var 
  f: text;
  i,j,x,y,err: integer;
  z,st,l,mz: string;
  saver : array[1..8] Of byte;
  ch,mzeile : char;

Begin
  If m.spalte = 0 Then exit;
  For i := 1 To 8 Do
    saver[i] := 0;
       opengwindow(50,200,590,280);
       outtextxy (55,220,'Which factors do you want to save (* for all; Enter to accept; ESC to discard)?');
       setcolor (black);
       l := '';
       x := 0;
       Repeat
         ch := readkey;
         If ch = #27 (*Esc*) Then exit;
         str(m.zeile, mz);
         mzeile := mz[1];
         If ch In ['1'..mzeile,'*',chr(8)] Then
           Begin
             If ch <> '*' Then
               Begin
                 if ch = chr(8) then begin
                    reduce_string(l,4);
                    if x > 0 then x := x-1;
                    end else begin
                 l := l+ ch + '   ';
                 x := x+1;
                 end;
                 outtextxy (80,250,l);
               End;
           End;

       Until (x=8) Or (ch = chr(13)) Or (ch = '*');
       delay (700);
       If ch = '*' Then x := m.zeile;

       If (l = '') And (ch <> '*') Then exit;
       If ch = '*' Then
         Begin
           For i := 1 To m.zeile Do
             saver[i] := i;
         End
       Else
         Begin
           y := 1;
           For i := 1 To length(l) Do
             Begin
               ch := l[i];
               If ch <> ' ' Then
                 Begin
                   val (ch,j,err);
                   saver[y] := j;
                   y := y+1;
                 End;
             End;
         End;


  dateiname := dateiname + '.rot';
  assign (f,pfad+dateiname);
  rewrite (f);
  puffer[1][3] := chr(x+48);
  err := x;
  writeln (f, puffer[1]);
  writeln (f, puffer[2]);
  For i := 1 To m.spalte Do
    Begin
      z := '  ';
      x := 1;
      Repeat
        str(m.inhalt[i,saver[x]]:8:5, st);
        z := z + st[1]+st[3]+st[4]+st[5]+st[6]+st[7]+ st[8]+ '   ';
        x := x +1;
      Until (saver[x] = 0)Or (x = err+1);
      x := 1;
      Repeat
        If flags[i,saver[x]] Then z[(x-1)*10+10] := 'X';
        x := x+1;
      Until (saver[x] = 0) Or (x=err+1);
      writeln (f,z);
    End;

  close (f);
       opengwindow(50,200,590,280);
       errormsg('             Matrix saved successfully',2);
       changes := false;
End;


Procedure rotieren (x,y: integer; winkel:integer; Var m:matrix);

Var 
  rotiermatrix: array [1..2,1..2] Of real;
  i : integer;
  zw,zw2: real;


 Function winkelumrechnung(winkel: integer): real;
 Begin
   winkelumrechnung := winkel * pi / 180;     (* von Winkelmass auf Kreismass *)
 End;

Begin
  rotiermatrix[1,1] := cos (winkelumrechnung(winkel));  (* Generierung der *)
  rotiermatrix[1,2] := sin (winkelumrechnung(winkel));  (* Transformationsmatrix *)
  rotiermatrix[2,1] := - rotiermatrix[1,2];
  rotiermatrix[2,2] := rotiermatrix[1,1];

  For i := 1 To m.spalte Do
    Begin

      zw := m.inhalt[i,x]* rotiermatrix[1,1]               (* Matrixmult. *)
            +m.inhalt[i,y]* rotiermatrix[2,1];
      zw2 := m.inhalt[i,x]* rotiermatrix[1,2]
             +m.inhalt[i,y]* rotiermatrix[2,2];
      m.inhalt[i,x] := zw;
      m.inhalt[i,y] := zw2;
    End;

End;

Procedure datei_qan( x,y,gesamt:integer;dateiname:String);

Var 
  f: text;

Begin
  dateiname := dateiname + '.qan';
  Assign(f, pfad+dateiname);
   append(f);
   writeln (f,'    ',y,'      ',x,'     ',gesamt,'.');
   close(f);
End;

Procedure highlight_matrix;
Var 
  i,j,n,o,scroll : integer;
  s,s2: string;

  Label jump;

Begin
  i := 2;
  j := 1;
  scroll := 1;
  jump:
        setcolor (black);
  setfillstyle(1,white);
  bar(0,0,640,480);
  
   settextstyle (ft,0,fs);
   For n := scroll To m.spalte Do
     Begin
       if high[n] then setcolor (13) else setcolor (black);
       str (n,s);
       outtextxy (15,(n-scroll+1)*8+20, s+' '+names[n]);
     End;
   For o := 1 To m.zeile Do
     Begin
       str(o,s);
       setcolor (black);
       outtextxy (o*50+50,10,s);
     End;
   For o := 1 To m.zeile Do
     Begin
       For n := scroll To m.spalte Do
         Begin
           if high[n] then setcolor (13) else setcolor (black);
           str (m.inhalt[n,o]:5:2, s);
           outtextxy (o*50+30, (n-scroll+1)*8+20, s);
           If flags[n,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20,'X');
         End;
     End;

  line (481,0,481,480);
  setcolor (black);
  settextstyle (ft,0,fs);
  outtextxy (490,50,' Keys To Use:');
  outtextxy (490,100,'Arrow Keys:');
  outtextxy (490,110,' Choose list entry');
  outtextxy (490,150,'Enter: ');
  outtextxy (490,160,' Mark / Unmark entry');
  outtextxy (490,200,'DEL or ESC-d: ');
  outtextxy (490,210,' Delete all marks');
  outtextxy (490,250,'End or ESC-e:');
  outtextxy (490,260,' End of highlighting');



  If m.spalte = 0 Then exit;
  Repeat
    setcolor (red);

    If m.spalte > 56 Then
      Begin
        settextstyle (0,0,1);
        If scroll > 1 Then setcolor (red)
        Else setcolor (white);
                      outtextxy (485,460,chr(30));
        If scroll < m.spalte-55 Then setcolor (red)
        Else setcolor (white);
        outtextxy (485,470,chr(31));
        setcolor (red);
      End;
    settextstyle(ft,0,fs);

    rectangle (10,i*8+14,(m.zeile+1)*50+30,i*8+22);
    ch := readkey;
    If (ch= chr(0)) or (ch=chr(27)) Then
      Begin
        ch := readkey;
        setcolor (white);
        Case ch Of
          #72 (*UP*):     
               Begin
                 If i >= 2 Then
                   Begin
                     If (i = 2) And (scroll > 1) Then
                       Begin

                         scroll := scroll-1;
                         settextstyle (ft,0,fs);
                         For n := scroll To m.spalte Do
                           Begin
                             For o := 1 To m.zeile Do
                               Begin
                                 str (m.inhalt[n+1,o]:5:2, s);
                                 str(n+1,s2);
                                 setcolor (white);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+ ' '+names[n+1]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n+1,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20
                                   ,'X');
                               End;

                             For o := 1 To m.zeile Do
                               Begin
                                 if high[n] then setcolor(13) else setcolor (black);
                                 str(m.inhalt[n,o]:5:2, s);
                                 str (n,s2);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+' '+names[n]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20,
                                   'X');
                               End; {for o}
                           End; {for n}
                       End   {if}
                     Else
                       Begin
                         If i > 2 Then
                           Begin
                             rectangle (10,i*8+14,(m.zeile+1)*50+30,i*8+22);
                             i := i-1;
                           End; {if}
                       End; {else}
                   End; {if}
               End;  {block}
          #80 (*DOWN*):   
               Begin
                 If i <= m.spalte Then
                   Begin

                     If (i = 57) And (scroll <= m.spalte-56) Then
                       Begin
                         setcolor (black);
                         scroll := scroll+1;

                         settextstyle (ft,0,fs);
                         For n := m.spalte Downto scroll Do
                           Begin
                             For o := 1 To m.zeile Do
                               Begin
                                 str (m.inhalt[n-1,o]:5:2, s);
                                 str(n-1,s2);
                                 setcolor (white);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+' '+names[n-1]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n-1,o] Then
                                   Begin
                                     outtextxy (o*50+60,(n-scroll+1)*8+20,'X');
                                   End;
                                 str (m.inhalt[m.spalte,o]:5:2, s);
                                 str (m.spalte,s2);
                                 outtextxy (o*50+30, (m.spalte-scroll+2)*8+20,s);
                                 outtextxy (15, (m.spalte-scroll+2)*8+20, s2+' '+names[m.spalte]);
                               End;

                             For o := 1 To m.zeile Do
                               Begin
                                 if high[n] then setcolor (13) else setcolor (blaCK);
                                 str(m.inhalt[n,o]:5:2, s);
                                 str (n,s2);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+' '+names[n]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20,
                                   'X');
                               End;
                           End;
                       End
                     Else
                       Begin
                         If i < 57 Then
                           Begin
                             rectangle (10,i*8+14,(m.zeile+1)*50+30,i*8+22);
                             i := i+1;
                           End;
                       End;
                   End;
               End;

          #79,#101 (*END,Esc-e*): begin changes := true; exit; end;   
//TT          #75 (*LEFT*): begin changes := true; exit; end; 

          #83,#100 (*DEL,Esc-d*):    
               Begin
                 opengwindow(50,200,590,280);
                 outtextxy (80,220,'ARE YOU SURE YOU WANT TO DELETE ALL MARKS ON SCREEN ??? (Y/N)');
                 setcolor (black);
                 Repeat
                   ch := readkey;
                   If upcase(ch) In ['N','Y'] Then
                     Begin
                       outtextxy (100,250,ch);
                     End;
                 Until upcase(ch) In ['N','Y'];
                 delay (800);
                 If upcase(ch) = 'Y' Then
                   Begin
                     For n := 1 To m.spalte Do
                             high[n] := false;
        {  setcolor (black);
          outtextxy (o*50+60,n*8+20,'X');
          setcolor (white); }
                           End;
                 goto jump;
               End;
             End;
             End;
    If ch = chr (13) Then
      Begin
        setcolor (black);
        If high[i-2+scroll] Then high[i-2+scroll] := false
        Else
          high[i-2+scroll] := true;
      goto jump;
      End;
  Until false;


End;



Procedure highlighting;

 Var i,j, err,numb : integer;
     l,s: string;
     typeout : array[1..4] of string;
     ch: char;

 Begin
   repeat
   for i := 1 to 4 do typeout[i] := '';
   opengwindow(50,200,590,400);
   outtextxy (115,220,'List of marked cases, type number and press INS or Enter to Add to List');
   outtextxy (130,240,'or DEL or DOWN to delete typed number in list. ESC gets you back.');
   setcolor (black);
   j := 1;
   for i := 1 to 400 do begin
    if high [i] then begin
     str(i,s); typeout[j] := typeout[j] + s+ '      ';
    end;
    if length(typeout[j]) > 85 then begin if j = 4 then
    typeout [j] := 'Not enough space for displaying all marked cases'
    else j := j +1; end;
   end;
   for i := 1 to 4 do  outtextxy (60,260+20*i,typeout[i]);
   l := '';
            ch := readkey;
            If ch = #27 (*Esc*)  Then exit;
            Repeat
              if ch = chr(8) then reduce_string(l,1) else
              l := l+ch;
              outtextxy (310,380,l);
              ch := readkey; 
              If ch = #27 (*Esc*)  Then exit;
            Until (ch = chr(82)) or (ch=chr(83)) or (ch=chr(80)) or (ch = chr(13));   (*INS, DEL, DOWN, ENTER*)
            if (ch = chr(82)) or (ch=chr(83)) then reduce_string(l,1);  (*INS, DEL*)
   val (l,numb,err);
   if err = 0 then BEGIN
    if ((ch = chr(82)) or (ch=chr(13)))   (*INS, ENTER*)
        and (numb <= m.spalte) then high[numb] := true;
    if (ch = chr(83)) or (ch = chr(80)) then high[numb] := false; (*DEL, DOWN*)
   END;
  until false;

End;

Procedure flag_it (Var m:matrix);

Var 
  i,j,n,o,scroll : integer;
  s,s2: string;

  Label jump;

Begin
  i := 2;
  j := 1;
  scroll := 1;
  jump:
        setcolor (black);
  setfillstyle(1,white);
  bar(0,0,640,480);

  SetTextStyle (ft,0,fs);
   For n := scroll To m.spalte Do
     Begin
       if high[n] then setcolor (13) else setcolor (black);
       str (n,s);
       outtextxy (15,(n-scroll+1)*8+20, s+' '+names[n]);
     End;
   For o := 1 To m.zeile Do
     Begin
       str(o,s);
       setcolor (black);
       outtextxy (o*50+50,10,s);
     End;
   For o := 1 To m.zeile Do
     Begin
       For n := scroll To m.spalte Do
         Begin
           if high[n] then setcolor (13) else setcolor (black);
           str (m.inhalt[n,o]:5:2, s);
           outtextxy (o*50+30, (n-scroll+1)*8+20, s);
           If flags[n,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20,'X');
         End;
     End;

  line (481,0,481,480);
  setcolor (black);
  settextstyle (ft,0,fs);
  outtextxy (490,50,' Keys To Use:');
  outtextxy (490,100,'Arrow Keys:');
  outtextxy (490,110,' Choose list entry');
  outtextxy (490,150,'Enter: ');
  outtextxy (490,160,' Flag / Deflag a value');
  outtextxy (490,200,'DEL or ESC-d: ');
  outtextxy (490,210,' Delete all flags');
  outtextxy (490,250,'END or ESC-e:');
  outtextxy (490,260,' End of flagging');



  If m.spalte = 0 Then exit;
  Repeat
    setcolor (red);

    If m.spalte > 56 Then
      Begin
        settextstyle (0,0,1);
        If scroll > 1 Then setcolor (red)
        Else setcolor (white);
                      outtextxy (485,460,chr(30));
        If scroll < m.spalte-55 Then setcolor (red)
        Else setcolor (white);
        outtextxy (485,470,chr(31));
        setcolor (red);
      End;
    settextstyle(ft,0,fs);

    rectangle (10,i*8+14,(m.zeile+1)*50+30,i*8+22);
    rectangle (j*50+30, 7, j*50+70, (m.spalte+1)*8+25);
    ch := readkey; //why? if ch = chr(27) then exit;
    If (ch= chr(0)) or (ch=chr(27)) Then
//    If (ch= chr(0))  Then
      Begin
        ch := readkey;
        setcolor (white);
        Case ch Of
          #72 (*UP*):
               Begin
                 If i >= 2 Then
                   Begin
                     If (i = 2) And (scroll > 1) Then
                       Begin

                         scroll := scroll-1;
                         settextstyle (ft,0,fs);
                         For n := scroll To m.spalte Do
                           Begin
                             For o := 1 To m.zeile Do
                               Begin
                                 str (m.inhalt[n+1,o]:5:2, s);
                                 str(n+1,s2);
                                 setcolor (white);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+ ' '+names[n+1]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n+1,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20
                                   ,'X');
                               End;

                             For o := 1 To m.zeile Do
                               Begin
                                 if high[n] then setcolor(13) else setcolor (black);
                                 str(m.inhalt[n,o]:5:2, s);
                                 str (n,s2);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+' '+names[n]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20,
                                   'X');
                               End; {for o}
                           End; {for n}
                       End   {if}
                     Else
                       Begin
                         If i > 2 Then
                           Begin
                             rectangle (10,i*8+14,(m.zeile+1)*50+30,i*8+22);
                             i := i-1;
                           End; {if}
                       End; {else}
                   End; {if}
               End;  {block}
          #75 (*LEFT*):
               Begin
                 If j > 1 Then
                   Begin
                     rectangle (j*50+30, 7, j*50+70, (m.spalte+1)*8+25);
                     j := j-1;
                   End;
               End;
          #80 (*DOWN*):
               Begin
                 If i <= m.spalte Then
                   Begin

                     If (i = 57) And (scroll <= m.spalte-56) Then
                       Begin
                         setcolor (black);
                         scroll := scroll+1;

                         settextstyle (ft,0,fs);
                         For n := m.spalte Downto scroll Do
                           Begin
                             For o := 1 To m.zeile Do
                               Begin
                                 str (m.inhalt[n-1,o]:5:2, s);
                                 str(n-1,s2);
                                 setcolor (white);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+' '+names[n-1]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n-1,o] Then
                                   Begin
                                     outtextxy (o*50+60,(n-scroll+1)*8+20,'X');
                                   End;
                                 str (m.inhalt[m.spalte,o]:5:2, s);
                                 str (m.spalte,s2);
                                 outtextxy (o*50+30, (m.spalte-scroll+2)*8+20,s);
                                 outtextxy (15, (m.spalte-scroll+2)*8+20, s2+' '+names[m.spalte]);
                               End;

                             For o := 1 To m.zeile Do
                               Begin
                                 if high[n] then setcolor (13) else setcolor (blaCK);
                                 str(m.inhalt[n,o]:5:2, s);
                                 str (n,s2);
                                 outtextxy (15,(n-scroll+1)*8+20,s2+' '+names[n]);
                                 outtextxy (o*50+30, (n-scroll+1)*8+20, s);
                                 If flags[n,o] Then outtextxy (o*50+60,(n-scroll+1)*8+20,
                                   'X');
                               End;
                           End;
                       End
                     Else
                       Begin
                         If i < 57 Then
                           Begin
                             rectangle (10,i*8+14,(m.zeile+1)*50+30,i*8+22);
                             i := i+1;
                           End;
                       End;
                   End;
               End;
          #77 (*RIGHT*):
               Begin
                 If j < m.zeile Then
                   Begin
                     rectangle (j*50+30, 7, j*50+70, (m.spalte+1)*8+25);
                     j := j+1;
                   End;
               End;

          #79,#101 (*END,Esc-e*): begin changes := true; exit; end;
          #83,#100 (*DEL,Esc-d*):

          
               Begin
                 opengwindow(50,200,590,280);
                 outtextxy (80,220,'ARE YOU SURE YOU WANT TO DELETE ALL FLAGS ON SCREEN ??? (Y/N)');
                 setcolor (black);
                 Repeat
                   ch := readkey;
                   If upcase(ch) In ['N','Y'] Then
                     Begin
                       outtextxy (100,250,ch);
                     End;
                 Until upcase(ch) In ['N','Y'];
                 delay (800);
                 If upcase(ch) = 'Y' Then
                   Begin
                     For n := 1 To m.spalte Do
                       Begin
                         For o := 1 To m.zeile Do
                           Begin
                             flags[n,o] := false;
        {  setcolor (black);
          outtextxy (o*50+60,n*8+20,'X');
          setcolor (white); }
                           End;
                       End;
                   End;
                 goto jump;
               End;
        End;
      End;
    If ch = chr (13) Then
      Begin
        setcolor (black);
        If flags[i-2+scroll,j] Then flags[i-2+scroll,j] := false
        Else
          flags[i-2+scroll,j] := true;
        For n := scroll To m.spalte Do
          Begin
            For o := 1 To m.zeile Do
              Begin
                If flags[n,o] Then begin
                 if high[n] then setcolor (13) else setcolor (black); end
                 Else setcolor (white);
                outtextxy (o*50+60,(n-scroll+1)*8+20,'X');
              End;
          End;
      End;
  Until false;


End;



Procedure GRAFIKROTATION (x,y:integer; Var m:matrix);

  Var 
    speed,gesamtrot,i,j: integer;
    xs,ys,bez: string;
    ch: char;
    pixel: punkt;


  Procedure strichelsequenz;

  Var s,c: integer;
      b: boolean;
  Begin
    s := 100;
    c := 1;
    Repeat
      if (c <> 6) and (c <> 16) then
      line (s,237,s,243) else line (s,230,s,250);
      c := c+1;
      s := s+22;
    Until s > 540;
        s := 25;
        c := 1;
    b := true;
    Repeat
      if (c <>6) and (c<> 16) then
      line (317,s,323,s) else line (310,s,330,s);
      c := c+1;
      If b Then
        Begin
          s := s + 21;
          b := false;
        End
      Else
        Begin
          s := s+ 22;
          b := true;
        End;
        Until s > 455
  End;

  Procedure umrechnen (Var p: punkt; a,b: real);    (*berechnet neuen Masstab *)
  Begin
    p.x := round(a* 220);
    p.y := round(b* 215);
  End;

  Procedure monitorkoordinaten (Var p:punkt);       (*berechnet Pixelkoordinaten *)
  Begin
    p.x := 320+p.x;
    p.y := 240-p.y;
  End;

  Procedure pixelsetzschleife(col1:byte);

  Var i: integer;
    b1,b2: string;
  Begin
    For i := 1 To m.spalte Do
      Begin          (* Pixelsetzschleife *)
        umrechnen(pixel, m.inhalt[i,x], m.inhalt[i,y]);
        monitorkoordinaten(pixel);
        If (col1 = black) And high[i] Then
          putpixel (pixel.x, pixel.y, 13)
        Else putpixel (pixel.x,pixel.y, col1);
        str(i,b1);
        setcolor (col1);

        If (col1= black) And high[i] Then
          setcolor (13)
        Else If col1= white Then setcolor (col1);
        outtextxy ( pixel.x+5, pixel.y-5, b1);
      End;

     str (gesamtrot, b2);      setcolor (col1);
     outtextxy (10,10,'Rotation: '+b2+chr(248));

    For i := 1 To m.spalte Do
      Begin
        If (col1= black) And high[i] Then
          Begin
            setcolor (13);
            umrechnen (pixel,m.inhalt[i,x], m.inhalt[i,y]);
            monitorkoordinaten(pixel);
            circle (pixel.x, pixel.y, 10);
          End
        Else If col1 = white Then
               Begin
                 setcolor (col1);
                 umrechnen (pixel,m.inhalt[i,x], m.inhalt[i,y]);
                 monitorkoordinaten(pixel);
                 circle (pixel.x, pixel.y, 10);
               End;
      End;
   End;

   Label neu;

  Begin
    str (x,xs);
    str(y,ys);
    {For i := 1 To 99 Do
      high[i] := false;}
    gesamtrot := 0;
    speed := 1;
    neu:
    setfillstyle(1,white);
    bar(0,0,640,480);
    
    Repeat
      SetTextStyle (ft,0,fs);
      setcolor (black);
      line (100,240,540 ,240);
      line (320, 25, 320, 455);
      strichelsequenz;
      outtextxy (550,235, xs);
      outtextxy (319,12, ys);

      settextstyle(2,0,fs);
      pixelsetzschleife(black);

      bez := '';
      ch := ' ';
      SetTextStyle (ft,0,fs);
      setcolor (black);
      outtextxy (80,455,'Use Cursors (Left/Right) to rotate - ESC to discard changes - Enter to accept changes');
      outtextxy (540,10, 'Press F1 for Help');
      str (speed,bez);
      outtextxy (10,20, 'Speed: '+bez);


      ch := readkey;
      If (ch= chr(0)) or (ch=chr(27)) Then
        Begin
          ch := readkey;
          Case ch Of
            #75 (*LEFT*):
                  Begin
                    If x<> y Then
                      Begin
                        pixelsetzschleife(white);
                        gesamtrot := gesamtrot-speed;
                        rotieren (x,y,-speed,m);
                      End;
                  End;
            #77 (*RIGHT*):
                  Begin
                    If x<> y Then
                      Begin
                        pixelsetzschleife(white);
                        gesamtrot := gesamtrot+speed;
                        rotieren (x,y,speed,m);
                      End;
                  End;
            #59,#49 (*F1,ESC-1*):
                  Begin
                    hilfe(1);
                    goto neu;
                  End;
            #73 (*PAGEUP*):
                  Begin
                    pixelsetzschleife(white);
                    gesamtrot := gesamtrot+90;
                    rotieren (x,y,90,m);
                  End;
            #81 (*PAGEDOWN*):
                  Begin
                    If x<> y Then
                      Begin
                        pixelsetzschleife(white);
                        gesamtrot := gesamtrot-90;
                        rotieren (x,y,-90,m);
                      End;
                  End;
            #82,#72 (*INS,UP*) :
                  Begin
                    highlighting;
                    goto neu;
                  End;
          End;
          If gesamtrot >= 180 Then gesamtrot := gesamtrot -360;
          If gesamtrot < -180 Then gesamtrot := gesamtrot +360;
        End;
      If (ch = '+') And (speed < 20) Then
        Begin
          speed := speed +1;
          goto neu;
        End;
      If (ch = '-') And (speed > 1) Then
        Begin
          speed := speed-1;
          goto neu;
        End;
    Until (ch = chr(13)) Or (ch = chr(27));

    If (ch = chr(13)) And (gesamtrot <> 0) Then
      Begin
        sicherheitskopie(datei,m);
        make_qan;
        datei_qan(x,y,gesamtrot,datei);
        For i := 1 To 400 Do
          For j := 1 To 8 Do
            flags[i,j] := false;
      End
    Else
      rotieren (x,y,-gesamtrot,m);


  End;


Procedure ausgabe (Var m:matrix);

Var 
  i,j,scroll : integer;
  s: string;
  ch: char;

      Procedure choose_em;

      Var ch,limit: char;
          l: string;
          e,x,y,err: integer;
      Begin
        str(m.zeile,l);
        limit := l[1];
        If m.zeile = 0 Then exit;
        opengwindow(50,200,590,280);
        outtextxy (80,220,'Insert two factors, ESC to discard');
        setcolor (black);
        e := 0;
        Repeat
          ch := readkey;
          If (ch In['1'..limit]) Then
            Begin
              If e=0 Then
                Begin
                      e := 1;
                      val (ch,x,err);
                      outtextxy (80,250,ch+'   AND    ');
                End
              Else
                Begin
                      val (ch,y,err);
                  e := 2;
                      outtextxy (80,250,'             '+ch);
                End;
            End;
        Until (e=2) Or (ch = chr(27));
        If e=2 Then
          Begin
            delay (500);
            grafikrotation(y,x,m);
            changes := true;
          End;
      End;

      Procedure invert_it;

      Var ch,limit: char;
          l: string;
          e,x,err: integer;
      Begin
        str(m.zeile,l);
        limit := l[1];
        If m.zeile = 0 Then exit;
        opengwindow(50,200,590,280);
        outtextxy (80,220,'Insert a factor to invert');
        setcolor (black);
        Repeat
          ch := readkey;
          if ch = chr(27) then exit;
          If (ch In['1'..limit]) Then
            Begin
                      val (ch,x,err);
                      outtextxy (80,250,ch);
                      For e := 1 To m.spalte Do
                        m.inhalt[e,x] := -m.inhalt[e,x];
                      End;
        Until ch In ['1'..limit];
        delay (700);
        changes := true;
        sicherheitskopie(datei,m);
        make_qan;
        datei_qan(x,x,180,datei);

      End;

      Procedure get_it;

      Var ch: char;
          l: string;
      Begin
        If Not commando  Then
          Begin
            opengwindow(50,200,590,280);
            outtextxy (80,220,'Insert name of PQMethod study, ESC to discard');
            setcolor (black);
            l := '';
            ch := readkey;
            If ch = #27 Then exit;  (*Esc*) 
            Repeat
              if ch = chr(8) then reduce_string(l,1) else
              l := l+ch;
              outtextxy (80,250,l);
              ch := readkey;
              If ch = #27 Then exit; (*Esc*) 
            Until (ch = chr(13)); (*Enter*)
            delay (700);
            checkfile(l,pfad,l,ext);
            matrixeinlesen(l,m);
          End
        Else
          Begin
            matrixeinlesen(datei,m);
            commando := false;
          End;
      End;

      Procedure pre_flag_it;

      Var i,j: integer;
          n,q: real;

      Begin
        If m.spalte = 0 Then exit;
        For i := 1 To m.spalte Do
          For j := 1 To m.zeile Do
            flags[i,j] := false;
        n := 1.96 / sqrt(NItems);
        For i := 1 To m.spalte Do
          Begin
            q := 0;
            For j := 1 To m.zeile Do
              q := sqr(m.inhalt[i,j])+q;
            q := sqrt(q / 2);
            For j := 1 To m.zeile Do
              If  (abs(m.inhalt[i,j]) >= q) And (abs(m.inhalt[i,j]) > n)
                Then
                Begin
                  flags[i,j] := true;
                End;
          End;
        changes := true;
      End;

Begin
  scroll := 1;
  repeat
    setfillstyle (1,white);
    bar(0,0,640,480);

    setcolor (black);
    SetTextStyle (ft,0,fs);
    For i := scroll To m.spalte Do
      Begin
        if high[i] then setcolor (13) else setcolor (black);
        str (i,s);
        outtextxy (15,(i-scroll+1)*8+20, s+' '+names[i]);
      End;
    For j := 1 To m.zeile Do
      Begin
        str (j,s);
        setcolor (black);
        outtextxy (j*50+50, 10, s);
      End;
    For i := scroll To m.spalte Do
      Begin
        For j := 1 To m.zeile Do
          Begin
            if high[i] then setcolor (13) else setcolor (black);
            str (m.inhalt[i,j]:5:2, s);
            outtextxy (j*50+30, (i-scroll+1)*8+20, s);
            If flags[i,j] Then outtextxy (j*50+60,(i-scroll+1)*8+20,'X');
          End;
      End;

    If m.spalte > 56 Then
      Begin
        settextstyle (0,0,1);
        setcolor (red);
        If scroll > 1 Then outtextxy (485,460,chr(30));
        If scroll < m.spalte-56 Then outtextxy (485,470,chr(31));
      End;

    setcolor (black);
    line (481,0,481,480);
    setcolor (black);
    settextstyle (ft,0,fs);
//TT    Multx := 1 ;Divx := 2 ; Multy := 1; Divy := 2;
//TT    settextstyle (5,HorizDir,fs);
//TT    SetUserCharSize(MultX, DivX, MultY, DivY);
    outtextxy (490,50,' Options:');
    outtextxy (490,80,'F1: Help');
    outtextxy (490,110,'F2: Get factor matrix');
    outtextxy (490,120,'    from a PQMethod study');
    outtextxy (490,140,'F3: Choose cases to');
    outtextxy (490,150,'    highlight');
    outtextxy (490,170,'F4: Choose two factors');
    outtextxy (490,180,'    and rotate them');
    outtextxy (490,200,'F5: Invert a factor');
    outtextxy (490,220,'F6: Perform automatic');
    outtextxy (490,230,'    pre-flagging');
    outtextxy (490,250,'F7: Manually flag factors');
    outtextxy (490,270,'F8: Save factor matrix');
    outtextxy (490,280,'    in a PQMethod file');
	outtextxy (490,330,'F9: Bye, Bye');
    outtextxy (490,360,'______________________');
	outtextxy (490,400,'Use Esc-1 to Esc-9 ');
	outtextxy (490,410,'if function keys don''t');
	outtextxy (490,420,'work for you ');
    If Not commando Then
      Begin
        ch := readkey;
        If (ch= chr(0)) or (ch=chr(27)) Then
          Begin
            ch := readkey;
            Case ch Of
              #80 (*DOWN*):
                   Begin
                     If scroll <= m.spalte-56 Then scroll := scroll +1;
                   End;
              #72 (*UP*):
                   Begin
                     If scroll > 1 Then scroll := scroll-1;
                   End;
              #73 (*PAGEUP*):
                   Begin
                     If scroll > 10 Then scroll := scroll-10
                     Else
                       Begin
                         If (scroll > 1) And (scroll <= 10) Then scroll := 1;
                       End;
                   End;
              #81 (*PAGEDOWN*):
                   Begin
                     If scroll <= m.spalte-66 Then scroll := scroll+10
                     Else
                       Begin
                         If (scroll <= m.spalte-55) And (scroll > m.spalte-66) Then scroll
                           := m.spalte-55;
                       End;
                   End;
              #71,#104 (*HOME,ESC-h*): scroll := 1;
              #79,#101 (*END,Esc-e*): scroll := m.spalte-55;
              #59,#49 (*F1,ESC-1*):  hilfe(2);
              #62,#52 (*F4,ESC-4*): choose_em;
              #63,#53 (*F5,ESC-5*): invert_it;
              #65,#55 (*F7,ESC-7*): flag_it(m);
              #64,#54 (*F6,ESC-6*): pre_flag_it;
              #60,#50 (*F2,ESC-2*):
                   Begin
                     ch2 := 'A';
                     if changes then begin
                      ch2 := wannasave;
                      if ch2 = 'Y' then matrixspeichern(datei,m);
                     end;
                     if ch2 <> chr(27) then begin
                     get_it;
                     scroll := 1;
                     end;
                   End;
              #66,#56 (*F8,ESC-8*): matrixspeichern (datei,m);
              #61,#51 (*F3,ESC-3*): highlight_matrix;
              #67,#57 (*F9,ESC-9*):
                        Begin
                         ch2 := 'A';
                          if changes then begin
                          ch2 := wannasave;
                           if ch2 = 'Y' then matrixspeichern(datei,m);
                          end;
                          if ch2 <> chr(27) then begin
                          closegraph;
                          exit;
                          end;
                        End;
            End;
          End;
      End
    Else
      Begin
        get_it;
        scroll := 1;
      End;
  Until false;

End;


Procedure Abort(Msg : String);
Begin
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
End;

Begin

  pfad := ''; ext := ''; datei := '';
  changes := false;
  commando := false;
  qs := false;
  t := 0;
  
  If ParamCount = 0 then begin hilfe(3);
                        {      writeln;
                               writeln ('Press ESC to quit, any other key will launch PQRot...');
                               ch := readkey;
                               if ch =chr(27) then exit;}
                         delay (2500);
                         end;


  If (ParamCount < 4) And (ParamCount >=1) Then  
    Begin

          If (ParamStr(1) = '/?')Or (ParamStr(2)='/?')
             Or (ParamStr(3)='/?') Then
            Begin
              hilfe(3);
              halt;
            End;

      If ParamCount=2 Then
        Begin
          str1 := '';
          str2 := '';
          strp := ParamStr(1);
          For gd := 1 To length(strp) Do
             str1 := str1 + upcase(strp[gd]);
          strp := ParamStr(2);
          For gd := 1 To length(strp) Do
             str2 := str2 + upcase(strp[gd]);
          If (str1='/QS') Then
            Begin
              qs := true;
              datei := ParamStr(2);
              checkfile(datei,pfad,datei,ext);
              commando := true;
            End;
          If (str2='/QS') Then
            Begin
              qs := true;
              datei := ParamStr(1);
              checkfile(datei,pfad,datei,ext);
              commando := true;
            End;
        End;

      str1 := '';
      strp := ParamStr(1);
      For gd := 1 To length(strp) Do
             str1 := str1 + upcase(strp[gd]);

      If (ParamCount=1) And (str1 <> '/QS') Then
        Begin
          datei := ParamStr(1);
          checkfile(datei,pfad,datei,ext);
          commando := true;
        End;
      If (ParamCount=1) And (str1 ='/QS') Then qs := true;
     End;


  If (ParamCount>0) Then
    Begin
 {     clrscr; }
      writeln ('PQROT 2.0 for Windows etc.');
      writeln ('High Resolution Hand Rotation for PQMethod');
      writeln ('written by Andreas Zollorsch & Peter.Schmolck@web.de');
      delay (2500);
    End;

   m.spalte := 0;
   m.zeile := 0;
   
{SMK: seems to me that gd and gm are "borrowed" here for some unrelated purpose. }  
   For gd := 1 To 400 Do
     For gm := 1 To 8 Do
       flags[gd,gm] := false;

{--------------------------------------------------------------------
 SMK: Regarding GraphicsDriver see next comment.  Error checking does not seem 
 necessary to me, since fpc does not require the EGAVGA.BGI file with its location.
 
   gd := detect;
   If gd <> 0 Then
     Begin
       writeln ('Your graphic-interface cannot handle the recommended specifications!');
       writeln ('Programm terminated');
       halt;
     End;
}


{-------------------------------------------------------------------
 SMK: I do not understand Andreas' reasoning for selecting GraphicsDriver (gd) and
 GraphicsMode (gm). With "gd := detect;", as I understand, the optimal mode (highest
 possible resolutions) is selected. The rectangle used for the plot, however,  is VGA mode 
 only. It would be possible, but was not done by Andreas, to scale all graphic output to 
 the (maximal possible) resolution selected. 
 It appears to me also that free pascal does not require a graphic driver file (like EGAVGI.bgi)
 which the executable can access at a location specified in the source code. 
-------------------------------------------------------------------}

 gd := VGA;
 gm := m640x480x16; 
   checkfile(paramStr(0),bgipfad,str1,str2);
   initgraph(gd,gm, bgipfad); 

  For gd := 1 To 400 Do
  high[gd] := false;
  ausgabe(m);

  closegraph;
End .
