C **************************************************************
C Most recent versions of PQMethod executables and source files 
C are available at http://schmolck.org/qmethod
C 
C
C **************************************************************
C                 INSTRUCTIONS FOR COMPILATION
C This code can be compiled with the GNU G77 and GFORTRAN Fortran compilers 
C
C **************************************************************
C
C QMETHOD Program of John R. Atkinson (atkinson@kentvm.kent.edu)
C Version of Dec 93; available via ftp ksuvxa.kent.edu, in directory
C qmethod, file vqmeth.for. See additional files: qmethod.hlp, xq-com.
C
C Modified by Peter Schmolck (p41bsmk@web.de), with this
C version encorporating also some modifications by
C   Dr. Michael Strobel              Pr. Dennis Valois
C  Departement de psychologie  and   Departement d'informatique et d'ingenieurie
C  Universite de Montreal            College militaire royal de St-Jean
C
C For file name assignments see subroutine ASSFIL near the end of the
C source file.
C
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***     MAIN     ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C SMK: Inserted a 'close all files' (CALL CLOSFS) each time the
C main menue pops up with "Last Routine Run Successfully" and
C reopen files (CALL ASSFIL) after the user has selected routine.
C Gives the opportunity to manipulate files (task switching in
C Windows) without leaving PQMETHOD; might be dangerous (?)
C
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      CHARACTER*1 ANS
      CHARACTER*20 LAST1
      LOGICAL VARIMX
      LOGICAL EXST, ERRDAT
C
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
C
      DATA EXST/.FALSE./
C
      WRITE(*,*)
      WRITE(*,*)
      WRITE(*,'(10X,A)')
     * '+---------------------------------------------------+',
     * '|                  PQMethod - 2.35                  |',
     * '|                     (Mar 2014)                    |',
     * '+---------------------------------------------------|',
     * '|                  by Peter Schmolck                |',
     * '|      Adapted from Mainframe-Program QMethod       |',
     * '|              by John Atkinson at KSU              |',
     * '+---------------------------------------------------|',
     * '|                 The QMethod Page:                 |',
     * '|            http://schmolck.org/qmethod/           |',
     * '+---------------------------------------------------+'
      WRITE(*,*)
      WRITE(*,*)
C
C Open files
C
      CALL ASSFIL(.TRUE.,PRNAME,FNAME)
C
C Start of main program loop
C
      LAST1='(Initial)'
C
   10 CONTINUE
C
C     CALL CLRSCR       Clear screen function on full screen systems
C     CALL CLRSCR
C
      WRITE(*,*) ' '
      WRITE(*,*) 'Current Project is ...  ',FNAME(1:LENGTH(FNAME))
      WRITE(*,*) 'Choose the number of the routine you want ',
     1         'to run and enter it.'
      WRITE(*,*) ' '
      WRITE(*,*) ' 1 - STATES   - Enter (or edit) the file of ',
     1         'statements'
      WRITE(*,*) ' 2 - QENTER   - Enter q sorts (new or continued)'
      WRITE(*,*) ' 3 - QCENT    - Perform a Centroid factor ',
     1         'analysis '
      WRITE(*,*) ' 4 - QPCA     - Perform a Principal Components',
     1         ' factor analysis'
      WRITE(*,*) ' 5 - QROTATE  - Perform a manual rotation of the',
     1         ' factors'
      WRITE(*,*) ' 6 - QVARIMAX - Perform a varimax rotation of the',
     1         ' factors'
      WRITE(*,*) ' 7 - QANALYZE - Perform the final Q analysis of ',
     1         'the rotated factors'
      WRITE(*,*) ' 8 - VIEWLIST - View output file ',
     1  PRNAME(1:LENGTH(PRNAME)) //'.lis'
      WRITE(*,*) ' X - Exit from PQMethod'
      WRITE(*,*) ' '
      WRITE(*,*) '   Last Routine Run Successfully - ',LAST1
      WRITE(*,*)
C
      CALL CLOSFS
C
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
         ANS = '0'
      ENDIF
C
      CALL ASSFIL(.FALSE.,PRNAME,FNAME)
C
CSMK (2.11) Added ERRDAT-handling with sub VARMAX
C
      IF(ANS.EQ.'1') THEN
        CALL STATIN (PRNAME,FNAME)
        LAST1 = 'STATES'
      ELSE IF(ANS.EQ.'2') THEN
           CALL ENTER(EXST)
           LAST1 = 'QENTER'
          ELSE IF(ANS.EQ.'3') THEN
               CALL QCENT (FNAME)
               LAST1 = 'QCENT'
          ELSE IF(ANS.EQ.'4') THEN
               CALL QPCA (FNAME)
               LAST1 = 'QPCA'
            ELSE IF(ANS.EQ.'5') THEN
                 VARIMX = .FALSE.
                 CALL QROTAT( VARIMX )
                 LAST1 = 'QROTATE'
              ELSE IF(ANS.EQ.'6') THEN
                   VARIMX = .TRUE.
                   CALL VARMAX (ERRDAT)
                   IF(.NOT.ERRDAT) THEN
                     CALL QROTAT( VARIMX )
                     LAST1 = 'QVARIMAX/QROTATE'
                   END IF
                ELSE IF(ANS.EQ.'7') THEN
                     CALL QANAL (FNAME)
                     LAST1 = 'QANALYZE'
                  ELSE IF(ANS.EQ.'8') THEN
                       CALL VIEWFS (PRNAME)
                       LAST1 = 'View files'
      ENDIF
C
      IF(ANS.EQ.'x'.OR.ANS.EQ.'X') GO TO 999
      GO TO 10
  999 CONTINUE
C
C
      CALL EXITPR
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    STATIN    ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C*******************************************************************
C(2.35) STATIN thoroughly revised. Discarded option to import 
C statements from an existing file as well as the old method of
C entering statement by statement without using an external editor. 
C The file <project>.sta is still check whether it exists, and how many
C lines it contains. The user is informed about the number of records 
C found in the filed, and warned if there are empty lines. 
C But otherwise the file is not touched, i.e., the records are not 
C shortened to 60 chars as in versions up to 2.34. 
C As before, the external EDITOR (according to environment variable) is
C started in any case (unless not found, of course). 
C*******************************************************************

      SUBROUTINE STATIN (PRNAME,FNAME)
      CHARACTER*60 STATXT
      CHARACTER*60 HLDTXT
      CHARACTER*3 NUMB
      CHARACTER*8 PRNAME
      CHARACTER*64 FNAME,EDITOR,WINDIR
C      INTEGER*2 ISTAT
      LOGICAL DIGIT, LEXIST, LEDITO
C
C(2.10) Check whether there is a valid definition for an external
C editor. But, different from 2.09, do not yet launch editor. 
C
      LEDITO=.FALSE.
      CALL GETENV ("EDITOR",EDITOR)
      IF (EDITOR.NE." ") THEN
        INQUIRE(FILE=EDITOR,EXIST=LEDITO)
        IF(.NOT.LEDITO) THEN
          WRITE(*,*) "External editor ", EDITOR(1:LENGTH(EDITOR)),
     1    " not found"
          WRITE(*,*) "Hit <ENTER> to continue"
          READ(*,*)
        END IF
      END IF
C
C Section inserted since version 2.0e which first checks whether
C statements have been entered already, and if that is the
C case, informing the user about number of records and
C a warning if empty lines found (new in 2.34)
C
      HLDTXT=FNAME(1:LENGTH(FNAME))//'.sta'
  101 WRITE(*,*) 'Checking file ',HLDTXT
      WRITE(*,*) 'for statements entered already ...'
C
C Read in the current statement text (if already there)
C 
      NEMPTY=0
	  DO 105 I=1,200
      READ(1,'(A60)',END=106,ERR=106) STATXT
	  IF(LENGTH(STATXT).LE.1) NEMPTY=NEMPTY+1
  105 CONTINUE
  106 CONTINUE
      IF(I.GT.1) GOTO 150
C
C No statements found
C
      HLDTXT=PRNAME(1:LENGTH(PRNAME))//'.lis)'
C	  HLDTXT=HLDTXT(1:LENGTH(HLDTXT)) 
      WRITE(*,*)
	  WRITE(*,*) '... no statements found in that file. '
      WRITE(*,*) 
      WRITE(*,*) 
     1 'PQMethod stores statements used for a Q project in a plain '
      WRITE(*,*) 
     1 'text file, one record for every statement. '
	  WRITE(*,*)
      WRITE(*,*) 
     1 'Please note that the final output tables (in ', 
     1 PRNAME(1:LENGTH(PRNAME)),'.lis)' 
      WRITE(*,*) 
     1 'cut every statement to a maximal length of 60 characters.'
      WRITE(*,*) 
          WRITE(*,*) "Hit <ENTER> to continue"
          READ(*,*)
      WRITE(*,*) 
      GOTO 160
C
C Statements found
C 

  150 WRITE(*,*)
      WRITE(*,'(I4,A,A)') I-1, ' Statements seem to have been ',
     1 'entered so far ...'
	  IF(NEMPTY.GT.0) 
     2 WRITE(*,*)  'WARNING: ', NEMPTY, ' empty lines found.'
C
C
  160 CONTINUE
      CLOSE (1)
C
C(2.10) Launch external editor now (if it exists).
C(2.34) Added more information for user  
C
      IF(.NOT.LEDITO) RETURN
 70   WRITE(*,*) "Launching the external editor: (",
     1 EDITOR(1:LENGTH(EDITOR)) // ') ... '
      WRITE(*,*)
      WRITE(*,*) "When you are finished with entering or editing ",
     1 "the statements "
      WRITE(*,*) "and quit the editor, you will return to PQMethod."
      WRITE(*,*) "Hit <ENTER> to continue"
      READ(*,*)
      CALL CLOSFS
      CALL SYSTEM(EDITOR(1:LENGTH(EDITOR)) // ' ' 
     1   // PRNAME(1:LENGTH(PRNAME)) // '.sta', ISTAT)
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    ENTER     ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE ENTER(EXST)
C
C Qenter is a program designed to input the data from one or several
C Q sorts.  The data is transposed for output, so that it can be
C analyzed by any correlation routine.  The output matrix will,
C of course, have rows for each statement, and columns in i2 format
C for the subjects.  The data elements will be the statement values.
C
C Limits:  200 statements
C          299 subjects
C          Q-Sort ranging from -6 to +13
C                 (the assumption is a symmetric matrix,
C                  from -5 to +5, or from 1 to 11, e.g.)
C          Q-Sort depth of 50 (max for any column)
C
C The q design must be symmetric.  That is, there must be an odd
C number of columns, and the depths of columns equi-distant from the
C center must be the same.  Also, the number of columns must not be
C greater toward either end of the sort.
C
C Thus a sort will look something like:
C
C        -4   -3   -2   -1    0    1    2    3    4
C      !----!----!----!----!----!----!----!----!----!
C      ! NN ! NN ! NN ! NN ! NN ! NN ! NN ! NN ! NN !
C      !----!----!----!----!----!----!----!----!----!
C      ! NN ! NN ! NN ! NN ! NN ! NN ! NN ! NN ! NN !
C      !----!----!----!----!----!----!----!----!----!
C           ! NN ! NN ! NN ! NN ! NN ! NN ! NN !
C           !----!----!----!----!----!----!----!
C                     ! NN ! NN ! NN !
C                     !----!----!----!
C
C The assumption for each qsort entered is that it looks approximately
C like the designed sort, though it is not required.  When the program
C displays the sort, it will print the boxes of the design, but over-
C lay it with the actual data, even if it does not fit the boxes.
C
C The statement numbers must be consecutively numbered and each must
C occur once and only once in the sort.  A check is made by the program
C and any deviance must be fixed.
C
C General procedure:
C
C  For the design of the study:
C
C    Q asks if this is a continuation (data entered previously)
C       (if so, reads the old file into the data matrix first,
C        and bypasses the next four questions.)
C    Q asks for the number of statements
C    Q asks for the value of the left-most column
C    Q asks for the value of the right-most column
C    Q asks for the depth of each column, from left to right.  These
C        numbers are entered on one line.  For example, if you were
C        using the sort displayed above, you would respond,
C              2 3 3 4 4 4 3 3 2
C        Note that the pattern must be symmetric, with an odd number
C             of columns.
C
C  For each individual:
C
C    Q then asks for the numbers of the statements for each of the
C        values, starting at the left.  You can only enter the numbers
C        of the statements for one value at a time, but you must enter
C        all of them at once, for example, 2 9 12 34, for column -2.
C    When all of the statement numbers have been entered, Q checks to
C        see that each statement was entered once and only once.  If
C        there is an error, or if the user desires, Q will go back to
C        the step for entering each number again.  On the second time
C        through, you ask for just the column you wish to update.
C    When a sort is accepted, you can enter another sort, or end the
C        program.  If desired, you can stop and continue later.  When
C        you wish to end data entry, an output matrix is created for
C        input to a correlation program (or continuation next time).
C
C    Anytime during the program, you can ask to stop or quit, and Q
C        will drop back to the next level.  For instance, if you are
C        entering an individual sort and have to quit, just enter
C        'quit' instead of the correct numbers, and Q will ask you if
C        you want to enter another sort.  Just say no to exit the
C        program.  Of course you save everything up to that point
C        for the next time (but not the sort you were entering).
C
C    In addition to adding new sorts, you also have the option of
C        changing or deleting previously entered sorts.  These options
C        are chosen from a main menu presented when this program is run.
C
C Variables:
C        PRTITL    The title of the project
C        PERSON    The number of subjects
C        CURRNT    The number of the current subject
C        STATES    The number of statements
C        LOW       The left-most column value (-6 is lowest)
C        HIGH      The right-most column value (13 is highest)
C        BIGCOL    The value of the deepest column for the design
C        IBGCOL()  The value of the deepest column for each individual
C        VERTSZ()  The depth of each column of the design.
C                    (columns can have values from -6 to 13)
C        IVRTSZ()  The depth of each column for each individual
C        LEFT()    The number of spaces to the left for the design
C                    of the Q sort on the terminal (for centering)
C        ROWSZ()   The number of entries in each row of the sort design
C        CHEADS()  The numbers given to the columns (from -6 to 13)
C        QSORT()   The matrix of statement numbers for current subject
C        FMT1      The created format for each data line of the
C                    displayed Q sort
C        FMT2      The created format for the separater lines
C        QOUT()    The output matrix.  The columns are the statements
C                    and the rows are the subjects.  The entries are
C                    the values assigned to the statements.
C        LINE      Used to read from the terminal in character format
C        ANS       Used to read simple yes/no answers from the terminal
C
C   SUBROUTINE INIT:
C        OK        Is design correct?
C
C   SUBROUTINE verif:
C        DUPL()    Statements that have been entered more than once
C        ZERO()    Statements that have been omitted
C        TOOBIG()  Statements that are bigger than the number allowed
C        STAT()    Holds all the statement numbers entered
C        STAT2()   Holds the frequencies for each statement entered
C        QSUM      Sum of the statement values
C        QMEAN     Mean of the statement values
C        OK        Logical - has q sort been entered correctly?
C
C**********************************************************************
C
      INTEGER STATES, LOW, HIGH, BIGCOL, PERSON, NFAX, CURRNT
      INTEGER IBGCOL(299), IVRTSZ(299,-6:13)
      INTEGER VERTSZ(-6:13), QSORT(50,-6:13), CHEADS(-6:13)
      INTEGER ROWSZ(50),LEFT(50)
      INTEGER QOUT(200,299)
      LOGICAL DIGIT
      CHARACTER*80 FMT1,FMT2
      CHARACTER*299 LINE
      CHARACTER*1 ANS,HLDANS,UPCHAR
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      LOGICAL OK
      LOGICAL EXST
C
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
C
      DATA QSORT/1000*0/,PERSON/0/,LEFT/50*0/,IBGCOL/299*0/,
     1     IVRTSZ/5980*0/,
     2     CHEADS/-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13/
C
C---------------------------------------------------------------------
      NFAX = 0
C
      CALL READOL (NFAX,PERSON,STATES,LOW,HIGH,VERTSZ,QOUT,
     1   BIGCOL,LEFT,ROWSZ,IVRTSZ,IBGCOL,EXST)
      IF(.NOT.EXST) GOTO 60
C
C Write out $HLDENT$/.ent file necessary only in older versions of
C QMethod (up to 1.14) for continuation runs.
C Uncomment the following lines if you wish let PQMethod output
C that file for use with older versions. In addition, you must
C uncomment also the 'OPEN (2 ...' statement in ASSFIL.
C 
C      WRITE(2,830) STATES,LOW,HIGH,BIGCOL,VERTSZ,LEFT,ROWSZ
C      WRITE(2,840) ((IVRTSZ(II,JJ),JJ=-6,13),II=1,PERSON),
C     1             (IBGCOL(KK),KK=1,PERSON)
C830   FORMAT(4I3,3X,20(I3),/,25(I3),/,25(I3))
C840   FORMAT(40I2)
C
      REWIND (11)
C
      GO TO 80
C
C   Read the design the first time through the project
C
   60 CONTINUE
      REWIND (11)
      WRITE(*,*)
     1   'Enter the title of your study to a max of 68 characters.'
      WRITE(*,860)
860   FORMAT(' ',68('_')/)
      READ(*,'(A68)',IOSTAT=IO) PRTITL
      IF (IO .LT. 0 .OR. PRTITL .EQ. ' ') THEN
         WRITE(*,*) 
     1      'You must enter a title, even if just one character.'
         GO TO 60
      ENDIF
C
   70 CONTINUE
      CALL INIT(STATES,LOW,HIGH,VERTSZ,BIGCOL,ROWSZ,OK,LEFT)
      IF(STATES.EQ.0) GO TO 210
      IF(OK) GO TO 80
      WRITE(*,*) 'Q-Sort structure is not balanced.  Please re-enter.'
      WRITE(*,*)
      GO TO 70
C---------------------------------------------------------------------
   80 CONTINUE
C     CALL CLRSCR       Clear screen function on full screen systems
C     CALL CLRSCR
      WRITE(*,*) 
      WRITE(*,*) 'Ready to process another sort.'
      WRITE(*,*) 'Enter one of the following codes:'
      WRITE(*,*) 
      WRITE(*,*) 'A - to add a new sort'
      WRITE(*,*) 'C - to change a previous sort'
      WRITE(*,*) 'D - to delete a sort'
      WRITE(*,*) 'S - to show a previous sort'
      WRITE(*,*) 'Q - to query status of this study'
      WRITE(*,*) 'X - to exit QENTER (stop entering/changing sorts)'
      WRITE(*,*)
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
         ANS = 'Q'
      ENDIF
      OK=.TRUE.
      ans = upchar(ans)
      HLDANS=ANS
      IF(ANS.EQ.'A')GO TO 130
      IF(ANS.EQ.'X')GO TO 190
      IF(ANS.EQ.'Q')GO TO 180
      IF(ANS.EQ.'D'.OR.ANS.EQ.'C'.OR.ANS.EQ.'S')GO TO 90
      GO TO 80
C
C------------------------------------------------------------------
   90 CONTINUE
C
C They want a delete, a show, or a change!
C
      IF (HLDANS.EQ.'S') THEN
       WRITE(*,*) 'Enter the number of the sort '
      ELSE
       WRITE(*,*) 'Enter the number of the sort (do not worry if you'
       WRITE(*,*) ' are wrong, since you must confirm any updates).'
      ENDIF
      WRITE(*,*) ' '
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
         GO TO 80
      ENDIF
      IF(.NOT.DIGIT(LINE(1:1))) GO TO 80
CMS      CALL PUTTMP(LINE)
      READ(LINE,*,IOSTAT=IO) CURRNT
      IF(CURRNT.GT.0.AND.CURRNT.LE.PERSON.AND.IO.EQ.0) GO TO 100
      WRITE(*,*) 'This is not a valid Q-Sort number - ',LINE(1:15)
      WRITE(*,*) ' '
      GO TO 90
C
C Reload QSORT (the current qsort) from QOUT (the master array)
C
C(2.33) The irregular case with all zero items (or more than 50 item 
C numbers in any category) is trapped now to prevent PQMethod from crashing 
C
  100 CONTINUE
C
      DO 105 JJ=-6,13
      DO 105 KK=1,50
      QSORT(KK,JJ)=0
  105 CONTINUE
C
      DO 120 JJ=LOW,HIGH
      KK=1
      DO 110 II=1,STATES
        IF(QOUT(II,CURRNT).EQ.JJ) THEN
           IF(KK.GT.50) GOTO 121
           QSORT(KK,JJ)=II
           KK=KK+1
        ENDIF
  110 CONTINUE
  120 CONTINUE
C
      IF(ANS.EQ.'C'.OR.ANS.EQ.'S')GO TO 140
      GOTO 128
  121 WRITE(*,*) ' '
      WRITE(*,*)  
     1 ' Sort number ', CURRNT, ': ', SORTID(CURRNT),
     2 ' has more than 50 items in a category, ' 
      WRITE(*,*)  
     1 ' and therefore cannot be displayed on screen.' 
      WRITE(*,*) ' '
      GOTO 129 
C
C They want a delete!
C
C
  128 CALL PRTSRT(FMT1,FMT2,CHEADS,LOW,HIGH,IBGCOL,LEFT,ROWSZ,
     1            QSORT,BIGCOL,CURRNT,SORTID(CURRNT))
  129 WRITE(*,*) 'Delete this entry? (answer Y to delete): '
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
         ANS='N'
      ENDIF
C
      IF(upchar(ANS).EQ.'Y')
     1   CALL DELONE(CURRNT,PERSON,QOUT,STATES,IBGCOL,IVRTSZ,SORTID)
C
      GO TO 80
C---------------------------------------------------------------------
  130 CONTINUE
C
C   Ready to start entering data for a new case
C
      PERSON=PERSON+1
      CURRNT=PERSON
C
      CALL FIRSTM(LOW,HIGH,QSORT,IVRTSZ,IBGCOL,CURRNT,SORTID(CURRNT))
      IF(IBGCOL(CURRNT).EQ.0) THEN
          PERSON = PERSON - 1
          GO TO 150
      ENDIF
  140 CONTINUE
      CALL PRTSRT(FMT1,FMT2,CHEADS,LOW,HIGH,IBGCOL,LEFT,ROWSZ,
     1            QSORT,BIGCOL,CURRNT,SORTID(CURRNT))
      IF(HLDANS.EQ.'S') THEN
        WRITE(*,*) ' '
        WRITE(*,*) 'Press <ENTER> to continue '
        READ(*,'(A1)',IOSTAT=IO) ANS
        GO TO 80
      ENDIF
C
C If user wants to 'c'hange allow for changing SortID here.
C Status of OK controls for entering this block only once
C (OK is .false. every time another REDO has to be done)
C
      IF (HLDANS.EQ.'C'.AND.OK) THEN
        WRITE(*,'(A,A,I3,A)') 
     1   ' Do you want to change identification code (ID)'
     2   ,' for subject no.',CURRNT, '? (y/N): '
        READ(*,'(A1)',IOSTAT=IO) ANS
        IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
           ANS = 'N'
        ENDIF
        IF(upchar(ANS).EQ.'Y') THEN
         WRITE(*,*) 'Enter new ID (max. 8 characters): '
         READ(*,'(A8)') SORTID(CURRNT)
         WRITE(*,*) 
        ENDIF
      ENDIF
C      
C(2.09) Check for current sort (whether added or changed) that 
C  not ALL items are in one pile! 
C
      IF(IBGCOL(CURRNT).LT.STATES) GOTO 141
      WRITE(*,*) 'A sort must not have ALL items in the same ',
     1 'pile. '
      WRITE(*,*) 'This sort is dropped!'
      WRITE(*,*)
      IF(ANS.EQ.'A') THEN
        PERSON = PERSON - 1
      ELSE
        CALL DELONE(CURRNT,PERSON,QOUT,STATES,IBGCOL,IVRTSZ,SORTID)
      ENDIF
      GOTO 150
C
  141 CALL verif 
     1  (QSORT,OK,STATES,LOW,HIGH,IBGCOL,CURRNT,QOUT,SORTID(CURRNT))
C
      IF(OK) GO TO 150
      CALL REDO(LOW,HIGH,QSORT,IVRTSZ,IBGCOL,CURRNT)
      IF(IBGCOL(CURRNT).EQ.0) THEN
          IF(ANS.EQ.'A') PERSON = PERSON - 1
          GO TO 150
      ENDIF
C
C Reset IBGCOL (the longest column) after a redo.
      IBGCOL(CURRNT)=0
      DO 145 ICOL=LOW,HIGH
      IF(IBGCOL(CURRNT).LT.IVRTSZ(CURRNT,ICOL))
     1   IBGCOL(CURRNT)=IVRTSZ(CURRNT,ICOL)
  145 CONTINUE
C
      GO TO 140
  150 CONTINUE
      IF(PERSON.GE.299) THEN
         WRITE(*,*)
     1    'The maximum number of subjects have been entered.'
         WRITE(*,*) 'The program must now stop.'
         GO TO 190
      ENDIF
C
  160 CONTINUE
      WRITE(*,*) 'Do you want to enter another sort? (Y/n): '
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
         ANS = 'Y'
      ENDIF
      IF(upchar(ANS).EQ.'N')GO TO 80
      IF(upchar(ANS).NE.'Y')GO TO 160
      IF(HLDANS.NE.'A')GO TO 80
      LARGEC=BIGCOL+3
      IF(LARGEC.GT.50)LARGEC=50
      DO 170 I=LOW,HIGH
      DO 170 J=1,LARGEC
      QSORT(J,I)=0
  170 CONTINUE
      GO TO 130
C
C QUERY STATUS
C
  180 CONTINUE
C     CALL CLRSCR       Clear screen function on full screen systems
C     CALL CLRSCR
C
      WRITE(*,*) ' '
      WRITE(*,*) 'Information on current study . . .'
      WRITE(*,870) PRTITL
      WRITE(*,880) LOW,HIGH
      WRITE(*,890) (VERTSZ(JJ),JJ=LOW,HIGH)
      WRITE(*,900) PERSON  !SMK (232) This line got lost in 2.31 
C
870   FORMAT (/,' Title of Study   --   ',A50)
880   FORMAT (/,' Column Range     -- ',I3,'   TO  ',I2)
890   FORMAT (/,' Depth of Columns -- ',13I3)
900   FORMAT (/,' Sorts Entered    -- ',I4)
C
      WRITE(*,*) ' '
      WRITE(*,*) 'Press <ENTER> to continue '
      READ(*,'(A1)',IOSTAT=IO) ANS
      GO TO 80
C----------------------------------------------------------------------
C
C Write out the data file and get outta here
C
  190 CONTINUE
C Write the number of people, the Qsort parameters and the title for
C the correlation program that will follow this.
C
      WRITE(16,910) NFAX, PERSON, STATES, PRTITL
910   FORMAT(3I3,1X,A68)
C
C Write the low and high values and the freqs for each level
C
      WRITE(16,920) LOW,HIGH,VERTSZ
920   FORMAT(22(I3))

C
C Write out data 
C
      IF(PERSON.EQ.0) GO TO 201
C 
CSMK (231) New tab delimted output file (.tsv, file 19), first
C          three lines with project information   
C
      WRITE(19,  "('Title of Study   --   ',A50)") PRTITL
      WRITE(19,"(/,'Column Range     -- ',I3,'   TO  ',I2)") LOW,HIGH
      WRITE(19,"(/,'Depth of Columns -- ',13I3)") 
     X   (VERTSZ(JJ),JJ=LOW,HIGH)
      WRITE(19,"(/,'Sorts Entered    -- ',I4)") PERSON
      WRITE(19,"(/,'No of Statements -- ',I4)") STATES
      WRITE(19,'(/)') 
C
      DO 200 J=1,PERSON
      WRITE(16,850) SORTID(J),(QOUT(I,J),I=1,STATES)
      WRITE(19,851) SORTID(J), (CHAR(9),(QOUT(I,J)),I=1,STATES)
 850  FORMAT(A8,2X,200(I2))
 851  FORMAT(A8,200(A1,I2))
  200 CONTINUE
      EXST=.TRUE.
  201 CONTINUE
C
CSMK: Deleted write to now obsolete work file $HLDENT$ / .ent
C
  210 CONTINUE
C
      REWIND (16)
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>        INIT        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Init simply inputs and checks the design of the qsort study.  It
C must be symetric, the numbers must check, etc.
C When run for the first time, design data are entered and checked,
C otherwise (FIRST=.FALSE.) only some additional design parameters
C are determined.
C
      SUBROUTINE INIT(STATES,LOW,HIGH,VERTSZ,BIGCOL,ROWSZ,OK,LEFT)
      INTEGER STATES, LOW, HIGH, BIGCOL
      INTEGER VERTSZ(-6:13)
      INTEGER ROWSZ(50),LEFT(50)
      CHARACTER*120 LINE
      CHARACTER*1 ANS
      LOGICAL OK
      LOGICAL DIGIT
C
C     CALL CLRSCR       Clear screen function on full screen systems
C     CALL CLRSCR
C
      STATES=0
C
      DO 10 I=-6,13
      VERTSZ(I)=0
   10 CONTINUE
      DO 20 I=1,50
      ROWSZ(I)=0
   20 CONTINUE
C
   30 CONTINUE
      WRITE(*,*) ' '
      WRITE(*,*) 'How many q statements are there? '
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
        GO TO 30
      ENDIF
      IF(.NOT.DIGIT(LINE(1:1))) THEN
        STATES=0
        GO TO 900
      ENDIF
CMS      CALL PUTTMP(LINE)
      READ(LINE,*,IOSTAT=IO) STATES
      IF(STATES.LT.3.OR.STATES.GT.200.OR.IO.GT.0) GO TO 30
C
   40 CONTINUE
      WRITE(*,*) ' '
      WRITE(*,*) 'Enter the leftmost column value (e.g. -5): '
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
        GO TO 40
      ENDIF
      IF(.NOT.DIGIT(LINE(1:1)).AND.LINE(1:1).NE.'-') THEN
        STATES=0
        GO TO 900
      ENDIF
CMS      CALL PUTTMP(LINE)
      READ(LINE,*,IOSTAT=IO) LOW
      IF(LOW.LT.-6.OR.LOW.GT.11.OR.IO.GT.0) GO TO 40
C
   50 CONTINUE
      WRITE(*,*) ' '
      WRITE(*,*) 'Enter the rightmost column value (e.g. 5): '
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
        GO TO 50
      ENDIF
      IF(.NOT.DIGIT(LINE(1:1))) THEN
        STATES=0
        GO TO 900
      ENDIF
CMS      CALL PUTTMP(LINE)
      READ(LINE,*,IOSTAT=IO) HIGH
      IF(HIGH.LT.1.OR.HIGH.GT.13.OR.IO.GT.0) GO TO 50
C
   60 CONTINUE
      WRITE(*,*) ' '
      WRITE(*,810) LOW,HIGH
810   FORMAT(' Enter the Number of Rows for each Column from',
     1       I3,' to',I3,'.',/,
     2       '  For Example:  2 3 3 4 4 4 3 3 2 : ' )
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF(IO.LT.0 .OR. LINE .EQ. ' ') THEN
        GO TO 60
      ENDIF
CMS      CALL PUTTMP(LINE)
      IF(.NOT.DIGIT(LINE(1:1))) THEN
        STATES=0
        GO TO 900
      ENDIF
C
CSMK: Next statement commented: seems an unnecessary restrictive
C     condition (first pile no more than 9 statements).
C      IF(LINE(2:2).GE.'0') GO TO 60
C
      READ(LINE,*,IOSTAT=IO) (VERTSZ(I),I=LOW,HIGH)
      IF(IO.NE.0) GOTO 60
C
      DO 70 I=LOW,HIGH
      IF(VERTSZ(I).LT.0.OR.VERTSZ(I).GT.50) THEN
        WRITE(*,*) 
        WRITE(*,*) 'Pile size must not exceed 50!'
        WRITE(*,*) 
        GO TO 60
      ENDIF
   70 CONTINUE
C
      BIGCOL=0
      DO 80 I=LOW,HIGH
      IF(BIGCOL.LT.VERTSZ(I))BIGCOL=VERTSZ(I)
   80 CONTINUE
C
C Set the row sizes for the design
C
      DO 90 I=1,BIGCOL
      DO 90 J=LOW, HIGH
      IF(VERTSZ(J).GE.I)ROWSZ(I)=ROWSZ(I)+1
   90 CONTINUE
C
      DO 100 I=1,BIGCOL
      LEFT(I) = (70-ROWSZ(I)*5)/2
  100 CONTINUE
C
C Check to see that the sort is valid.
C Are there an odd number of columns (one middle one)?
CSMK: 'Balance' doesn't actually seem to be required ...
C
      IRANGE=HIGH-LOW
      IF(0.NE.MOD(IRANGE,2)) THEN
        WRITE(*,*) 
        WRITE(*,*) 'WARNING: The design is not balanced'
        WRITE(*,*) 
CSMK        GO TO 900
      ENDIF
C
C Do the number of cells equal the number of statements?
C
      ICOUNT=0
      DO 110 I=LOW,HIGH
      ICOUNT=ICOUNT+VERTSZ(I)
  110 CONTINUE
      IF(ICOUNT.NE.STATES) THEN
        WRITE(*,*)
     1    ' The design does not match the number of statements'
        GO TO 900
      ENDIF
C
C Are the columns balanced?
C
      INCRM = ((LOW+HIGH)/2)-LOW
      DO 120 II=0,INCRM-1
      IF(VERTSZ(LOW+II).NE.VERTSZ(HIGH-II)) THEN
        WRITE(*,*) ' The design is not balanced'
        GO TO 900
      ENDIF
  120 CONTINUE
C
      OK=.TRUE.
      RETURN
C
  900 CONTINUE
      WRITE(*,*) ' The entire design will have to be re-entered.'
      WRITE(*,*) ' Press <ENTER> to continue. '
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
        ANS = 'Y'
      ENDIF
      OK=.FALSE.
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       FIRSTM       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C FIRSTM (first time) is run only once for any sort.  This creates the
C   entry, although it can be modified elsewhere.  That is, "adds"
C   come through here.
C
C
      SUBROUTINE FIRSTM(LOW,HIGH,QSORT,IVRTSZ,IBGCOL,CURRNT,ID)
C
      INTEGER LOW, HIGH, IBGCOL(299), CURRNT
      INTEGER IVRTSZ(299,-6:13), QSORT(50,-6:13)
      CHARACTER*120 LINE
      CHARACTER*8 ID
      LOGICAL DIGIT
C
      DO 10 I=-6,13
   10 IVRTSZ(CURRNT,I)=0
      IBGCOL(CURRNT)=0
C
      DO 15 JJ=-6,13
      DO 15 KK=1,50
      QSORT(KK,JJ)=0
   15 CONTINUE
C
C
C     CALL CLRSCR       Clear screen function on full screen systems
C     CALL CLRSCR
C
C Get SortID for current subject / sort
C
      WRITE(*,*) 
      WRITE(*,'(A,I3)') ' Enter identification code for subject no.'
     1   ,CURRNT
      WRITE(*,'(A)') 
     1   ' (A case label consisting of max. 8 characters) '
      READ(*,'(A8)') ID
      WRITE(*,*) 
C
C Get the values for each of the columns
C
      WRITE(*,810) CURRNT,ID
  810 FORMAT(' Enter the Sort Values for Subject',I3,1X,A8/)
      IX=0
      DO 20 II=LOW,HIGH
      IX=IX+1
      IF(IX.GE.7) THEN
C       CALL CLRSCR    Clear screen function on full screen systems
C       CALL CLRSCR
        WRITE(*,820) CURRNT,ID
  820 FORMAT(' (Continuation of Subject',I3,1X,A8,')',/)
        IX=0
      ENDIF
   29 WRITE(*,830) II
  830 FORMAT(' Enter the Statement Numbers, Separated by Spaces, ',/,
     1       '   for Column',I3,': ')
C
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF(IO.LT.0 .OR. LINE .EQ. ' ') THEN
        IVRTSZ(CURRNT,II)=0
        GO TO 20
      ENDIF
C
      IF(.NOT.DIGIT(LINE(1:1))) THEN
        IBGCOL(CURRNT)=0
        GO TO 30
      ENDIF
CMS      CALL PUTTMP(LINE)
C
      IVRTSZ(CURRNT,II)=NWORDS(LINE)
      READ(LINE,*,IOSTAT=IO) (QSORT(JJ,II),JJ=1,IVRTSZ(CURRNT,II))
      IF(IO.GT.0) THEN
        WRITE(*,*) ' Last input was invalid, repeating . . .'
        GOTO 29
      ENDIF
C
      IF(IBGCOL(CURRNT).LT.IVRTSZ(CURRNT,II))
     1   IBGCOL(CURRNT)=IVRTSZ(CURRNT,II)
   20 CONTINUE
C
   30 RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       PRTSRT       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C This routine prints the sort on the screen.  It can be run for new
C  adds, for changes, or for delete confirmations.
C
C
      SUBROUTINE PRTSRT(FMT1,FMT2,CHEADS,LOW,HIGH,IBGCOL,LEFT,ROWSZ,
     1                  QSORT,BIGCOL,CURRNT,ID)
      INTEGER LOW, HIGH, IBGCOL(299), BIGCOL, CURRNT
      INTEGER QSORT(50,-6:13), CHEADS(-6:13)
      INTEGER ROWSZ(50),LEFT(50)
      CHARACTER*80 FMT1,FMT2,BUF
      CHARACTER*8 ID
C
C The difficulty here is that the design may not match the actual
C data input.  We print the matrix according to the design, but print
C the data the way it was entered.  Thus, some data may appear outside
C of the drawn Qsort box.
C
C To do this, we have the number of spaces to the left to center
C both the design box (LEFT), and we have the number of boxes (ROWSZ).
C For the data, we just print all the entries in Qsort from low to
C high.  The zeros print as blanks, thus have no effect on the display.
C We use these to write a format using tabs to print the design
C boxes and the actual entries for each row in the Qsort.
C
C Finally, one complicating factor is that this design looks good for
C normal sorts, but if the longest column is more than 8, then the
C design will not fit on one screen.  To make this a little more func-
C tional, if the longest column (IBGCOL) is more than 8, we squeeze
C the display by taking out the horizontal rows of dashes.
C
C     CALL CLRSCR       Clear screen function on full screen systems
C     CALL CLRSCR
C
C First, write the header line, same width as the first data line.
C
      WRITE(FMT1,810) LEFT(1),ROWSZ(1)
  810 FORMAT('(',I2.2,'X,'' '',',I2.2,'(I3,''  ''))')
      WRITE(FMT2,820) LEFT(1),ROWSZ(1)
  820 FORMAT('(',I2.2,'X,''!'',',I2.2,'(''----!''))')
C
C Print the header itself:
C
      WRITE(*,FMT1) (CHEADS(I),I=LOW,HIGH)
      WRITE(*,FMT2)
C
C Print the data format for each line, then the line itself:
C
      DO 10 II=1, BIGCOL
C
C Write the format for one line of the box and data
C
      WRITE(FMT1,830) LEFT(1),ROWSZ(1),LEFT(II),ROWSZ(II)
  830 FORMAT('(T',I2.2,',',I2.2,'(2X,I3.0),',
     1        'T',I2.2,','' !'',',I2.2,'(4X,''!''))')
C
C Write the format for the bottoms of boxes
C
      WRITE(FMT2,840) LEFT(II),ROWSZ(II)
  840 FORMAT('(',I2.2,'X,''!'',',I2.2,'(''----!''))')
C
C print one line of the box with data
C (Revision in 2.06, 22-Oct-97: the 830 FORMAT implies 'back 
C tabbing', which doesn't work for certain G77 configurations;
C therefore next write statement first into BUF before writing
C to stdout (screen)
C 
      WRITE(BUF,FMT1) (QSORT(II,J),J=LOW,HIGH)
      WRITE(*,'(A79)') BUF
      IF (IBGCOL(CURRNT).LE.8) WRITE(*,FMT2)
   10 CONTINUE
C
      IF(IBGCOL(CURRNT).LE.BIGCOL) GO TO 30
      DO 20 II=BIGCOL+1,IBGCOL(CURRNT)
      WRITE(FMT1,850) LEFT(1),ROWSZ(1)
  850 FORMAT('(','T',I2.2,',',I2.2,'(2X,I3.0))')
C
      WRITE(*,FMT1) (QSORT(II,J),J=LOW,HIGH)
   20 CONTINUE
   30 CONTINUE
      WRITE(*,'(A,I3,A,A8)') ' SubjNo:',CURRNT,'  ID: ',ID
      WRITE(*,*) ' '
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       verif       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C This routine checks the input sort to ensure that it meets the
C  requirements (all numbers appear once and only once).  It then
C  forces or allows changes to the sort.
C2.20 Changed name from VERIFY to verif
C
      SUBROUTINE verif 
     1  (QSORT,OK,STATES,LOW,HIGH,IBGCOL,CURRNT,QOUT,ID)
C
      CHARACTER*1 UPCHAR

      INTEGER STATES, LOW, HIGH, IBGCOL(299), CURRNT
      INTEGER TOOBIG(20),DUPL(20),ZERO(20),STAT(205),STAT2(205)
      INTEGER QSORT(50,-6:13)
      INTEGER QOUT(200,299)
      CHARACTER*1 ANS
      CHARACTER*8 ID
      LOGICAL OK
C
      DO 10 I=1,200
      STAT2(I)=0
      STAT(I)=0
   10 CONTINUE
C
      DO 20 I=1,20
      DUPL(I)=0
      TOOBIG(I)=0
      ZERO(I)=0
   20 CONTINUE
C
C Put all the statement numbers gathered in the array STAT().
C
      I=0
      JJ=0
      DO 40 K=LOW,HIGH
      DO 40 J=1,IBGCOL(CURRNT)
      IF(QSORT(J,K).EQ.0)GO TO 40
      IF(QSORT(J,K).GT.STATES) THEN
         JJ=JJ+1
         IF (JJ.GT.20) GOTO 41
         TOOBIG(JJ)=QSORT(J,K)
      ELSE
         I=I+1
         STAT(I)=QSORT(J,K)
      ENDIF
   40 CONTINUE
   41 CONTINUE
C
C Get a count for each number
C
      DO 50 I=1,STATES+5
         IF(STAT(I) .GT. 0) THEN
            STAT2(STAT(I))=STAT2(STAT(I)) + 1
         ENDIF
   50 CONTINUE
C
C Now, see if there are duplicates, missings, or out of ranges.
C DUPL() contains the statements of duplicates.
C ZERO() contains statements that were omitted
C TOOBIG() contains statement numbers greater than possible.
C  (We got the TOOBIG numbers above, so just get the others here.)
C
      OK=.TRUE.
      IF(TOOBIG(1).NE.0) OK=.FALSE.
      J=0
      K=0
      DO 90 I=1,STATES
      IF(STAT2(I).GT.1)GO TO 60
      IF(STAT2(I).EQ.0)GO TO 70
      GO TO 90
   60 CONTINUE
      J=J+1
      IF (J.GT.20) GOTO 80
      DUPL(J)=I
      GO TO 80
   70 CONTINUE
      K=K+1
      IF (K.GT.20) GOTO 80
      ZERO(K)=I
   80 CONTINUE
      OK=.FALSE.
   90 CONTINUE
C
C
C Check to see if the user wants to modify the sort even if ok.
C
      IF(OK)GO TO 150
C
C Check to see if there were multiple entries, and print them if so.
C
      ICNT = 0
      DO 100 I=1,20
      IF(DUPL(I).NE.0) ICNT=ICNT+1
  100 CONTINUE
      IF(ICNT.EQ.0) GO TO 110
      WRITE(*,*) 'The following statements have been entered ',
     1       'more than once.'
      WRITE(*,810) (DUPL(J),J=1,ICNT)
  810 FORMAT(3X,20I5)
  110 CONTINUE
C
C Check to see if there were missing entries, and print them if so.
C
      ICNT = 0
      DO 120 I=1,20
      IF(ZERO(I).NE.0) ICNT = ICNT + 1
  120 CONTINUE
      IF(ICNT.EQ.0)GO TO 130
      WRITE(*,*) 'The following statements have not been entered'
      WRITE(*,810) (ZERO(J),J=1,ICNT)
  130 CONTINUE
C
C See if there were statements that were out of range.
C
      ICNT = 0
      DO 140 I=1,20
      IF(TOOBIG(I).NE.0) ICNT = ICNT + 1
  140 CONTINUE
      IF(TOOBIG(1).EQ.0) GO TO 170
      WRITE(*,*) 'These statements are larger than', states
      WRITE(*,810) (TOOBIG(J),J=1,ICNT)
      GO TO 170
C
C See if the user just wants to modify the sort.
C
  150 CONTINUE
C
C (load output array (QOUT(STATEMENT,PERSON)) with this entry)
C The value of each statement will be from -6 to 13, indicated by its
C place in the Qsort array.  Look through the array for statements,
C and put the value in the QOUT array accordingly.
C In this routine, BIGCOL is the longest column of data, it will be
C the value put in the QOUT array, and ITEMP will be the statement
C number obtained from the QSORT array. (there are zeros where no
C statements have been entered.)
C
      QSUM=0
      DO 160 J=1,IBGCOL(CURRNT)
      DO 160 I=LOW,HIGH
      ITEMP=QSORT(J,I)
      IF(ITEMP.EQ.0)GO TO 160
      QOUT(ITEMP,CURRNT)=I
      QSUM=QSUM+I
  160 CONTINUE
C
      QMEAN=QSUM/FLOAT(STATES)
      WRITE(*,820) QSUM,QMEAN,CURRNT,ID
  820 FORMAT(' The Sum is',F7.2,',  and the Mean is',F6.2,
     1       ',  for Subject',I3,1X,A8)
C
      WRITE(*,*)
     1   'The Sort is OK, Do You Want to Change It Anyway? (y/N): '
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
        ANS = 'N'
      ENDIF
      IF (upchar(ANS) .EQ. 'Y') OK=.FALSE.
      RETURN
C
  170 CONTINUE
      WRITE(*,*)
     1   'The sort must be re-entered.  Look at the problems above'
      WRITE(*,*) ' and decide what column you want to modify first.'
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       REDO         <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C This routine implements the change of any column of the sort.
C  It is called after 'verif' if a change to a sort is needed or
C  if a specific change is requested.
C
C
      SUBROUTINE REDO(LOW,HIGH,QSORT,IVRTSZ,IBGCOL,CURRNT)
C
      INTEGER LOW, HIGH, IBGCOL(299), CURRNT
      INTEGER IVRTSZ(299,-6:13), QSORT(50,-6:13), QHOLD(50)
      CHARACTER*299 LINE
      LOGICAL DIGIT
C
   10 CONTINUE
      WRITE(*,*) 'Give the value of the column you want to change: '
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
        GO TO 10
      ENDIF
CMS      CALL PUTTMP(LINE)
      IF(.NOT.DIGIT(LINE(1:1)).AND.LINE(1:1).NE.'-') THEN
        IBGCOL(CURRNT)=0
        GO TO 30
      ENDIF
      READ(LINE,*,IOSTAT=IO) ICOL
C
      IF(ICOL.LT.LOW.OR.ICOL.GT.HIGH.OR.IO.GT.0) GO TO 10
C
C     CALL CLRSCR       Clear screen function on full screen systems
C     CALL CLRSCR
C
      WRITE(*,'(1X,A,I2,A)')
     &     'The current values for column ',icol,' are:'
      WRITE(*,810) (QSORT(J,ICOL),J=1,IVRTSZ(CURRNT,ICOL))
  810 FORMAT(10(I5))
C
C Zero out the old values but save them in QHOLD, just in case
C
      DO 20 JJ=1,50
      QHOLD(JJ)=QSORT(JJ,ICOL)
      QSORT(JJ,ICOL)=0
   20 CONTINUE
C
C Get the new values
C
      WRITE(*,*)
     1   'Enter all of the new values, even ones that were good: '
      WRITE(*,*)
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
        IVRTSZ(CURRNT,ICOL)=0
        GO TO 30
      ENDIF
CMS      CALL PUTTMP(LINE)
C
C If they enter STOP or something, restore the line to what it was
C
      IF(.NOT.DIGIT(LINE(1:1))) THEN
        DO 25 JJ=1,50
        QSORT(JJ,ICOL)=QHOLD(JJ)
   25   CONTINUE
        GO TO 30
      ENDIF
C
      IVRTSZ(CURRNT,ICOL)=NWORDS(LINE)
      READ(LINE, *) (QSORT(JJ,ICOL),JJ=1,IVRTSZ(CURRNT,ICOL))
   30 CONTINUE
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>      DELONE        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C This routine deletes the current Qsort.
C  must modify QOUT, SORTID, IBGCOL, and IVRTSZ.
C
C
      SUBROUTINE DELONE(CURRNT,PERSON,QOUT,STATES,IBGCOL,IVRTSZ,
     1    SORTID)
C
      INTEGER CURRNT,PERSON,STATES,QOUT(200,299)
      INTEGER IBGCOL(299), IVRTSZ(299,-6:13)
      CHARACTER SORTID(299)*8
C
      DO 30 II=CURRNT,PERSON+1
      IBGCOL(II)=IBGCOL(II+1)
      SORTID(II)=SORTID(II+1)
      DO 10 JJ=1, STATES
      QOUT(JJ,II)=QOUT(JJ,II+1)
   10 CONTINUE
C
      DO 20 KK=-6,13
      IVRTSZ(II,KK)=IVRTSZ(II+1,KK)
   20 CONTINUE
C
   30 CONTINUE
C
      PERSON=PERSON-1
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>  FUNCTION NWORDS   <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Find the number of entries in an input line.
C
C
      INTEGER FUNCTION NWORDS (STRING)
      IMPLICIT INTEGER (A-Z)
C
      CHARACTER*(*) STRING
C
      NWORDS = 0
      N = LEN (STRING)
      START = 1
   10 CONTINUE
C     Skip blanks
      DO 20 I = START, N
      IF (STRING(I:I) .NE. ' ') GO TO 30
   20 CONTINUE
      RETURN
C
   30 CONTINUE
      NWORDS = NWORDS + 1
      DO 40 J = I+1, N
      IF (STRING(J:J) .EQ. ' ') THEN
        START = J + 1
        GO TO 10
      ENDIF
   40 CONTINUE
C
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>  FUNCTION UPCHAR   <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      CHARACTER*1 FUNCTION UPCHAR (CHAR)
C
      CHARACTER*1  CHAR
      CHARACTER*26 UPPERC, LOWERC
C
      DATA UPPERC /'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      DATA LOWERC /'abcdefghijklmnopqrstuvwxyz'/
C
      UPCHAR = CHAR
      DO 10 I = 1, 26
         IF (CHAR .EQ. LOWERC(I:I)) THEN
            UPCHAR = UPPERC(I:I)
            GO TO 99
         ENDIF
  10  CONTINUE
C
  99  CONTINUE
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>  FUNCTION DIGIT    <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      LOGICAL FUNCTION DIGIT (CHAR)
C
      CHARACTER*1  CHAR
      DIGIT = (CHAR .GE. '0') .AND. (CHAR .LE. '9')
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    READOL   ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C  
      SUBROUTINE READOL (NFAX,PERSON,STATES,LOW,HIGH,VERTSZ,QOUT,
     1   BIGCOL,LEFT,ROWSZ,IVRTSZ,IBGCOL,EXST)
C
C In the original version of QMethod certain variables associated
C with the sorting design in general as well as variables associated
C with the specific response distributions of individual persons were
C saved in a working file ($HLDENT$ or .ent). Though all data required
C for running analyses steps are available from the raw data file,
C entering new sorts or deletion / modification of old sorts required
C an intact $HLDENT$/.ent file. 
C Subroutine READOL recalculates all data that were originally stored
C in the working file from parameters and data in the raw data file. 
C By that measure it is now possible to use the QENTER module (display, 
C modify and/or delete Q-sorts) for raw data sets created or manipulated
C by any method other than with QENTER itself.
C
      INTEGER STATES, LOW, HIGH, BIGCOL, PERSON, NFAX
      INTEGER IBGCOL(299), IVRTSZ(299,-6:13)
      INTEGER VERTSZ(-6:13)
      INTEGER ROWSZ(50),LEFT(50)
      INTEGER QOUT(200,299)
      INTEGER NWARN
      LOGICAL EXST
C
      BIGCOL=0
      DO 5 I=1,50
    5 ROWSZ(I)=0

C
      WRITE(*,*) 
      WRITE(*,*) 'Checking old input data file ....'
      WRITE(*,*) 
C
      CALL READAT 
     1    (NFAX,PERSON,STATES,LOW,HIGH,VERTSZ,QOUT,EXST)
C
C Bugfix since version 2.05; if there is no .dat or .raw file,
C LOW and HIGH are undefined!
C
      IF(.NOT.EXST) RETURN
C
C Determine deepest column for design
C
      DO 10 I=LOW,HIGH
      IF(BIGCOL.LT.VERTSZ(I))BIGCOL=VERTSZ(I)
   10 CONTINUE
C
C Determine the row sizes for the design
C
      DO 20 I=1,BIGCOL
      DO 20 J=LOW, HIGH
      IF(VERTSZ(J).GE.I)ROWSZ(I)=ROWSZ(I)+1
   20 CONTINUE
C
      DO 30 I=1,BIGCOL
      LEFT(I) = (70-ROWSZ(I)*5)/2
   30 CONTINUE
C
C Determine IVRTSZ (), the depth of each column for each
C individual (=frequency distribution of "item responses" across
C range LOW thru HIGH), and IBGCOL, the max. column depth for
C each individual. Response values are checked to lie within range
C LOW thru HIGH, otherwise reset to midpoint, and warning issued.
C If no warnings in excess of 20, data seem to be invalid, and program
C is exited.
C 
      NWARN=0
      DO 50 I=1,PERSON
      DO 51 J=1,STATES
      IF (QOUT(J,I).LT.LOW.OR.QOUT(J,I).GT.HIGH) THEN
        IF (NWARN.LE.20) THEN
          WRITE(*,810) I,J,QOUT(J,I),(LOW+HIGH)/2
 810      FORMAT(' Warning: Subj:',I3,' Statem:',I3, ' - respns '
     1    ,I3,' is out of range. '
     2    ,'Reset to ',I3)
        ELSE
          WRITE(*,*) 'Too many warnings, exiting .....'
          CALL EXITPR
        ENDIF
        QOUT(J,I) = (LOW+HIGH)/2
        NWARN=NWARN+1
      ENDIF
      IVRTSZ (I,QOUT(J,I)) = IVRTSZ (I,QOUT(J,I)) + 1
   51 CONTINUE
      DO 52 J=LOW,HIGH
      IF(IBGCOL(I).LT.IVRTSZ(I,J)) IBGCOL(I)=IVRTSZ(I,J)
   52 CONTINUE

   50 CONTINUE
C
      RETURN
      END


C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    READAT   ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C  
      SUBROUTINE READAT 
     1    (NFAX,PERSON,STATES,LOW,HIGH,VERTSZ,QOUT,EXST)
C
C Subroutine READAT reads raw input data in the 'new' data format 
C (items=columns / persons=rows; SORTID's) from .dat file if that 
C exists. If data only exist in 'old' .raw file format these are read
C instead, and automatically output to .dat in new format. Also, existing
C data in new format will also be converted to old format.
C
      INTEGER STATES, LOW, HIGH, PERSON, NFAX
      INTEGER VERTSZ(-6:13)
      INTEGER QOUT(200,299)
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      CHARACTER*4 BUF
      LOGICAL EXST
C
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
C
C 1) First try to read new format .dat file. Assume it is from this 
C program, so that the first record has the number of qsorts 
C already entered and the title of the design. The second starts the 
C data itself. After reading make copy in old .raw format.
C If the file isn't there, next try to input old format .raw file. If
C successful, make copy in new .dat format. 
C Logical EXST controls whether data file in one or the other form has
C already been retrieved (and converted) earlier.
C
      READ(16,810,END=50,ERR=50) NFAX, PERSON, STATES, PRTITL
810   FORMAT(3I3,1X,A68)
C
      READ(16,820,END=50,ERR=50) LOW,HIGH,VERTSZ
820   FORMAT(22(I3))
C
C Read in non-transposed data
C
      DO 10 J=1,PERSON
      READ(16,830,END=50,ERR=50) SORTID(J),(QOUT(I,J),I=1,STATES)
830   FORMAT(A8,2X,200(I2))
   10 CONTINUE
C
C Write old format (transposed data) .raw file with SORTIDs appended. 
C
      IF (EXST) GOTO 90
      REWIND (11)
      WRITE(11,810) NFAX, PERSON, STATES, PRTITL
      WRITE(11,820) LOW,HIGH,VERTSZ
      DO 20 I=1,STATES
      WRITE(11,840) (QOUT(I,J),J=1,PERSON)
840   FORMAT(40(I2))
   20 CONTINUE
      WRITE(11,'(A8)') (SORTID(I),I=1,PERSON)
      EXST=.TRUE.
      GOTO 90
C
C 2) Now try to read data from .raw instead. If successful, output
C copy of data in new .dat format, generating SORTIDs from 1st 5 
C characters of project name plus seq. number.
C If this file also isn't there, this must be a new study.
C
   50 CONTINUE
      READ(11,810,END=60,ERR=60) NFAX, PERSON, STATES, PRTITL
      READ(11,820,END=60,ERR=60) LOW,HIGH,VERTSZ
      DO 30 I=1,STATES
      READ(11,850,END=60,ERR=60) (QOUT(I,J),J=1,PERSON)
850   FORMAT(40(I2))
   30 CONTINUE
      READ(11,'(A8)',END=39) (SORTID(I),I=1,PERSON)
      GOTO 41
   39 L = MIN(5,LENGTH(PRNAME))
      DO 38 J=1,PERSON
      WRITE(BUF,'(I4)') J+1000
   38 SORTID(J)=PRNAME(1:L)//BUF(2:4)

C
   41 IF (EXST) GOTO 90
      REWIND (16)
      WRITE(16,810) NFAX, PERSON, STATES, PRTITL
      WRITE(16,820) LOW,HIGH,VERTSZ
C
      DO 40 J=1,PERSON
      WRITE(16,830) SORTID(J),(QOUT(I,J),I=1,STATES)
   40 CONTINUE
      EXST=.TRUE.
      GOTO 90
C
   60 EXST=.FALSE.
   90 CONTINUE
      REWIND (11)
      REWIND (16)
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***     QCENT    ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE QCENT (FNAME)
C
C Routine to perform
C           Centroid Factor Analysis
C           using:  Thurstone's Centroid Method
C           code closely follows Brown (1980)
C
C
C Limits: 299 subjects (variables)
C           7 factors will be produced (assuming at least 7 variables)
C             but the variable 'NFAX' is input & can range from 1 to 8
C
C Note: The new (as of 2.20) centroid method by Horst branches out from within
C        this subroutine, not from the main menu already.
C
      IMPLICIT REAL*8 (A-H,O-Z)
      INTEGER  LOW, HIGH, NITEMS, VERTSZ(-6:13)
      INTEGER NSORTS,NFAX,TOTREF,REFL(299)
      REAL*8 CORR(299,299),FACTOR(8,299),T(299),FSQ(299),COMUN(299),
     1     SUMCOL(299),F(299)
      REAL RDATA (200,299),MEAN(299),STDDEV(299)
      CHARACTER FNAME*64, PRTITL*68
      CHARACTER NUMB*3, UPCHAR*1, ANS*1
      LOGICAL DIGIT, OK
C
C Ask if user wants to run Horst's instead of Brown's method, if so 
C call Sub HORST55 and return
C
      WRITE(*,*)
     X   'Do you want to run the Horst 5.5 Centroid factor analysis',
     X   'with iterative solutions for communalities ',
     X   'instead of the method described in Brown (1980) (y/N):'
       READ(*,'(A1)',IOSTAT=IO) ANS
       IF (IO.LT.0.OR.ANS.EQ.' '.OR.UPCHAR(ANS).EQ.'N') GO TO 5
       CALL HORST55 (FNAME)
       RETURN
C
C Read in rawdata file with header lines
C
    5 CONTINUE
      READ(16,810,END=998,ERR=999) NFAX, NSORTS, NITEMS, PRTITL
  810 FORMAT(3I3,1X,A68)
      READ(16,820,END=998,ERR=999) LOW,HIGH,VERTSZ
  820 FORMAT(22(I3))
C
      DO 10 J=1,NSORTS
      READ(16,'(10X,200F2.0)',END=998,ERR=999) 
     1   (RDATA(I,J),I=1,NITEMS)
  10  CONTINUE
      REWIND (16)
C
C Compute correlations (and write correlation file)
C
      CALL CORCOL(NITEMS,NSORTS,RDATA,MEAN,STDDEV,CORR)
C
      IF(NFAX.LT.1)NFAX=7
C
C Ask how many factors shall be extracted
C
      WRITE(*,*) 
      WRITE(*,*) 'How many Centroids do you wish to extract? '
      WRITE(*,'(A,I2,A)') ' (Press <ENTER> if',NFAX,' is OK)'
      READ(*,'(A3)',IOSTAT=IO) NUMB
      IF (IO.GE.0.AND.NUMB.NE.' '.AND.DIGIT(NUMB(1:1))) THEN
CMS        CALL PUTTMP(NUMB)
        READ(NUMB,*) NFAX
      ENDIF
      IF(NSORTS.LT.NFAX)NFAX=NSORTS
      IF(NFAX.GT.8.OR.NFAX.LT.1)NFAX=8
      WRITE(*,'(I2,A,A)') NFAX, ' factors will be output to file ',
     1 FNAME(1:LENGTH(FNAME))//'.unr'
C
C---------------------------------------------------------------------
C
C Big Loop - do once for each factor
C
      DO 180 IFACT=1,NFAX
C
      DO 30 I=1,NSORTS
      REFL(I)=-1
      CORR(I,I)=0.0D0
   30 CONTINUE
C
      TOTREF=0
   40 CONTINUE
      DO 50 ICOL=1,NSORTS
      SUMCOL(ICOL)=0.0D0
      DO 50 J=1,NSORTS
      SUMCOL(ICOL)=SUMCOL(ICOL) + CORR(J,ICOL)
   50 CONTINUE
C
CSMK (2.30): Initialized BOTTOM to the highest possible positive value
C            instead of 0.0D0
C
      BOTTOM = 1.0D0*NSORTS  
      DO 60 ICOL = 1,NSORTS
      IF(SUMCOL(ICOL).LT.BOTTOM) THEN
          BOTTOM=SUMCOL(ICOL)
          JHOLD=ICOL
      ENDIF
   60 CONTINUE
C
C  Check to see if there are no negative sums (no more rotations)
C
      IF(BOTTOM.GE.0.0D0) GO TO 80
C
C Need to reflect column & row
C
      TOTREF=TOTREF+1
      REFL(JHOLD)=-REFL(JHOLD)
C
      DO 70 J=1,NSORTS
      CORR(J,JHOLD)=-CORR(J,JHOLD)
      CORR(JHOLD,J)=CORR(J,JHOLD)
   70 CONTINUE
C
      IF(TOTREF.GT.200) GO TO 80
      GO TO 40
C
   80 CONTINUE
C
C No more reflections are necessary - now iterate to solution.
C First, initialize communalities to 0.5 (just a rough estimate,
C but the iterations will zero them in).
C
      DO 90 I=1,NSORTS
      COMUN(I)=0.5D0
   90 CONTINUE
C
C At this point, SUMCOL() contains the sums of each column after
C    all required reflections (up to 200), and CORR() contains the
C    the current reflected correlation matrix (the entries are reduced
C    each time a factor is extracted, so this may not resemble the
C    original matrix much after the first time through the big loop).
C
C Now we iterate to get this factor (till factor loadings squared
C    are equal two straight times {or we do 20 iterations}).
      ITERS=0
  100 CONTINUE
      IAGAIN=0
      ITERS=ITERS+1
      IF(ITERS.GT.20)GO TO 130
      TSUM=0.0D0
      DO 110 I=1,NSORTS
      T(I)=SUMCOL(I)+COMUN(I)
      TSUM=TSUM+T(I)
  110 CONTINUE

C
      SQRTT=SQRT(TSUM)
C
      DO 120 I=1,NSORTS
      F(I)=(T(I)/SQRTT)
      FSQ(I)=(F(I)*F(I))
      DIFF=(ABS(FSQ(I)-COMUN(I)))
      IF(DIFF.GT.0.001D0) THEN
            IAGAIN=1
      ENDIF
      COMUN(I)=FSQ(I)
  120 CONTINUE
C
      IF(IAGAIN.EQ.1) GO TO 100
  130 CONTINUE
C
C When we get here, we have a factor!
C
C We need to recalculate CORR() after removing this factor, and then
C    unreflect columns/rows to get true factor and get ready for next
C    factor extraction.
C
C First, recalculate top of CORR()
C
      DO 140 I=1,NSORTS
      DO 140 J=I+1,NSORTS
      CORR(I,J)=CORR(I,J) - (F(I) * F(J))
      CORR(J,I)=CORR(I,J)
  140 CONTINUE
C
C Now, unreflect
C
      DO 160 I=1,NSORTS
      IF(REFL(I).LT.0) GO TO 160
      DO 150 J=1,NSORTS
      CORR(I,J)=-CORR(I,J)
      CORR(J,I)=CORR(I,J)
  150 CONTINUE
      F(I)=-F(I)
  160 CONTINUE
C
      DO 170 I=1,NSORTS
      FACTOR(IFACT,I)=F(I)
  170 CONTINUE
C
  180 CONTINUE
C
CSMK: (2.0e) Insertion of a hack to proportionally cut loadings in 
C  case communality is gt 1.0 (so-called 'Heywood case').
C  This securely prevents the possibility that (also after rotation)
C  any factor loading a can be gt 1.0. 
C  There exist two places in the program where loadings exceeding 
C  unity lead to problems:
C  (1) QROTATE (LDGRPH): Plotting sorts on coordinates F1-F2 is only 
C  possible if neither of the two, F1 and F2 exceeds 1.0
C  (2) In MAIN02, the formula for factor weights: a/(1-a^2) gives
C  very high negative results if a is slightly above 1.0.
C
C  In addition to the revision here in QCENT, I also revised LDGRPH
C  (excluding points that do not fit on the graph) and MAIN02 
C  (cutting loadings to a max of +/- .99). Therefore, it would be
C  possible to delete the 'hack' ('DO 210 ... 210 CONTINUE') again.
C
C---------------------------------------------------------------------
C
      DO 210 I=1,NSORTS
      H2=0.0D0
      DO 211 J=1,NFAX
  211 H2=H2+FACTOR(J,I)*FACTOR(J,I)
      IF(H2.GT.1.0D0) THEN
        WRITE(*,*)
        WRITE(*,'(A,I3,A,F5.3)') 
     X   ' WARNING - Sort #', I, ' has a communality of ', H2
        WRITE(*,*)
     X   'Do you want to have factor loadings adjusted? (Y/n):'
        READ(*,'(A1)',IOSTAT=IO) ANS
        IF (IO.LT.0.OR.ANS.EQ.' '.OR.UPCHAR(ANS).EQ.'Y') THEN
          DO 212 J=1,NFAX
  212     FACTOR(J,I)=FACTOR(J,I)/SQRT(H2)
        END IF
      END IF
  210 CONTINUE
C
C The factors have been extracted.  Now write them out.
C
C
C  Write out stats, the title , and design specs.
C
      WRITE(13,840) NFAX,NSORTS,NITEMS,PRTITL
  840 FORMAT(3I3,1X,A68)
C
      WRITE(13,850) LOW,HIGH,VERTSZ
  850 FORMAT(22(I3))
C
      DO 190 I=1,NSORTS
      WRITE(13,860) (FACTOR(J,I),J=1,NFAX)
  860 FORMAT(8(F9.5,1X))
  190 CONTINUE
C
  200 CONTINUE
      REWIND (13)
      RETURN
C
C No input file
C
  998 CONTINUE
      CALL INERR(16)
      RETURN
  999 CONTINUE
      CALL INERR(161)
      RETURN
      END
C----------------------------------------------------------------------
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***     HORST55   ***<*<*<<<<<<<<<<<< 
C ////////////----------------------\\\\\\\\\\\\\\\\
CSMK (2.30) new in 2.30
C
      SUBROUTINE HORST55 (FNAME)
C Adapted from
C  Horst, Paul (1965): Factor analysis of data matrices. New York:
C  Holt, Rinehart and Winston.
C  CHAPTER 5 - THE CENTROID METHOD
C    5.5 ITERATIVE SOLUTIONS FOR DIAGONALS
C 
C Modifications of original algorithm:
C (1) Introduced upper limit of no of factors (NFAX) extracted. 
C (2) Uncomment loop 12 to replace initial 1.0 diagonals with largest 
C     off-diagonal coefficient. (not much difference, anyway)
C
      INTEGER  LOW, HIGH, NITEMS, VERTSZ(-6:13)
      INTEGER NSORTS,NFAX
      REAL*8 R(299,299), HOLDR(299,299)
      REAL RDATA(200,299)
      DIMENSION W(299),V(299),D(299),U(299),F(299,8)
      CHARACTER  PRTITL*68,FNAME*64
      CHARACTER NUMB*3, UPCHAR*1, ANS*1, BUF*105
      LOGICAL DIGIT,STPCRT
     
      STPCRT=.FALSE.
C   
C Open scratch file for collecting output that is later transfered
C at the end of the .unr
C
C      OPEN (9,STATUS='SCRATCH') 
      OPEN (9,File='horst.tmp')
C
C Read in rawdata file with header lines
C and then compute the correlation matrix
C 'Borrow' vectors W for Means and V for StdDev
C
      READ(16,810,END=998,ERR=999) NFAX, NSORTS, NITEMS, PRTITL
  810 FORMAT(3I3,1X,A68)
      READ(16,820,END=998,ERR=999) LOW,HIGH,VERTSZ
  820 FORMAT(22(I3))
C
      DO 100 J=1,NSORTS
      READ(16,'(10X,200F2.0)',END=998,ERR=999) 
     1   (RDATA(I,J),I=1,NITEMS)
  100 CONTINUE
      REWIND (16)
C
      CALL CORCOL(NITEMS,NSORTS,RDATA,W,V,HOLDR)
C
C  Preset NFAX to the suggested default 
C
      NFAX=3
C
C Ask how many factors shall be extracted
C
      WRITE(*,*) 
      WRITE(*,*) 'How many Centroids do you wish to extract (max. 8)? '
      WRITE(*,'(A,I2,A)') '  Press <ENTER> if',NFAX,' is OK'
      WRITE(*,*) 'Or 0 if you at first wish to see how many factors',
     X           ' pass Horst''s criterion'
      READ(*,'(A3)',IOSTAT=IO) NUMB
      IF (IO.GE.0.AND.NUMB.NE.' '.AND.DIGIT(NUMB(1:1))) THEN
CMS        CALL PUTTMP(NUMB)
        READ(NUMB,*) NFAX
      ENDIF
      WRITE(*,*)
      IF(NFAX.EQ.0) STPCRT=.TRUE.
      IF(NFAX.GT.8.OR.NFAX.LT.1)NFAX=8
      IF(NSORTS.LT.NFAX)NFAX=NSORTS
C
C---------------------------------------------------------------------
C
      N=NSORTS
      M=NITEMS
      P=.001     !Convergence level for iterative communalities. Originally .001
      NL=30      !max number of iterations
      FN = N
      FM = M
      DO 11 I=1,N
      U(I) = HOLDR(I,I)
      DO 11 J=1,N
      R(I,J)=HOLDR(I,J)
 11   CONTINUE
      L = 0
      K = 0
      KF = 0
C12C  Start with largest off diagonal
C12      DO 12 J=1,N
C12      R(J,J)=0.
C12      DO 12 I=1,N
C12 12   IF(I.NE.J) R(J,J)=MAX(R(J,J),ABS(R(I,J)))
C     TEST SIGNIFICANCE OF RESIDUAL
 15   DO 17  I=1,N
      D(I) = R(I,I)
 17   R(I,I) =0.0
      S = 0.0
      DO 21  I=1,N
      DO 21  J=1,N
 21   S = S + R(I,J)**2
      AVRGS= 2*S/(FN*(FN-1))
C
C The following condition is equivalent to
C S / (FN*(FN-1)/2) LE 1/FM, that is, the average
C squared residual correlation must be greater than
C 1 / NITEMS
C By commenting the line, this stopping criterion
C is dropped.
C
      IF (STPCRT.AND.(2.0*S*FM) - (FN*(FN-1.0)).LE.0) GOTO 24
      IF (K.GE.NFAX) GOTO 24
      GOTO 25
C  24  IF (K-1) 93, 93, 54 --- Original version: no output if only one factor ??
  24  IF (K) 93, 93, 54
C     SIGN VECTOR
 25   DO 29  I=1,N
      W(I) = 0.0
      V(I)=1.0 
      DO 29  J=1,N
 29   W(I) = W(I) + R(I,J)
 30   J = 1
      DO 34  I=2,N
      IF (W(J) * V(J) - W(I) * V(I)) 34, 33, 33
 33   J = I
 34   CONTINUE
      IF (W(J) * V(J)) 36, 40, 40
 36   V(J) = -V(J)
      DO 38  I=1,N
 38   W(I) = W(I) + 2.0 * R(I,J) * V(J)
      GO TO 30
C     FACTOR VECTOR
 40   Do 41  I = 1,N
 41   W(I) = W(I) + D(I) * V(I)
      S = 0.0
      DO 44  I =1,N
 44   S = S + ABS(W(I))
      S = 1.0/SQRT(S)
      DO 47  I=1,N
 47   W(I) = W(I) * S
      K = K+1
      DO 48 I=1,N
 48   F(I,K)=W(I)
C     RESIDUAL MATRIX
      DO 52  I=1,N
      R(I,I) = D(I)
      DO 52  J=1,N
 52   R(I,J) = R(I,J) - W(I) * W(J)
      GO TO 15
C     DIAGONALS OF R
 54   S = 0.0
      DO 542 I = 1,N
 542  S = MAX(S,ABS(D(I)))
      DO 56 I =1,N
      D(I) = MIN(1.0,(U(I) - D(I)))
 56   U(I) = D(I)
      WRITE (9,71) (U(I),I=1,N)
 71   FORMAT (15F7.4)
      IF (S-P) 83, 83, 73
 73   L = L+1
      WRITE (9, 732) K,L
 732  FORMAT (2I4)
C      IF (L-NL) 75, 75, 83
      IF (L.GT.NL) THEN
        WRITE (*,'(A,I4,A)') 
     X  ' Communality estimates did NOT converge after',NL,
     X  ' Iterations'
        WRITE (*,*) ' Press <ENTER> to continue'
        READ (*,*)
        GOTO 83
      ENDIF
C     NEW DIAGONALS
 75   K = 0
      DO 77  I=1,N
      DO 77 J=1,N
      R(I,J)=HOLDR(I,J)
 77   CONTINUE
      DO 81  I=1,N
 81   R(I,I) = 0.0
      GO TO 25
C
C Factor loadings need not be written to Horst's original listing file
  83   CONTINUE
C 83   WRITE (9, 84)
 84   FORMAT (1H )
C      DO 88  J=1,K
C      WRITE (9, 71) (F(I,J), I=1,N)
C 88   CONTINUE
C
CSMK: Here again my hack to proportionally cut loadings in 
C  case communality is gt 1.0 (so-called 'Heywood case').
C  Same as in QCENT
C
C---------------------------------------------------------------------
C
      DO 210 I=1,N
      H2=0.0D0
      DO 211 J=1,K
  211 H2=H2+F(I,J)*F(I,J)
      IF(H2.GT.1.0D0) THEN
        WRITE(*,*)
        WRITE(*,'(A,I3,A,F5.3)') 
     X   ' WARNING - Sort #', I, ' has a communality of ', H2
        WRITE(*,*)
     X   'Do you want to have factor loadings adjusted? (Y/n):'
        READ(*,'(A1)',IOSTAT=IO) ANS
        IF (IO.LT.0.OR.ANS.EQ.' '.OR.UPCHAR(ANS).EQ.'Y') THEN
          DO 212 J=1,K
  212     F(I,J)=F(I,J)/SQRT(H2)
        END IF
      END IF
  210 CONTINUE
      WRITE (13, 810) K, N, M, PRTITL
      WRITE (13, 820) LOW,HIGH,VERTSZ
      DO 92  I=1,N
      WRITE (13, '(8(F9.5,1X))') (F(I,J),J=1,K)
 92   WRITE (9, 71) (R(I,J), J=1,N)
 93   CONTINUE
C
      WRITE (13,932)
932   FORMAT(/'HORST 5.5 Centroid output of iterated series of ',
     x 'communality estimates and the residual correlation matrix'/)
      REWIND (9)
 94   READ(9,'(A)',END=95) BUF 
      WRITE(13,'(A)') BUF
      GO TO 94
 95   CONTINUE
      WRITE(*,'(I2,A,A)') K, ' factors will be output to file ',
     1 FNAME(1:LENGTH(FNAME))//'.unr'
      WRITE(*,*)
      WRITE(*,'(/A,F5.3/)') 'Average squared residual correlation: ', 
     1  AVRGS
      WRITE (*,*) ' Press <ENTER> to continue'
      READ (*,*)
      CLOSE (9,STATUS='DELETE')
      RETURN
C
C
C No input file
C
  998 CONTINUE
      CALL INERR(16)
      RETURN
  999 CONTINUE
      CALL INERR(161)
      RETURN
      END
C------------------------------------------------------------------------------------
C
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***     QPCA      ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE QPCA (FNAME)
C
C Routine to perform
C     Principal Components Analysis
C     adapted from: PCA
C     by F. Murtagh, ST-ECF/ESA/ESO, Garching-bei-Muenchen, Jan 1986. 
C     (http://www.hensa.ac.uk/ftp/mirrors/statlib/multi/pca)
C
C Limits: 299 subjects (variables)
C           8 factors will be produced (assuming at least 8 variables)
C
C(2.08)Like in Varimax, PCs will be reflected now, if 'mostly 
C  negative' (if SumSquared of the negative loadings gt
C  SumSquared of positive loadings; using CRIT() ) 
C
      INTEGER  LOW, HIGH, NITEMS, VERTSZ(-6:13)
      INTEGER NSORTS,NFAX
      REAL*8 CORR(299,299)
      REAL EVEC(299,299),EVAL(299),V1(299),RDATA (200,299),CRIT(8)
      CHARACTER  PRTITL*68,FNAME*64
C
C Read in rawdata file with header lines
C and then compute correlation matrix
C 'Borrow' vectors EVAL for Means and V1 for StdDev
C
      READ(16,810,END=998,ERR=999) NFAX, NSORTS, NITEMS, PRTITL
  810 FORMAT(3I3,1X,A68)
      READ(16,820,END=998,ERR=999) LOW,HIGH,VERTSZ
  820 FORMAT(22(I3))
C
      DO 100 J=1,NSORTS
      READ(16,'(10X,200F2.0)',END=998,ERR=999) 
     1   (RDATA(I,J),I=1,NITEMS)
  100 CONTINUE
      REWIND (16)
C
      CALL CORCOL(NITEMS,NSORTS,RDATA,EVAL,V1,CORR)
C
C Now do the PCA
C First carry out eigenreduction.
C

      M2 = NSORTS
      CALL TRED2(NSORTS,M2,CORR,EVAL,V1,EVEC)
      CALL TQL2(NSORTS,M2,EVAL,V1,EVEC,IERR)

      IF (IERR.NE.0) GOTO 997
C
C Convert eigenvectors to factors and sum up each CRIT(IFactor)
C (no more factors than the smallest number of:
C NITEMS, NSORTS or 8).
C 
      NFAX=MIN0(NITEMS,NSORTS,8)
C
C
      DO 201 I=1,NFAX
  201 CRIT(I)=0.0
C
      DO 210 K1 = 1, NSORTS
      DO 210 K2= 1,NFAX
      EVEC(K1,NSORTS-K2+1)=
     1   EVEC(K1,NSORTS-K2+1)*SQRT(EVAL(NSORTS-K2+1))
      CRIT(K2)=CRIT(K2)+EVEC(K1,NSORTS-K2+1)*ABS(EVEC(K1,NSORTS-K2+1))
  210 CONTINUE
C
C Reflect factors when CRIT < 0
C
      DO 211 K2= 1,NFAX
      IF(CRIT(K2).GT.0.0) GOTO 211
        DO 212 K1 = 1, NSORTS
  212   EVEC(K1,NSORTS-K2+1)=-1.0*EVEC(K1,NSORTS-K2+1)
  211 CONTINUE
C
C  Write out stats, the title , and design specs.
C
      WRITE(13,840) NFAX,NSORTS,NITEMS,PRTITL
  840 FORMAT(3I3,1X,A68)
      WRITE(13,850) LOW,HIGH,VERTSZ
  850 FORMAT(22(I3))
C
C Write out factors
C 
      DO 220 K1=1,NSORTS
      WRITE(13,860) (EVEC(K1,NSORTS-K2+1),K2=1,NFAX)
  860 FORMAT(8(F9.5,1X))
  220 CONTINUE
C          
C  Output eigenvalues in order of decreasing value.
C          
C
      TOT = 0.0
      DO 300 K = 1, NSORTS
        TOT = TOT + EVAL(K)
  300 CONTINUE
        CUM = 0.0
        K = NSORTS+ 1
C
C       (We only want Min(nrows,ncols) eigenvalues output:)
C
        M = MIN0(NITEMS,NSORTS)
C
        WRITE(*,1010)
        WRITE(*,1020)
        WRITE(13,1010)
        WRITE(13,1020)
        K1=0
  310   CONTINUE
        K = K - 1
        K1=K1+1
        CUM = CUM + EVAL(K)
        VPC = EVAL(K) * 100.0 / TOT
        VCPC = CUM * 100.0 / TOT
        IF(MOD(K1,21).EQ.0) THEN
          WRITE(*,*) ' Press <ENTER> to continue'
          READ(*,*) 
          WRITE(*,1010)
          WRITE(*,1020)
        ENDIF
        WRITE(*,1030) K1,EVAL(K),VPC,VCPC
        WRITE(13,1030) K1,EVAL(K),VPC,VCPC
        EVAL(K) = VCPC
        IF (K.GT.NSORTS-M+1) GOTO 310
C
        WRITE(*,*) ' Press <ENTER> to continue'
        READ(*,*) 
C
      WRITE(*,*)
      WRITE(*,'(I2,A,A)') NFAX, ' factors will be output to file ',
     1 FNAME(1:LENGTH(FNAME))//'.unr'
C
      REWIND (13)
C
 1010   FORMAT
     X(' Eigenvalues        As Percentages    Cumul. Percentages')
 1020   FORMAT
     X(' -----------        --------------    ------------------')
 1030   FORMAT(I4,F9.4,7X,F10.4,10X,F10.4)
C
      RETURN
C
C No input file
C
  997 CONTINUE
      WRITE(*,*)
      WRITE(*,*) 
     1  'Abnormal end, no convergence after 30 iterations at ',IERR
      RETURN
  998 CONTINUE
      CALL INERR(16)
      RETURN
  999 CONTINUE
      CALL INERR(161)
      RETURN
      END
C
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                           
C  Determine correlations of columns.
C  First determine the means of columns, storing in WORK1.
C                                         
C  Output of file with correlation matrix is inserted in
C  this subroutine (no need for an extra sub)
C
C(2.09) Changed handling of cases (columns) with zero variance.
C  In the original version StdDev of zero was replaced by 1.0 
C  (sets all affected correlations to 0). Now, processing will
C  be stopped with an error message to the screen.
C
C--------------------------------------------------------
      SUBROUTINE CORCOL(N,M,DATA,WORK1,WORK2,OUT)
      DIMENSION DATA(200,299),  WORK1(299), WORK2(299)
      REAL*8 OUT(299,299)
      CHARACTER*80 BUF(2)
      DATA         EPS/1.E-10/
C
        DO 30 J = 1, M
           WORK1(J) = 0.0
           DO 20 I = 1, N
              WORK1(J) = WORK1(J) + DATA(I,J)
   20      CONTINUE
           WORK1(J) = WORK1(J)/FLOAT(N)
   30   CONTINUE
C
C          Next det. the std. devns. of cols., storing in WORK2.
C
        DO 50 J = 1, M
           WORK2(J) = 0.0
           DO 40 I = 1, N
              WORK2(J) = WORK2(J) + (DATA(I,J)
     X                   -WORK1(J))*(DATA(I,J)-WORK1(J))
   40      CONTINUE
           WORK2(J) = WORK2(J)/FLOAT(N)
           WORK2(J) = SQRT(WORK2(J))
C           IF (WORK2(J).LE.EPS) WORK2(J) = 1.0
           IF (WORK2(J).LE.EPS) GOTO 290
   50   CONTINUE
C
C          Now centre and reduce the column points.
C
        DO 70 I = 1, N
           DO 60 J = 1, M
              DATA(I,J) = (DATA(I,J)
     X                    -WORK1(J))/(SQRT(FLOAT(N))*WORK2(J))
   60      CONTINUE
   70   CONTINUE
C
C          Finally calc. the cross product of the data matrix.
C
        DO 100 J1 = 1, M-1
           OUT(J1,J1) = 1.0D0
           DO 90 J2 = J1+1, M
              OUT(J1,J2) = 0.0D0
              DO 80 I = 1, N
                 OUT(J1,J2) = OUT(J1,J2)+DBLE(DATA(I,J1)*DATA(I,J2))
   80         CONTINUE
              OUT(J2,J1) = OUT(J1,J2)
   90      CONTINUE
  100   CONTINUE
        OUT(M,M) = 1.0D0
C
C Write out correlation file. The two header lines are
C copied from rawdata file
C
      READ(16,'(A)') BUF
      WRITE(12,'(A)') BUF
      DO 110 I=1,M
      WRITE(12,860) (OUT(I,J),J=1,M)
  860 FORMAT(8(F9.5,1X))
  110 CONTINUE
C
      REWIND (12)
      REWIND (16)
C
        RETURN
C
C Stop with error message if Zero StdDev found
C
  290 CONTINUE
      WRITE(*,*)
      WRITE(*,*) 'ERROR!! Case No ',J, ' has zero Variance ',
     1 '--cannot compute correlations!'
      WRITE(*,*) 'Processing is stopped... Hit ENTER to finish'
      READ(*,*)
      STOP
C
        END
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C                                   
C Reduce a real, symmetric matrix to a symmetric, tridiagonal
C matrix.                         
C                                 
C To call:    CALL TRED2(NM,N,A,D,E,Z)    where
C                                     
C NM = row dimension of A and Z;      
C N = order of matrix A (will always be <= NM);
C A = symmetric matrix of order N to be reduced to tridiag. form;
C D = vector of dim. N containing, on output, diagonal elts. of
C     tridiagonal matrix.               
C E = working vector of dim. at least N-1 to contain subdiagonal
C     elements.                          
C Z = matrix of dims. NM by N containing, on output, orthogonal
C     transformation matrix producing the reduction. 
C                                            
C Normally a call to TQL2 will follow the call to TRED2 in order to
C produce all eigenvectors and eigenvalues of matrix A.
C                                        
C Algorithm used: Martin et al., Num. Math. 11, 181-195, 1968. 
C                                 
C Reference: Smith et al., Matrix Eigensystem Routines - EISPACK
C Guide, Lecture Notes in Computer Science 6, Springer-Verlag, 
C 1976, pp. 489-494.                     
C                                        
C----------------------------------------------------------------
        SUBROUTINE TRED2(NM,N,A,D,E,Z)
        REAL*8 A(299,299)
        REAL D(299),E(299),Z(299,299)
C        REAL A(NM,N),D(N),E(N),Z(NM,N)
C
        DO 100 I = 1, N
           DO 100 J = 1, I
              Z(I,J) = A(I,J)
  100   CONTINUE
        IF (N.EQ.1) GOTO 320
        DO 300 II = 2, N
           I = N + 2 - II
           L = I - 1
           H = 0.0
           SCALE = 0.0
           IF (L.LT.2) GOTO 130
           DO 120 K = 1, L
              SCALE = SCALE + ABS(Z(I,K))
  120      CONTINUE
           IF (SCALE.NE.0.0) GOTO 140
  130      E(I) = Z(I,L)
           GOTO 290
  140      DO 150 K = 1, L
              Z(I,K) = Z(I,K)/SCALE
              H = H + Z(I,K)*Z(I,K)
  150      CONTINUE
C
           F = Z(I,L)
           G = -SIGN(SQRT(H),F)
           E(I) = SCALE * G
           H = H - F * G
           Z(I,L) = F - G
           F = 0.0
C
           DO 240 J = 1, L
              Z(J,I) = Z(I,J)/H
              G = 0.0
C             Form element of A*U.
              DO 180 K = 1, J
                 G = G + Z(J,K)*Z(I,K)
  180         CONTINUE
              JP1 = J + 1
              IF (L.LT.JP1) GOTO 220
              DO 200 K = JP1, L
                 G = G + Z(K,J)*Z(I,K)
  200         CONTINUE
C             Form element of P where P = I - U U' / H .
  220         E(J) = G/H
              F = F + E(J) * Z(I,J)
  240      CONTINUE
           HH = F/(H + H)
C          Form reduced A.
           DO 260 J = 1, L
              F = Z(I,J)
              G = E(J) - HH * F
              E(J) = G
              DO 250 K = 1, J
                 Z(J,K) = Z(J,K) - F*E(K) - G*Z(I,K)
  250         CONTINUE
  260      CONTINUE
  290      D(I) = H
  300   CONTINUE
  320   D(1) = 0.0
        E(1) = 0.0
C       Accumulation of transformation matrices.
        DO 500 I = 1, N
           L = I - 1
           IF (D(I).EQ.0.0) GOTO 380
           DO 360 J = 1, L
              G = 0.0
              DO 340 K = 1, L
                 G = G + Z(I,K) * Z(K,J)
  340         CONTINUE
              DO 350 K = 1, L
                 Z(K,J) = Z(K,J) - G * Z(K,I)
  350         CONTINUE
  360      CONTINUE
  380      D(I) = Z(I,I)
           Z(I,I) = 1.0
           IF (L.LT.1) GOTO 500
           DO 400 J = 1, L
              Z(I,J) = 0.0
              Z(J,I) = 0.0
  400      CONTINUE
  500   CONTINUE
C
        RETURN
        END
C+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C              
C Determine eigenvalues and eigenvectors of a symmetric,
C tridiagonal matrix.     
C                         
C To call:    CALL TQL2(NM,N,D,E,Z,IERR)    where
C                             
C NM = row dimension of Z;    
C N = order of matrix Z;      
C D = vector of dim. N containing, on output, eigenvalues;
C E = working vector of dim. at least N-1;      
C Z = matrix of dims. NM by N containing, on output, eigenvectors;
C IERR = error, normally 0, but 1 if no convergence.    
C                      
C Normally the call to TQL2 will be preceded by a call to TRED2 in 
C order to set up the tridiagonal matrix.   
C                     
C Algorithm used: QL method of Bowdler et al., Num. Math. 11,
C 293-306, 1968.                   
C                                 
C Reference: Smith et al., Matrix Eigensystem Routines - EISPACK 
C Guide, Lecture Notes in Computer Science 6, Springer-Verlag,
C 1976, pp. 468-474.                 
C                                    
C--------------------------------------------------------------
        SUBROUTINE TQL2(NM,N,D,E,Z,IERR)
        REAL    D(299), E(299), Z(299,299)
C        REAL    D(N), E(N), Z(NM,N)
        DATA    EPS/1.E-12/
C
        IERR = 0
        IF (N.EQ.1) GOTO 1001
        DO 100 I = 2, N
           E(I-1) = E(I)
  100   CONTINUE
        F = 0.0
        B = 0.0
        E(N) = 0.0
C
        DO 240 L = 1, N
           J = 0
           H = EPS * (ABS(D(L)) + ABS(E(L)))
           IF (B.LT.H) B = H
C          Look for small sub-diagonal element.
           DO 110 M = L, N
              IF (ABS(E(M)).LE.B) GOTO 120
C             E(N) is always 0, so there is no exit through
C             the bottom of the loop.
  110      CONTINUE
  120      IF (M.EQ.L) GOTO 220
  130      IF (J.EQ.30) GOTO 1000
           J = J + 1
C          Form shift.
           L1 = L + 1
           G = D(L)
           P = (D(L1)-G)/(2.0*E(L))
           R = SQRT(P*P+1.0)
           D(L) = E(L)/(P+SIGN(R,P))
           H = G-D(L)
C
           DO 140 I = L1, N
              D(I) = D(I) - H
  140      CONTINUE
C
           F = F + H
C          QL transformation.
           P = D(M)
           C = 1.0
           S = 0.0
           MML = M - L
C
           DO 200 II = 1, MML
              I = M - II
              G = C * E(I)
              H = C * P
              IF (ABS(P).LT.ABS(E(I))) GOTO 150
              C = E(I)/P
              R = SQRT(C*C+1.0)
              E(I+1) = S * P * R
              S = C/R
              C = 1.0/R
              GOTO 160
  150         C = P/E(I)
              R = SQRT(C*C+1.0)
              E(I+1) = S * E(I) * R
              S = 1.0/R
              C = C * S
  160         P = C * D(I) - S * G
              D(I+1) = H + S * (C * G + S * D(I))
C             Form vector.
              DO 180 K = 1, N
                 H = Z(K,I+1)
                 Z(K,I+1) = S * Z(K,I) + C * H
                 Z(K,I) = C * Z(K,I) - S * H
  180         CONTINUE
  200      CONTINUE
           E(L) = S * P
           D(L) = C * P
           IF (ABS(E(L)).GT.B) GOTO 130
  220      D(L) = D(L) + F
  240   CONTINUE
C
C       Order eigenvectors and eigenvalues.
        DO 300 II = 2, N
           I = II - 1
           K = I
           P = D(I)
           DO 260 J = II, N
              IF (D(J).GE.P) GOTO 260
              K = J
              P = D(J)
  260      CONTINUE
           IF (K.EQ.I) GOTO 300
           D(K) = D(I)
           D(I) = P
           DO 280 J = 1, N
              P = Z(J,I)
              Z(J,I) = Z(J,K)
              Z(J,K) = P
  280      CONTINUE
  300   CONTINUE
C
        GOTO 1001
C       Set error - no convergence after 30 iterns.
 1000   IERR = L
 1001   RETURN
        END  
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    QROTAT    ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE QROTAT( VARIMX )
C
C(2.08): Instead of this low-resolution graphics module, the external
C  program pqrot.exe is launched -if it exists
C(2.09): pqrot.exe is assumed to be where pqmethod.exe is 
C(2.20) and
C(2.34): In 2.34 the finding and launching of PQROT was thoroughly
C  revised to make the code compatible also with GFORTAN (for windows
C  so far) and also for porting it to Linux. 
C  In the original version up to 2.11 which used the DJGPP/DOS-port 
C  of G77, locating the path to PQMethod, and therefore also to PQROT
C  was easy because this compiler version in the DOS environment always
C  returned the full path together with the executable file name with
C  the command GETARG(0,PRGDIR) -- even in the case when the PQMthod.exe 
C  was found via the PATH environment variable when entering 'pqmethod'
C  at the command line. The directory part in the string variable
C  PRGDIR returned from GETARG(0,PRGDIR), that is, the location of the
C  PQMethod.exe and hence of PQROT was easily determined by locating
C  the last occurrence of either of the separator characters "/", "\",
C  or ":".
C  With the windows versions of G77 and GFORTRAN, only the exact string
C  entered at the command line (or via drag&drop etc.) is catched by
C  GETARG. 
C  2.20 introduced a first fix for the bug that crashed PQMethod when
C  compiled with the windows version of G77 in case the command line
C  command did not contain any of the mentioned separator characters. 
C  This bug fix did not, however, secure that PQROT could be found
C  and launched if the command line argument did not contain its
C  location directory. Since 2.34 the logic of searching for and  
C  launching of PQROT is as follows:
C  * If there exists a separator character for determining the  
C  directory path (which is always the case when compiled with G77 
C  for DOS), PQROT is launched if either the file 'pqrot.exe'  
C  (DOS/Windows, case insensitive) or the file 'pqrot' (Linux,
C  case sensitive) is found in this directory. Otherwise the user
C  is informed that PQROT is not available, and that PQMethod continues
C  with the built-in rotation procedure.
C * If there is no separator character, the user is informed that PQROT
C  couldn't be located on the system but is given the choice to try anyway.
C  'Trying anyway' means that the command 'pqrot' is issued, and if not
C  successful, the system (Windows) will print out an error message followed
C  by a note issued by PQMethod about this failure and that it will continue
C  with the internal non-graphic rotation.
C  Addendum: I couldn't find out (and tried out a lot) why the
C  "IF(ISEP.EQ.0) INQUIRE(FILE='pqrot.exe',EXIST=EXST)" does not succeed in
C  finding pqrot.exe in the current working directory.
C
C(2.34): When defining "/" or "\" within a string, G77 but not GFORTRAN
C   requires to put a "\" before these characters ("\/" and "\\"). For
C   making the code compatible with GFORTRAN, these separator characters are 
C   defined now with the CHAR function. 
C
C This routine (when not launching the PQROT add-on program!)
C 1. Reads in a data file from unit 3 or 13 (previous rotation or not)
C 2. Displays the (modified) data file on the screen
C 3. Prompts for factors to rotate, plus variables to display
C 4. Plots the user chosen factors, and subjects on screen
C 5. Accepts angle to rotate the graph and repeats steps 2-4
C 6. Repeates steps 2 to 5 until user stops it
C 7. a) Output user chosen factor loadings to unit 2
C    b) Output the processed loadings for input next time
C    c) Outputs a record of rotation angles and factors used
C
C Limitations:
C   Maximum 8 factors
C   Maximum 299 subjects
C
C
      IMPLICIT INTEGER (A-Z)
      REAL THETA
      INTEGER  LOW, HIGH, VERTSZ(-6:13)
      INTEGER VARARR(299),ARRPTR
      LOGICAL ENDFLG,STAR,VARIMX,CHANGE,FIRST,EXST,FIRSTR
      CHARACTER*1 ANS,UPCHAR,SLSH,CSLSH
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8, FEXT*4
      CHARACTER PRGDIR*128
C
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT5/ VARARR,ARRPTR,LOW,HIGH,VERTSZ
      DATA EXST/.FALSE./ 
C
      SLSH=CHAR(47)   ! defining slash (/) as string variable
      CSLSH=CHAR(92)  ! defining counterslash (\) 
C
C Launch PQROT if possible
C Use getarg to determine place of PQMethod, there should also
C be the PQROT.EXE
C
      CALL GETARG(0,PRGDIR)
      ISEP=MAX0(LINDEX(PRGDIR,SLSH),LINDEX(PRGDIR,CSLSH),
     1 LINDEX(PRGDIR,':') )
      IF(ISEP.GT.0) THEN
        INQUIRE(FILE=PRGDIR(1:ISEP) // 'pqrot.exe',EXIST=EXST)
        IF(.NOT.EXST) INQUIRE(FILE=PRGDIR(1:ISEP)//'pqrot',EXIST=EXST)
        IF(.NOT.EXST) GOTO 1
      ELSE
        PRGDIR=' '
        ISEP=1
      ENDIF
      WRITE(*,*)
      IF (VARIMX) THEN
        WRITE(*,*) 'Next, varimax factors will be displayed for ',
     1    'additional rotations [optional] '
        WRITE(*,*) 'and for adding flags [required] - ',
     1    'Do you wish to use the ' 
        WRITE(*,*) 'PQROT add-on program for that (Y/n)? '
        FEXT=".rot"
      ELSE
        WRITE(*,*) 
     1   'Do you want to launch the PQROT add-on program (Y/n)? '
        FEXT=""
      ENDIF
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ')  ANS='Y'
      IF(UPCHAR(ANS).EQ.'N') GOTO 2 
C
      IF (.NOT.EXST) THEN
        WRITE(*,*) 'I cannot find PQROT on your system. '
        WRITE(*,*) 'Shall I try anyway? (Y/n) ? '
        READ(*,'(A1)',IOSTAT=IO) ANS
        IF (IO .LT. 0 .OR. ANS .EQ. ' ')  ANS='Y'      
        IF(UPCHAR(ANS).EQ.'N') GOTO 2 
      ENDIF 
C
C Close files first, and then launch PQROT (if available)
C (files will be reopened again by ASSFIL after return)
C Note: The 'status'-variable (ISTAT) of the system intrinsic
C which works alright in djgpp-g77 (0 if Ok, otherwise -1 or 1?) is
C always '0' in the w32-g77, irrespective of the existence of
C pqrot.exe.
C
      CALL CLOSFS
      CALL SYSTEM(PRGDIR(1:ISEP) // 'pqrot ' //
     1  PRNAME(1:LENGTH(PRNAME)) //FEXT //' /qs',ISTAT)     
C
C If pqrot isn't available, files have to be reopened again
C    
      IF(ISTAT.NE.0) THEN 
        CALL ASSFIL(.FALSE.,PRNAME,FNAME)
        GOTO 1
      ENDIF
C
      RETURN
C
C PQROT could not be found / launched 
C
 1    WRITE(*,*) 
      WRITE(*,*)
      WRITE(*,*)
     1 'PQROT is not available on your system. I  will continue'
      WRITE(*,*) 'with the internal non-graphic rotation.'
      WRITE(*,*)
      WRITE(*,*)
C
C Do not use PQROT - continue as if PQROT would not exist
C
 2    CONTINUE
 
C
C No changes to the data have been made yet
      CHANGE = .FALSE.
      FIRST  = .TRUE.
      FIRSTR = .TRUE.
C
C Find out whether to read in previously rotated data (unit 3) or
C unrotated data from factor analysis (unit 13)
C
      IF (VARIMX) THEN
         INDAT = 14
      ELSE
         WRITE(*,*)
     1    'Is this a continuation of a previous rotation? (y/n): '
         READ(*,'(A1)',IOSTAT=IO) ANS
         IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
            ANS = 'N'
         ENDIF
         IF (upchar(ANS).EQ.'Y') THEN
            INDAT = 3
         ELSE
            INDAT = 13
         ENDIF
      ENDIF
C
C
C Read in the title records from the data file
C
C  Read in stats, the title , and design specs.
C
      READ(INDAT,821,END=999,ERR=999) NFAX,NSORTS,NITEMS,PRTITL
  821 FORMAT(3I3,1X,A68)
C
      READ(INDAT,822) LOW,HIGH,VERTSZ
  822 FORMAT(22(I3))
C
C Read the original loadings from unit indat
      CALL RDLOAD(INDAT)
C
C Accept specifications from the terminal
   10 ENDFLG = .FALSE.
C
C Clear the screen
C     CALL CLRSCR
C
      CALL SEEDAT
      IF (VARIMX .AND. FIRST) GOTO 30
      CALL RDINP
      IF (ENDFLG) GO TO 30
C
C Initialize, load, and display the graph
   20 CALL INGRPH
      CALL LDGRPH
      CALL SHOGRH
C
C Accept rotation angle and calculate the rotated loadings
      CALL RDANGL(THETA)
      IF (THETA .EQ. 0.) GO TO 10
      CHANGE = .TRUE.
      CALL ROTATE(THETA,FIRSTR)
      GO TO 20
C
C Accept the decision to start over again or not
   30 CONTINUE
      FIRST = .FALSE.
      WRITE(*,*) 'More rotating? (y/N): '
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
         GO TO 40
      ENDIF
      IF (upchar(ANS) .EQ. 'Y') GO TO 10
C
C Finally, mark sorts for factors, accept choice of factors to keep
C    and write them to unit 2.
C
   40 CALL WTLOAD(CHANGE)
C
      RETURN
C
C No input file
C
  999 CONTINUE
      CALL INERR(INDAT)
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       RDLOAD       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Read in the original loadings
C
      SUBROUTINE RDLOAD(INDAT)
      IMPLICIT INTEGER (A-Z)
      LOGICAL ENDFLG,STAR
      REAL LOADIN
      INTEGER INDAT
      CHARACTER*1 LOADX
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT4/ LOADIN(299,8),LOADX(299,8)
C
      DO 10 I=1,NSORTS
      READ(INDAT,810,END=20,ERR=20) (LOADIN(I,J),LOADX(I,J),J=1,NFAX)
  810 FORMAT (8(F9.5,A1))
   10 CONTINUE
C
   20 CONTINUE
      REWIND (INDAT)
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>        RDINP       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Read from the screen choice of factors and variables(subjects)
C
      SUBROUTINE RDINP
      IMPLICIT INTEGER (A-Z)
      LOGICAL ENDFLG,STAR
      LOGICAL DIGIT
      INTEGER VARARR(299),ARRPTR
      INTEGER  LOW, HIGH, VERTSZ(-6:13)
      CHARACTER*80 COLALL
      CHARACTER COL(80)
      EQUIVALENCE (COLALL, COL(1))
      CHARACTER*1 CCOL,OPT
      CHARACTER*299 LINE
C
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT5/ VARARR,ARRPTR,LOW,HIGH,VERTSZ
C
      ENDFLG = .FALSE.
C
      WRITE(*,*) 'Please enter your choice of factors (two only): '
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
        ENDFLG = .TRUE.
        RETURN
      ENDIF
      IF(.NOT.DIGIT(LINE(1:1))) THEN
        ENDFLG = .TRUE.
        RETURN
      ENDIF
CMS      CALL PUTTMP(LINE)
      READ(LINE,*,IOSTAT=IO) F1,F2
      IF(IO.NE.0) THEN
        ENDFLG = .TRUE.
        RETURN
      ENDIF
      IF(F1.LT.1.OR.F2.LT.1) THEN
        ENDFLG = .TRUE.
        RETURN
      ENDIF
      IF(F1.GT.NFAX.OR.F2.GT.NFAX) THEN
        ENDFLG = .TRUE.
        RETURN
      ENDIF
C
C
      WRITE(*,*) 'Please enter your choice of variables (* for all): '
      READ(*,'(80A)',IOSTAT=IO) COL
      IF (IO .LT. 0 .OR. COLALL .EQ. ' ') THEN
        ENDFLG = .TRUE.
        RETURN
      ENDIF
C
C Check for non-numeric entry
C
      READ(COL,'(A1)')CCOL
      IF(CCOL.LT.'0') COL(1)='*'
C
C
C Process the input choice of variables
C
      CALL INLINE(COL,NSORTS,VARARR,ARRPTR)
C     CALL CLRSCR
C
C Accept choice of graph characters
C
      WRITE(*,*) 'Please enter choice of graph representation'
      WRITE(*,*) '1 -- using stars, 2 -- using numbers: '
      READ(*,'(A1)',IOSTAT=IO) OPT
      IF (IO .LT. 0 .OR. OPT .EQ. ' ') THEN
        ENDFLG = .TRUE.
        RETURN
      ENDIF
C
      IF (OPT.EQ.'1'.OR.OPT.EQ.'*') THEN
        STAR = .TRUE.
      ELSE
        STAR = .FALSE.
      ENDIF
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       INLINE       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Decipher the input line for numbers
C
      SUBROUTINE INLINE (COL,MAX,ARR,PTR)
      IMPLICIT INTEGER (A-Z)
      INTEGER ARR(299),PTR
      CHARACTER FORM*80, COL(80), TMPSTR(3), TEMSTR*3
      LOGICAL DASH
      EQUIVALENCE (TEMSTR,TMPSTR)
C
C Read in specifications and set up variables needed
C
C
      TEMSTR = ' '
      TMPPTR = 0
      PTR = 0
      DASH = .FALSE.
C
C One character at a time from the input line
      DO 10 I = 1,80
C
C If it is a number
      IF (COL(I) .GE. '0' .AND. COL(I) .LE. '9') THEN
        TMPPTR = TMPPTR + 1
        TMPSTR(TMPPTR) = COL(I)
      ENDIF
C
C If it is a hyphen '-'
      IF (COL(I) .EQ. '-') THEN
        WRITE(FORM,'(A,I1,A)') '(I',TMPPTR,')'
        READ(TEMSTR,FORM) BEGVAR
        TEMSTR = ' '
        TMPPTR = 0
        DASH = .TRUE.
      ENDIF
C
C If it is a comma ',' or a blank ' '
      IF (COL(I) .EQ. ',' .OR. COL(I) .EQ. ' ') THEN
        IF (TEMSTR .NE. ' ') THEN
          WRITE(FORM,'(A,I1,A)') '(I',TMPPTR,')'
C
C Test if it is a range of numbers
          IF (DASH) THEN
            READ(TEMSTR,FORM) ENDVAR
            DO 20 J = BEGVAR, ENDVAR
            PTR = PTR + 1
            ARR(PTR) = J
   20       CONTINUE
            DASH = .FALSE.
          ELSE
            READ(TEMSTR,FORM) OLYVAR
            PTR = PTR + 1
            ARR(PTR) = OLYVAR
          ENDIF
        TEMSTR = ' '
        TMPPTR = 0
        ENDIF
      ENDIF
C
C If it is a star '*'
      IF (COL(I) .EQ. '*') THEN
        IF (DASH) THEN
          ENDVAR = MAX
          DASH = .FALSE.
        ELSE
          BEGVAR = 1
          ENDVAR = MAX
        ENDIF
      DO 30 J = BEGVAR, ENDVAR
      PTR = PTR + 1
      ARR(PTR) = J
   30 CONTINUE
C
      ENDIF
C
   10 CONTINUE
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       LDGRPH       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Loading the GRPH array
C
      SUBROUTINE LDGRPH
      IMPLICIT INTEGER (A-Z)
      REAL LOADIN
      CHARACTER*1 LOADX
      CHARACTER GRPH
      INTEGER  LOW, HIGH, VERTSZ(-6:13)
      INTEGER VARARR(299),ARRPTR
      LOGICAL ENDFLG,STAR

      COMMON /ROTAT2/ GRPH(0:21,49)
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT4/ LOADIN(299,8),LOADX(299,8)
      COMMON /ROTAT5/ VARARR,ARRPTR,LOW,HIGH,VERTSZ
C
      DO 10 I = 1,ARRPTR
C
C Do not plot if one of the two coefficients exceeds unity 
      IF (ABS(LOADIN(VARARR(I),F1)).GT.1 .OR.
     1    ABS(LOADIN(VARARR(I),F2)).GT.1) GOTO 10
C
C Calculate the coordinates for the graph
      IF(LOADIN(VARARR(I),F1).GT.0) THEN
         IX = 11 - INT((10*LOADIN(VARARR(I),F1) + .5))
      ELSE
         IX = 11 - INT((10*LOADIN(VARARR(I),F1) - .5))
      END IF
      IF(LOADIN(VARARR(I),F2).GT.0) THEN
         IY = INT((23*LOADIN(VARARR(I),F2) + .5)) + 24
      ELSE
         IY = INT((23*LOADIN(VARARR(I),F2) - .5)) + 24
      END IF
C
C Put in the chosen graph representaion
         IF (STAR) THEN
            IF (GRPH(IX,IY) .EQ. '*') THEN
               GRPH(IX,IY) = '+'
            ELSE
               GRPH(IX,IY) = '*'
            ENDIF
         ELSE
            IF (GRPH(IX,IY) .NE. ' ' .AND. GRPH(IX,IY) .NE. '-'
     *           .AND. GRPH(IX,IY) .NE. '|'
     *           .AND. GRPH(IX,IY) .NE. ':') THEN
               GRPH(IX,IY) = '+'
            ELSE
               IF (VARARR(I) .GT. 9) THEN
                  GRPH(IX,IY) = '*'
               ELSE
                  WRITE(GRPH(IX,IY),'(I1)') VARARR(I)
               ENDIF
            ENDIF
         ENDIF
   10 CONTINUE
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       INGRPH       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Initialize the graph (put in blanks and x & y axes)
C
      SUBROUTINE INGRPH
      IMPLICIT INTEGER (A-Z)
      LOGICAL ENDFLG,STAR
      CHARACTER GRPH

      COMMON /ROTAT2/ GRPH(0:21,49)
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      DO 20 I = 0,21
         DO 10 J = 1,49
            GRPH(I,J) = ' '
   10    CONTINUE
   20 CONTINUE
      DO 30 I = 1,47
         GRPH(11,I) = '-'
   30 CONTINUE
      DO 40 J = 1,21
         GRPH(J,24) = '|'
   40 CONTINUE
      GRPH (11,24) = '+'
      GRPH (11,12) = ':'
      GRPH (11,36) = ':'
      GRPH ( 6,24) = ':'
      GRPH (16,24) = ':'

      WRITE(GRPH(0,24),'(I1)') F1
      WRITE(GRPH(11,49),'(I1)') F2
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       RDANGL       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Read the rotation angle from the screen
C
      SUBROUTINE RDANGL(THETA)
      REAL THETA
      CHARACTER*80 LINE
      WRITE(*,*) ' '
      WRITE(*,*) 'Please enter rotation angle: '
      READ(*,'(A)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
         THETA = 0.
      ELSE
CMS         CALL PUTTMP(LINE)
         READ(LINE, *, IOSTAT=IO) THETA
         IF (IO .NE. 0) THETA = 0.
      ENDIF
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       ROTATE       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Calculate rotated loadings
C
      SUBROUTINE ROTATE (THETA,FIRST)
C
      IMPLICIT INTEGER (A-Z)
      REAL LOADIN
      LOGICAL ENDFLG,STAR,FIRST
      CHARACTER*1 LOADX

      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT4/ LOADIN(299,8),LOADX(299,8)
      REAL THETA,RADIAN,RF1,RF2,RAD
C
C Write the headings for printer output (if FIRST run)
      IF(FIRST) THEN
        REWIND (4)
        WRITE(4,820) 'FTR#1','FTR#2','ANGLE'
      ENDIF
  820 FORMAT (2X,A,2X,A,2X,A,/)
C
C Transfer angle to radian
      RADIAN = THETA / 180 * 3.14159
      RAD = ABS(RADIAN)
C
C Use different formula for positive and negative angle
C
C If counterclockwise
      IF (RADIAN .LT. 0) THEN
         DO 10 I = 1,NSORTS
         RF1 = LOADIN(I,F1) * COS(RAD) - LOADIN(I,F2) * SIN(RAD)
         RF2 = LOADIN(I,F1) * SIN(RAD) + LOADIN(I,F2) * COS(RAD)
         LOADIN(I,F1) = RF1
         LOADIN(I,F2) = RF2
   10 CONTINUE
C Clockwise
      ELSE
         DO 20 J = 1,NSORTS
         RF1 = LOADIN(J,F2) * SIN(RAD) + LOADIN(J,F1) * COS(RAD)
         RF2 = LOADIN(J,F2) * COS(RAD) - LOADIN(J,F1) * SIN(RAD)
         LOADIN(J,F1) = RF1
         LOADIN(J,F2) = RF2
   20  CONTINUE
      ENDIF
C
C Output the rotation angle used and the factor numbers chosen
      WRITE(4,810) F1,F2,THETA
  810 FORMAT (3X,I2,5X,I2,3X,F5.0)
C
      FIRST=.FALSE.
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       SHOGRH       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Display the grph on screen
C
      SUBROUTINE SHOGRH
      CHARACTER GRPH

      COMMON /ROTAT2/ GRPH(0:21,49)
C
C     CALL CLRSCR
C
      DO 10 I = 0,21
      WRITE(*,'(15X,49A)') (GRPH(I,J),J=1,49)
   10 CONTINUE
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       SEEDAT       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C Display the current loadings on the screen
C
      SUBROUTINE SEEDAT
C
      IMPLICIT INTEGER (A-Z)
      LOGICAL ENDFLG,STAR
      REAL LOADIN
      INTEGER LOADOT(299,8)
      CHARACTER*1 LOADX
      CHARACTER*54 HLDARR(299)

      REAL XX
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT4/ LOADIN(299,8),LOADX(299,8)
C
      DO 10 I=1,120
      HLDARR(I)='  '
   10 CONTINUE
C
      IF(NSORTS.LE.15) GO TO 60
C
C Print out the current table in two columns
C
C Put in integer form for display
C
      DO 20 J=1,NFAX
      DO 20 I=1,NSORTS
      XX = LOADIN(I,J)
      IF(XX.GT.0) XX = XX + .005001
      IF(XX.LT.0) XX = XX - .005001
      LOADOT(I,J)= INT(XX * 100)
   20 CONTINUE
C
      DO 30 I = 1,NSORTS
      WRITE(HLDARR(I),810) I,(LOADOT(I,J),LOADX(I,J),J=1,NFAX)
  810 FORMAT(I3,2X,8(I3,A1))
   30 CONTINUE
C
      INDXA=1
   40 CONTINUE
      WRITE(*,'(2('' SUBJ  1   2   3   4   5   6   7   8    ''))')
C
      INDXB=INDXA+14
      IF(INDXB.GT.NSORTS)INDXB=NSORTS
      DO 50 I = INDXA,INDXB
      WRITE(*,'(A38,3X,A38)') HLDARR(I),HLDARR(I+15)
   50 CONTINUE
      IF((INDXB+15).GE.NSORTS) RETURN
      INDXA=INDXA+30
      WRITE(*,820)
  820 FORMAT ('   ',//,' MORE... PRESS RETURN TO CONTINUE. ')
      READ(*,*)
      GO TO 40
C
   60 CONTINUE
C
C Print out the current table in one column
C
      DO 70 J=1,NFAX
      DO 70 I=1,NSORTS
      XX = LOADIN(I,J)
      IF(XX.GT.0) XX = XX + .005001
      IF(XX.LT.0) XX = XX - .005001
      LOADOT(I,J)= INT(XX * 100)
   70 CONTINUE
C
      DO 80 I = 1,NSORTS
         WRITE(HLDARR(I),830) I,(LOADOT(I,J),LOADX(I,J),J=1,NFAX)
  830 FORMAT(I4,2X,8(1X,I4,A1))
   80 CONTINUE
C
      WRITE(*,'('' SUBJ'',8I6)') (I,I=1,NFAX)
      DO 90 I = 1,NSORTS
      WRITE(*,'(A54)') HLDARR(I)
   90 CONTINUE
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       WTLOAD       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE WTLOAD (CHANGE)
      LOGICAL ENDFLG,STAR
      CHARACTER*80 KOLALL
      CHARACTER KOL(80)
      EQUIVALENCE (KOLALL, KOL(1))
      CHARACTER*1 LOADX
      INTEGER FACARR(299),FACPTR
      INTEGER  LOW, HIGH, VERTSZ(-6:13)
      INTEGER VARARR(299),ARRPTR
      INTEGER F1,F2
      REAL LOADIN
      LOGICAL CHANGE
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8

      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT4/ LOADIN(299,8),LOADX(299,8)
      COMMON /ROTAT5/ VARARR,ARRPTR,LOW,HIGH,VERTSZ
C
C  Only if a change has been made to the data,
C    write out stats, the title, and design specs to temporary file
C    in case there is a need to return to rotate.
C
      IF( CHANGE ) THEN
         WRITE(3,810) NFAX,NSORTS,NITEMS,PRTITL
  810    FORMAT(3I3,1X,A68)
C
         WRITE(3,820) LOW,HIGH,VERTSZ
  820    FORMAT(22(I3))
C
         DO 10 I=1,NSORTS
            WRITE(3,830) (LOADIN(I,J),LOADX(I,J),J=1,NFAX)
  830       FORMAT (8(F9.5,A1))
   10    CONTINUE
      ENDIF
C
C Attach flags to entries to associate sorts with factors
C (this is the array 'LOADX' that is parallel to 'LOADIN')
C
      CALL GETX
C
C Accept numbers for chosen factors to be output
   15 WRITE(*,*)
     1   'Which factors would you like to write out?  (put them'
      WRITE(*,*) '  in the order you want them in the output file): '
      READ(*,'(80A)',IOSTAT=IO) KOL
      IF (IO .LT. 0 .OR. KOLALL .EQ. ' ') THEN
         REWIND (3)
         RETURN
      ENDIF
      CALL INLINE(KOL,NFAX,FACARR,FACPTR)
CSMK: was:      CALL INLINE(KOL,7,FACARR,FACPTR)
C
CSMK (2.0e) Check that no of factors to be output LE 8
C
      IF (FACPTR.GT.8) THEN
        WRITE(*,*) 'You cannot output more than 8 factors!'
        WRITE(*,*) 'Hit <ENTER> to continue.'
        READ(*,*)
        CALL SEEDAT
        GOTO 15
      END IF

C Write out stats, the title, and design specs.
CSMK: Put a copy into .hro, too
C
      REWIND (3)
      REWIND (14)
      WRITE(14,840) FACPTR,NSORTS,NITEMS,PRTITL
      WRITE(3,840) FACPTR,NSORTS,NITEMS,PRTITL
  840 FORMAT(3I3,1X,A68)
C
      WRITE(14,850) LOW,HIGH,VERTSZ
      WRITE(3,850) LOW,HIGH,VERTSZ
  850 FORMAT(22(I3))
C
C
C Output the loadings for the factors chosen
CSMK: Again, also into .hro
C
      DO 20 I = 1,NSORTS
      WRITE(14,860) (LOADIN(I,FACARR(J)),LOADX(I,FACARR(J)),J=1,FACPTR)
      WRITE(3,860) (LOADIN(I,FACARR(J)),LOADX(I,FACARR(J)),J=1,FACPTR)
  860 FORMAT (8(F9.5,A1))
   20 CONTINUE
C
      REWIND (14)
      REWIND (3)
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>        GETX        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE GETX
      REAL LOADIN
      LOGICAL ENDFLG,STAR
      INTEGER FLAGS(40)
      INTEGER F1,F2
      CHARACTER ANS
      CHARACTER*120 LINE
      CHARACTER*1 LOADX
      LOGICAL DIGIT

      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT4/ LOADIN(299,8),LOADX(299,8)
C
      WRITE(*,*) 
     1 'The next step associates individual sorts with factors '
      WRITE(*,*) 
     1 '(required before executing the QANALYZE module). '
      WRITE(*,*) 
      WRITE(*,*) 'Do you wish to flag factors? --Enter ',
     1 'a null return to accept or '
      WRITE(*,*) 'n to bypass or p to start out with a set of ',
     1 'program-generated factor flags'
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO.LT.0 .OR. ANS .EQ. ' ') THEN
          ANS = 'Y'
      ENDIF
      IF(ANS.EQ.'N' .OR. ANS.EQ.'n') RETURN
      IF(ANS.EQ.'P' .OR. ANS.EQ.'p') CALL PREFLG
   10 CONTINUE
C     CALL CLRSCR
      CALL SEEDAT
      WRITE(*,*) 
     1 'Enter the number of the factor for (re-)flagging'
      WRITE(*,*)
     1   '                        (Enter a null return when you'
      WRITE(*,*)
     1   '                         are finished marking factors): '
      READ(*,'(A5)',IOSTAT=IO) LINE
      IF (IO .LT. 0 .OR. LINE .EQ. ' ') THEN
        GO TO 40
      ENDIF
CMS      CALL PUTTMP(LINE)
C
      IF(.NOT.DIGIT(LINE(1:1))) GO TO 40
      READ(LINE,*,IOSTAT=IO) NUMFAC
C
      IF (NUMFAC.LT.1.OR.NUMFAC.GT.NFAX.OR.IO.GT.0) THEN
          WRITE(*,*) 'Number entered is out of range. '
          GO TO 10
      ENDIF
      WRITE(*,*) 'Enter the numbers of the sorts to be flagged,'
      WRITE(*,*) 'one at a time, separated by spaces (e.g. 3 4 8)'
      WRITE(*,*)
      READ(*,'(A120)',IOSTAT=IO) LINE
      IF (IO.LT.0 .OR. LINE .EQ. ' ') THEN
          GO TO 10
      ENDIF
C
C Check for non-numeric entry
C
      IF(.NOT.DIGIT(LINE(1:1))) THEN
          GO TO 10
      ENDIF
C
      NCOUNT=NWORDS(LINE)
C
CMS      CALL PUTTMP(LINE)
      READ(LINE,*,ERR=10) (FLAGS(I),I=1,NCOUNT)
C
C    Clean the slate (remove any previous flags)
      DO 20 I=1,NSORTS


      LOADX(I,NUMFAC)=' '
   20 CONTINUE
C
      DO 30 I=1,NCOUNT
      LOADX(FLAGS(I),NUMFAC)='X'
   30 CONTINUE
      GO TO 10
C
   40 CONTINUE
      RETURN
      END
C
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       PREFLG       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE PREFLG 
C
C  This is the place where the analytical criterion for
C  "flagging" factors is defined. 
C  By using the "Fuerntratt-Criterion" here, no Sort (Person) 
C  can be flagged for more than one factor, though not every
C  Sort may be found to be a marker (flag) for any of the 
C  factors. Moreover, there can be factors left without a "flag".
C  Since version 2.0d added ('anded') additional 'significance
C  criterion'
C
      LOGICAL ENDFLG,STAR
      REAL LOADIN
      CHARACTER*1 LOADX
      INTEGER F1,F2
      COMMON /ROTAT3/ F1,F2,NSORTS,NFAX,ENDFLG,STAR,NITEMS
      COMMON /ROTAT4/ LOADIN(299,8),LOADX(299,8)
C
      DO 10 I=1,NSORTS
C
C  Reset all to "unflagged"
C
      DO 20 J=1,NFAX
   20 LOADX(I,J)=' '
C
C  Compute H2, Item communality
C
      H2=0.0
      DO 30 J=1,NFAX
   30 H2=H2+LOADIN(I,J)*LOADIN(I,J)
C
C Flag Item I on Factor J if A^2/H^2 > .5 (Fuerntratt-Criterion)
C *and* a > 1.96/sqrt(nitems)
C
      SIG=1.96/SQRT(1.0*NITEMS)
      DO 40 J=1,NFAX
      CRIT=LOADIN(I,J)*LOADIN(I,J)/H2
      IF (CRIT.GT.0.5.AND.ABS(LOADIN(I,J)).GT.SIG) THEN
        LOADX(I,J)='X'
        GOTO 40
      ENDIF
   40 CONTINUE
   10 CONTINUE
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    VARMAX    ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
CSMK (2.11) Added ERRDAT-handling with sub VARMAX: 
C  ERRDAT is now passed to MAIN to prevent calling 
C  QROTAT if .unr is not OK.
C
      SUBROUTINE VARMAX (ERRDAT)
C
C     VARIMAX program --- modification of kaisers method
C
      LOGICAL ERRDAT
C
C     CALL CLRSCR
C
      WRITE(*,*) 'Performing VARIMAX rotation...'
C
      CALL READIT(ERRDAT)
      IF(ERRDAT) RETURN
      CALL CALCIT
      CALL WRITER
C
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       READIT       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
CSMK (2.10): V(299*8)
C
      SUBROUTINE READIT(ERRDAT)
      IMPLICIT REAL*8 (A-H,O-Z)
C
      DIMENSION X(299)
      INTEGER  LOW, HIGH, VERTSZ(-6:13)
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /VMAX01/ TV(299),S(299),NC,NITEMS
      COMMON /VMAX02/ H(299),V(2392),NSORTS,NFAX
      LOGICAL ERRDAT
      CHARACTER*3 NUMB
      LOGICAL DIGIT
C
C  Read in stats, the title, and design specs.
C
      ERRDAT=.FALSE.
      READ(13,810,END=30,ERR=30) NFAX,NSORTS,NITEMS,PRTITL
  810 FORMAT(3I3,1X,A68)
      READ(13,820,END=30,ERR=30) LOW,HIGH,VERTSZ
  820 FORMAT(22(I3))
      IF(NFAX.LE.1) GOTO 30

C
C Ask how many factors shall be rotated
C
      WRITE(*,*) 
     1 'How many factors do you wish to rotate? '
      WRITE(*,'(A,I2,A)') 
     1 ' (Press <ENTER> to rotate all ',NFAX,' unrotated factors)'
      READ(*,'(A3)',IOSTAT=IO) NUMB
      IF (IO.GE.0.AND.NUMB.NE.' '.AND.DIGIT(NUMB(1:1))) THEN
CMS        CALL PUTTMP(NUMB)
        READ(NUMB,*) NANSW
        NFAX=MIN(NANSW,NFAX)
        NFAX=MAX(2,NFAX)
      ENDIF
      WRITE(*,'(I2,A,A)') NFAX, 
     1 ' Varimax factors will be output to file ',
     1 FNAME(1:LENGTH(FNAME))//'.rot'
      WRITE(*,*) 
C
C  Write out stats, the title, and design specs to the disk output
C
      WRITE(14,830) NFAX,NSORTS,NITEMS,PRTITL
  830 FORMAT(3I3,1X,A68)
C
      WRITE(14,840) LOW,HIGH,VERTSZ
  840 FORMAT(22(I3))
C
      DO 20 J=1,NSORTS
      READ(13,850,END=30,ERR=30) (X(I),I=1,NFAX)
  850 FORMAT(8(F9.5,1X))
      K=J
      DO 10 I=1,NFAX
      V(K)=X(I)
      K=K+NSORTS
   10 CONTINUE
   20 CONTINUE
C
      REWIND (13)
      RETURN
C
   30 CONTINUE
      CALL INERR(13)
      ERRDAT=.TRUE.
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       CALCIT       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
CSMK (2.10): V(299*8)
C
      SUBROUTINE CALCIT
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON /VMAX01/ TV(299),S(299),NC,NITEMS
      COMMON /VMAX02/ H(299),V(2392),NSORTS,NFAX
      DIMENSION CRIT(8)
C
C     Initialization
C
      TVLT=0.0D0
      LL=NFAX-1
      NV=1
      NC=0
      FN=NSORTS
      FFN=FN*FN
      CONS=0.7071066D0
C
      DO 10 I=1,NFAX
   10 CRIT(I)=0.0D0
C
C     Calculate original communalitites
C
      DO 110 I=1,NSORTS
      H(I)=0.0D0
      DO 110 J=1,NFAX
      L=NSORTS*(J-1)+I
      H(I)=H(I)+V(L)*V(L)
  110 CONTINUE
C
C     Calculate "normalized" factor matrix
C(2.20) Terminology clarified in .lis, no more "normalized"
C(2.08) Division by Zero (communality) ruled out. Leaving a
C  case with all Zero loadings instead of deleting it does
C  not seem to affect Varimax greatly

      DO 120 I=1,NSORTS
      H(I)=SQRT(H(I))
      DO 120 J=1,NFAX
      L=NSORTS*(J-1)+I
      IF (H(I).GT.0.0D0) V(L)=V(L)/H(I)
  120 CONTINUE
      GO TO 132
C
C     Calculate variance for factor matrix
C
  130 NV=NV+1
      TVLT=TV(NV-1)
  132 TV(NV)=0.0D0
      DO 150 J=1,NFAX
      AA=0.0D0
      BB=0.0D0
      LB=NSORTS*(J-1)
      DO 140 I=1,NSORTS
      L=LB+I
      CC=V(L)*V(L)
      AA=AA+CC
      BB=BB+CC*CC
  140 CONTINUE
      TV(NV)=TV(NV)+(FN*BB-AA*AA)/FFN
  150 CONTINUE
C
C     Check to see if number of iterations are over 225
C
      IF(NV-225) 160,430,430
C
C     Perform convergence test
C
  160 IF ((TV(NV)-TVLT)-(1.D-7)) 170,170,190
  170 NC=NC+1
      IF (NC-3) 190,190,430
C
C     Rotation of two factors
C
  190 DO 420 J=1,LL
      L1=NSORTS*(J-1)
      II=J+1
C
C     Calculate NUM and DEN
C
      DO 420 K1=II,NFAX
      L2=NSORTS*(K1-1)
      AA=0.0D0
      BB=0.0D0
      CC=0.0D0
      DD=0.0D0
      DO 230 I=1,NSORTS
      L3=L1+I
      L4=L2+I
      U=(V(L3)+V(L4))*(V(L3)-V(L4))
      T=V(L3)*V(L4)
      T=T+T
      CC=CC+(U+T)*(U-T)
      DD=DD+2.0D0*U*T
      AA=AA+U
      BB=BB+T
  230 CONTINUE
      T=DD-2.0D0*AA*BB/FN
      B=CC-(AA*AA-BB*BB)/FN
C
C     Comparsion of NUM and DEN
C
      IF (T-B) 280,240,320
  240 IF ((T+B)-.00116D0) 420,250,250
C
C     NUM + DEN is greater than or equal to the
C     tolerance factor
C
  250 COS4T=CONS
      SIN4T=CONS
      GO TO 350
C
C     NUM is less than DEN
C
  280 TAN4T=ABS(T)/ABS(B)
      IF (TAN4T-.00116D0) 300,290,290
  290 COS4T=1.0D0/SQRT(1.0D0+TAN4T*TAN4T)
      SIN4T=TAN4T*COS4T
      GO TO 350
  300 IF (B) 310,420,420
  310 SINP=CONS
      COSP=CONS
      GO TO 400
C
C     NUM is greater than DEN
C
  320 CTN4T=ABS(T/B)
      IF (CTN4T-.00116D0) 340,330,330
  330 SIN4T=1.0D0/SQRT(1.0D0+CTN4T*CTN4T)
      COS4T=CTN4T*SIN4T
      GO TO 350
  340 COS4T=0.0D0
      SIN4T=1.0D0
C
C     Determine COS theta and SIN theta
C
  350 COS2T=SQRT((1.0D0+COS4T)/2.0D0)
      SIN2T=SIN4T/(2.0D0*COS2T)
      COST=SQRT((1.0D0+COS2T)/2.0D0)
      SINT=SIN2T/(2.0D0*COST)
C
C     Determine COS phi and SIN phi
C
      IF (B) 370,370,360
  360 COSP=COST
      SINP=SINT
      GO TO 380
  370 COSP=CONS*COST+CONS*SINT
      SINP=ABS(CONS*COST-CONS*SINT)
  380 IF (T) 390,390,400
  390 SINP=-SINP
C
C     Perform rotation
C
  400 DO 410 I=1,NSORTS
      L3=L1+I
      L4=L2+I
      AA=V(L3)*COSP+V(L4)*SINP
      V(L4)=-V(L3)*SINP+V(L4)*COSP
      V(L3)=AA
  410 CONTINUE
  420 CONTINUE
      GO TO 130
C
C     Denormalize varimax loadings
C CRIT is used later as criterion for direction of factor
C
  430 DO 440 I=1,NSORTS
      DO 440 J=1,NFAX
      L=NSORTS*(J-1)+I
      V(L)=V(L)*H(I)
      CRIT(J)=CRIT(J)+V(L)*ABS(V(L))
  440 CONTINUE
C
C  Reflect factors with mostly negative loadings
C
      DO 480 J=1,NFAX
      IF(CRIT(J).GE.0.0D0) GOTO 480
      DO 481 I=1,NSORTS
      L=NSORTS*(J-1)+I
      V(L)=-V(L)
  481 CONTINUE
  480 CONTINUE
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       WRITER       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
CSMK (2.10): V(299*8)
C
      SUBROUTINE WRITER
      IMPLICIT REAL*8 (A-H,O-Z)

      COMMON /VMAX01/ TV(299),S(299),NC,NITEMS
      COMMON /VMAX02/ H(299),V(2392),NSORTS,NFAX
C
C  Write out the rotated data matrix to disk
C
      DO 20 I=1,NSORTS
      DO 10 J=1,NFAX
      L=NSORTS*(J-1)+I
      S(J)=V(L)
   10 CONTINUE
C
      WRITE(14,810) (S(J),J=1,NFAX)
  810 FORMAT(8(F9.5,1X))
C
   20 CONTINUE
      REWIND (14)
C
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    QANAL     ***<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE QANAL(FNAME)
C
      CHARACTER*64 FNAME
      CHARACTER*1 ANS, UPCHAR
      CHARACTER*8 TIM
C
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
C
C     Q-Analysis Program
C
      MLNSPG = 52
C
      WRITE(*,*)
   10 WRITE(*,*)
     1   ' PQMethod is going to write the report into the file'
      WRITE(*,'(10X,A)') FNAME(1:LENGTH(FNAME))//'.lis'
      WRITE(*,*)
     1   ' with max. 132 chars/line and ',MLNSPG, ' lines/page'
      WRITE(*,*) ' Do you want to change no. lines/page? (y/N): '
      READ(*,'(A1)',IOSTAT=IO) ANS
      IF (IO .LT. 0 .OR. ANS .EQ. ' ') THEN
         ANS='N'
      ENDIF
C
      IF(UPCHAR(ANS).EQ.'Y') THEN
        WRITE(*,*) 'Please enter no. lines/page: '
        READ(*,*) MLNSPG
        IF (MLNSPG.LT.50) THEN
           WRITE(*,*) ' INVALID NUMBER! (min. 50)'
           WRITE(*,*) ' '
           MLNSPG = 60
           GOTO 10
        ENDIF
      ENDIF
C
CSMK (2.0e) Open listing file 
C The following two lines first delete the listing file if that
C exists already. Needed only when compiling with the DOS version of
C G77 which has a bug that consists in leaving some trash at the 
C end of an output file if that file existed before.
C
      OPEN (15,FILE=FNAME(1:LENGTH(FNAME))//'.lis')
      CLOSE (15,STATUS='DELETE')
C
      OPEN (15,FILE=FNAME(1:LENGTH(FNAME))//'.lis')
C
      CALL READIN !read 14/.rot, 1/.sta 
      CALL BCKGRD !read 13/.unr, 12/.cor; ptint corr. matr., 
	            !  unrotated matr., cumul. communalitities
      CALL MAIN02 !print factor matrix (via QMAT1), compute factor
	            !  weights FWT(I,J) and factor scores WTXITM(I,K)
                  !  (2.20): also exact factor weights and scores, 
                  !  XFW and XFS
      CALL MAIN03 !QMAT2: Print "Rank statement totals": Factor 
	            !  z-scores and ranks
	            !ZMATRI: computes Z-scores (again?!: ZSC(J,L)) and their intercorrelations
	            !print desc. array of z-scores and desc. array of differences
                  !(2.20) QMAT3: Print exact factor scores
			!print factor arrays, Cons.vs.Diagr table, factor
			!  arrays sorted by DISG
      CALL FAXDAT !outputs factors in the raw data file format
      CALL MAIN04 !factor comparisons and consensus statements
C
C Write 'timestamp' at the end of listing file
C 
      CALL SSTIME(TIM)
      WRITE(15,'(//2A)') 'QANALYZE was completet at ',TIM
C
C(2.09) Returning to the main menu instead of exiting 
C      CALL EXITPR
      RETURN
C
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       READIN       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE READIN
      CHARACTER IDEFVA*1,NAME*60
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL03/ VARNCE,STDDEV,F(8),FACRXX(8)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      COMMON /ANAL05/ XBAR,NDEFS(8),SE(8),IVALUE(15)
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
C
      INTEGER  LOW, HIGH, VERTSZ(-6:13)
C      CHARACTER*80  IFT
C
C
C     Factor score program for Q-sort data
C
C     Maximum limits
C        200 - statements - cases
C        299 - Q-sorts - variables
C          8 - factors
C
      IPAGE=0
C
C  Read in stats, the title, and design specs.
C
      READ(14,810,ERR=999,END=997) NFAX,NSORTS,NITEMS,PRTITL
  810 FORMAT(3I3,1X,A68)
C
      READ(14,820,ERR=999,END=997) LOW,HIGH,VERTSZ
  820 FORMAT(22(I3))
C
C
C     Check for errors in parameter card
C
      IF (NFAX.LE.0.OR.NFAX.GT.8) CALL ERROR (1)
      IF (NSORTS.LE.0.OR.NSORTS.GT.299) CALL ERROR (1)
      IF (NITEMS.LE.0.OR.NITEMS.GT.200) CALL ERROR (1)
C
C  Calculate value and freq arrays from structure
C
      MAX = HIGH + (1-LOW)
      DO 10 II=1,MAX
      IVALUE(II) = MAX + 1 - II
   10 CONTINUE
C
      JJ = HIGH
      DO 20 II=1,MAX
      FREQ(II) = VERTSZ(JJ)
      JJ = JJ-1
   20 CONTINUE
C
C     Read in name cards for each statement - 60 spaces
C
      DO 30 J=1,NITEMS
      READ(1,830,END=120,ERR=120) NAME(J)
  830 FORMAT(A60)
   30 CONTINUE
      REWIND (1)
C
      DO 40 I=1,8
      F(I)=0.80
   40 CONTINUE
C
C     Read in factor matrix
C
      DO 50 J=1,NSORTS
      READ(14,840,END=997,ERR=997) (FLOAD(J,K),IDEFVA(J,K),K=1,NFAX)
  840 FORMAT(8(F9.5,A1))
   50 CONTINUE
C
C
C  Check to make sure all factors have flags, and drop unflagged
C  factors. If no factor remains, exit with error message.
C
      DO 60 K=1,NFAX
      NDEFS(K)=0
      DO 60 J=1,NSORTS
      IF(IDEFVA(J,K).EQ.'x') IDEFVA(J,K)='X'
   60 IF(IDEFVA(J,K).EQ.'X'.AND.FLOAD(J,K).NE.0.) NDEFS(K)=NDEFS(K)+1
C
      KK=0
      DO 70 K=1,NFAX
      IF (NDEFS(K).EQ.0) GOTO 70
      KK=KK+1
      IF(KK.EQ.K) GOTO 70
      DO 71 J=1,NSORTS
      FLOAD(J,KK)=FLOAD(J,K)
   71 IDEFVA(J,KK)=IDEFVA(J,K)
   70 CONTINUE
C
      IF(KK.EQ.0) CALL ERROR (5)
C
      IF(KK.NE.NFAX) THEN
        WRITE(*,*)
        WRITE(*,'(I3,A)') NFAX-KK
     1    ,' unflagged factors have been dropped ...'
        WRITE(*,*)
        NFAX=KK
      ENDIF
C
C  The following seems to be an undocumented feature:
C  Raw data can be read from ROTFX, if, after factor loadings
C  there is one line with the format statement, e.g. '(40F2.0)'
C  and then there are Nitems lines with Nsorts each data entries.
C  SMK
C
C      READ(14,'(A80)',END=90,ERR=90) IFT
C      DO 80 J=1,NITEMS
C      READ(14,IFT,END=110,ERR=110) (RDATA(K,J),K=1,NSORTS)
C   80 CONTINUE
C      GO TO 110
C
C     Read original raw data file separately
C
   90 CONTINUE
      READ(16,*,ERR=998,END=998) 
      READ(16,*,ERR=998,END=998) 
      DO 100 K=1,NSORTS
      READ(16,'(A8,2X,200F2.0)',END=999,ERR=999) 
     1   SORTID(K), (RDATA(K,J),J=1,NITEMS)
  100 CONTINUE
      REWIND (16)
C
  110 CONTINUE
C
C     Forced (X) into all defining variates
C
      RETURN
  120 CONTINUE
      REWIND (14)
      CALL ERROR (6)
      RETURN
  997 CONTINUE
      CALL ERROR (5)
      RETURN
  998 CONTINUE
      CALL ERROR (7)
      RETURN
  999 CONTINUE
      CALL ERROR (2)
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       BCKGRD       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE BCKGRD

      REAL CORRMX(299,299),UNRTMX(299,8)
      INTEGER ICORMX(299,299)
      INTEGER IFAX,ISORTS
      CHARACTER*80 BUF
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      REAL SS(8) 
      LOGICAL LPCA
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
	  
      LPCA=.FALSE.
C
C  First, get the parameters from the first record of the unrotated
C  matrix file.  (We'll read in the rest of it in the second step)
C
      READ(13,810,END=20,ERR=20)IFAX,NSORTS
  810 FORMAT(2I3)
C
C*******************************************************************
C
C  Get the correlation matrix
C
      READ(12,*,END=10,ERR=10) 
      READ(12,*) 
      GO TO 30
   10 CONTINUE
      CALL ERROR (3)
   20 CONTINUE
      CALL ERROR (4)
C
   30 CONTINUE
      DO 40 J=1,NSORTS
      READ(12,820) (CORRMX(J,K),K=1,NSORTS)
  820 FORMAT(8(F9.5,1X))
   40 CONTINUE
      REWIND (12)
C
C Reset to two places
C
      DO 50 J=1,NSORTS
      DO 50 K=1,NSORTS
      IF(CORRMX(J,K).GT.0) CORRMX(J,K)=CORRMX(J,K)+.005
      IF(CORRMX(J,K).LT.0) CORRMX(J,K)=CORRMX(J,K)-.005
      ICORMX(J,K)=INT(CORRMX(J,K) * 100)
   50 CONTINUE
C
C  Print it out
C
      DO 60 I=1,NSORTS,30
      L=MIN0(I+29,NSORTS)
C
      DO 60 J=1,NSORTS
      IF (LLINES.GE.MLNSPG.OR.J.EQ.1) THEN
         CALL PAGE
         WRITE(15,830)
         WRITE(15,840) (K,K=I,L)
         WRITE(15,850)
         LLINES = LLINES + 5
      ENDIF
      WRITE(15,860) J,SORTID(J),(ICORMX(J,K),K=I,L)
      LLINES = LLINES + 1
   60 CONTINUE
  830 FORMAT(/,'Correlation Matrix Between Sorts  ')
  840 FORMAT(/'SORTS',7X,30(I4))
  850 FORMAT (' ')
  860 FORMAT(I3,1X,A8,30I4)
C
C*******************************************************************
C
C Get the unrotated matrix (remember, the first record was read above)
C
C 
C  Initialize SS, 'explained variance'
C
      DO 5 K=1,IFAX
    5 SS(K)=0.0
C
      READ(13,*) 
      DO 70 J=1,NSORTS
      READ(13,870) (UNRTMX(J,K),K=1,IFAX)
  870 FORMAT(8(F9.5,1X))
   70 CONTINUE
C
C  Determine if .unr was created by QPCA
C
	  READ(13,'(A60)',END=29,ERR=29) BUF
      IF (INDEX(BUF, 'Eigenvalues') .NE. 0 )  LPCA=.TRUE.
   29 CONTINUE  
C 
      REWIND (13)
C
      IF (LLINES.GT.MLNSPG-11-NSORTS) CALL PAGE
      WRITE(15,880)
  880 FORMAT(/,'Unrotated Factor Matrix ')
      WRITE(15,890) (K,K=1,IFAX)
  890 FORMAT(16X,'Factors',/,10X,8(8X,I2))
C
      WRITE(15,900)
  900 FORMAT (' SORTS')
      LLINES=LLINES+5

      DO 80 J=1,NSORTS
      IF (LLINES.GE.MLNSPG) THEN
        CALL PAGE
        WRITE(15,'(/A)') 'Unrotated Factor Matrix (continued)'
        WRITE(15,890) (K,K=1,IFAX)
        WRITE(15,900)
        LLINES=LLINES+5
      END IF
      WRITE(15,910) J,SORTID(J),(UNRTMX(J,K),K=1,IFAX)
  910 FORMAT(I3,1X,A8,2X,8(2X,F8.4))
      LLINES=LLINES+1
      DO 80 K=1,IFAX
      SS(K)=SS(K)+UNRTMX(J,K)*UNRTMX(J,K)
   80 CONTINUE
C 
      IF (LLINES.GE.MLNSPG-3) THEN
        CALL PAGE
        WRITE(15,'(/A)') 'Unrotated Factor Matrix (continued)'
        WRITE(15,890) (K,K=1,IFAX)
        WRITE(15,900)
        LLINES=LLINES+5
      END IF
      WRITE(15,911) (SS(K),K=1,IFAX)
  911 FORMAT(/' Eigenvalues',2X,8(2X,F8.4))
      WRITE(15,912) ( INT(0.5+100.*SS(K)/NSORTS) , K=1,IFAX )
  912 FORMAT(' % expl.Var.',2X,8(2X,I8))
      LLINES = LLINES + 3
C*******************************************************************
C
C(2.10) Write table with "cumulative communalities"
C  The squared and within rows cumulatively added unrotated 
C  loading coefficients are stored within the same matrix,
C  UNRTMX, which before held the original coefficients. 
C  Similarly, also in SS, eigenvalues as computed already before,
C  are added up.
C
      IF (LLINES.GT.MLNSPG-11-NSORTS) CALL PAGE
      WRITE(15,480)
  480 FORMAT(/,'Cumulative Communalities Matrix ')
      WRITE(15,490) (K,K=1,IFAX)
  490 FORMAT(16X,'Factors 1 Thru ....',/,10X,8(8X,I2))
C
      WRITE(15,900)
      LLINES=LLINES+5

      DO 84 J=1,NSORTS
      IF (LLINES.GE.MLNSPG) THEN
        CALL PAGE
        WRITE(15,'(/A)') 'Cumulative Communalities Matrix (continued)'
        WRITE(15,490) (K,K=1,IFAX)
        WRITE(15,900)
        LLINES=LLINES+5
      END IF
      DO 83 K=1,IFAX
      UNRTMX(J,K)=UNRTMX(J,K)*UNRTMX(J,K)
   83 IF (K.NE.1)  UNRTMX(J,K)=UNRTMX(J,K)+UNRTMX(J,K-1)

      WRITE(15,910) J,SORTID(J),(UNRTMX(J,K),K=1,IFAX)
      LLINES=LLINES+1
   84 CONTINUE
C 
      DO 85 K=2,IFAX
   85 SS(K)=SS(K)+SS(K-1)

      IF (LLINES.GE.MLNSPG-2) THEN
        CALL PAGE
        WRITE(15,'(/A)') 'Cumulative Communalities Matrix (continued)'
        WRITE(15,490) (K,K=1,IFAX)
        WRITE(15,900)
        LLINES=LLINES+4
      END IF
      WRITE(15,913) ( INT(0.5+100.*SS(K)/NSORTS) , K=1,IFAX )
  913 FORMAT(/'cum% expl.Var.',8(2X,I8))
      LLINES = LLINES + 3
C
C*******************************************************************
C
C Now get the angles of rotation (QANGLES)
C(2.08) First det. no of lines in .qan -- no more than 200 expected!
C  if .qan is empty assume Varimax
C(2.20) Output of QANGLES commented out. The reason is that it
C cannot be controlled that the saved .qan belongs to the current
C analysis (the .rot).
C
C      REWIND (4)
C      DO 90 I=1,200
C   90 READ(4,'(A)',END=91) BUF
C   91 IL=I-1
CC the .qan contains i-1 lines
CC
C      IF (IL.LE.0) THEN
C        IF (LLINES.GT.MLNSPG-4) CALL PAGE
C        WRITE(15,940)
C  940   FORMAT
C     1 (//'QANGLES File Not Found - Apparently VARIMAX Was Used'/)
C        LLINES=LLINES+4
C      ELSE
C        IF (LLINES.GT.MLNSPG-IL-5) CALL PAGE
C        REWIND(4)
C        WRITE(15,920)
C  920   FORMAT(//,'Rotating Angles Used Between Factors'/)
C        DO 100 I=1,IL
C          READ(4,'(A)',END=110,ERR=110) BUF
C  100     WRITE(15,'(A)') BUF
C  110   WRITE(15,'(A)') ' '
C        LLINES = LLINES + I + 5
C      ENDIF
C
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       MAIN02       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE MAIN02
      CHARACTER IDEFVA*1,NAME*60
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      REAL FWT(299,10),xfw(299,8),WORK(299),S(8),E(8),V(8,8) 
	LOGICAL LPCA,LXFS
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL03/ VARNCE,STDDEV,F(8),FACRXX(8)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      COMMON /ANAL05/ XBAR,NDEFS(8),SE(8),IVALUE(15)
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
C
C     Print factor matrix
C
      CALL QMAT1
C
C(2.20)    
C  Compute "exact" factor score weights XFW (if QPCA not Centroid) 
C
      LXFS=.FALSE.
      IF(.NOT.LPCA) GOTO 29
      DO 25 J=1,NSORTS
      DO 25 K=1,NFAX
   25 xfw(J,K)=FLOAD(J,K) 
      N=NSORTS
	  M=NFAX
      NX=299
      MX=8
      K=0
      call MATMPI (xfw,WORK,S,E,V,N,M,NX,MX,K,IFLAG)
	  IF (IFLAG.GT.0) THEN
	     LXFS=.FALSE.
		 WRITE(*,*) ' '
         WRITE(*,*) 
     1   'Exact Factor Scores cannot be computed. Error Code: ',IFLAG
         WRITE(*,*) "Hit <ENTER> to continue"
         READ(*,*)
      ELSE
	     LXFS=.TRUE.
      END IF
C
   29 CONTINUE
C
      DO 10 I=1,8
      NDEFS(I)=0
   10 CONTINUE
C
C
C     IDEFVA = DEFINING VARIATES
C
      DO 20 I=1,NSORTS
      DO 20 J=1,NFAX
C      IF (IDEFVA(I,J).NE.' ') THEN
      IF(IDEFVA(I,J).EQ.'X') THEN
        IDEFVA(I,J)='1'
        NDEFS(J)=NDEFS(J) + 1
      ELSE
        IDEFVA(I,J)='0'
        FLOAD(I,J) = 0.0
      ENDIF
   20 CONTINUE
  
C
C         Normalize forced distribution data by subtracting
C         the mean from each observation and dividing by the
C         standard deviation.
C
      N=IVALUE(1)
      COMP1=0.0
      COMP2=0.0
      DO 30 I=1,N
      COMP1=COMP1+(FREQ(I)*IVALUE(I)*IVALUE(I))
      COMP2=COMP2+(FREQ(I)*IVALUE(I))
   30 CONTINUE
      COMP2=(COMP2*COMP2)/NITEMS
      VAR=(COMP1-COMP2)/NITEMS
      VAR=ABS(VAR)
      STDEV=SQRT(VAR)
      VARNCE=VAR
      STDDEV=STDEV
      XBAR=(IVALUE(1)+1.0)/2.0
C
C     Compute matrix of factor weights
CSMK: To prevent division by zero, factor loadings are cut
C     to a max of +/-.99
C
      DO 40 I=1,NSORTS
      DO 40 J=1,NFAX
      FL=FLOAD(I,J)
      FL=MIN(FL,.99)
      FL=MAX(FL,-.99)
      FWT(I,J)=FL/(1.0-FL*FL)
   40 CONTINUE
C
      IF (LLINES.GT.MLNSPG-8-NSORTS) CALL PAGE
      WRITE(15,810)
  810 FORMAT(/,'Free Distribution Data Results')
      WRITE(15,820)
  820 FORMAT(/' QSORT            MEAN     ST.DEV.')
      WRITE(15,830)
  830 FORMAT (' ')
      LLINES = LLINES + 5
C
      DO 70 J=1,NSORTS
      COMP1=0.0
      COMP2=0.0
C
      DO 50 I=1,NITEMS
      COMP2=COMP2+RDATA(J,I)
      COMP1=COMP1+RDATA(J,I)*RDATA(J,I)
   50 CONTINUE
C
      AVERAG=COMP2/NITEMS
      COMP2=(COMP2*COMP2)/NITEMS
      VAR=(COMP1-COMP2)/(NITEMS-1.0)
      STDEV=SQRT(VAR)
      WRITE(15,840) J,SORTID(J),AVERAG,STDEV
  840 FORMAT(I3,1X,A8,1X,2F10.3)
      LLINES = LLINES + 1
      IF (LLINES.GE.MLNSPG) THEN
         CALL PAGE
         WRITE(15,810)
         WRITE(15,820)
         LLINES = LLINES + 5
      ENDIF
   60 CONTINUE
C
      DO 70 I=1,NITEMS
      RDATA(J,I)=(RDATA(J,I)-AVERAG)/STDEV
   70 CONTINUE
C
C     Multiply each individual factor weight by the value (normalized)
C     assigned to each statement and sum across statements
C(2.20) The same is done for the "exact" factor scores, XFS -if they
C     can be computed (LXFS=.TRUE.)
C
      DO 80 I=1,NFAX
      DO 80 K=1,NITEMS
      XFS(I,K)=0.
      WTXITM(I,K)=0.0
   80 CONTINUE
C
      DO 90 I=1,NFAX
      DO 90 J=1,NSORTS
      DO 90 K=1,NITEMS
      WTXITM(I,K)=WTXITM(I,K)+RDATA(J,K)*FWT(J,I)
   90 CONTINUE
     
      IF (.NOT.LXFS) GOTO 99
      DO 91 I=1,NFAX
      DO 91 J=1,NSORTS
      DO 91 K=1,NITEMS
      XFS(I,K)=XFS(I,K)+RDATA(J,K)*XFW(J,I)
   91 CONTINUE

   99 CONTINUE
C
C     Since multiplying the normalized scores by the factor weights
C     denormalizes the dispersion, the statement totals - WTXITM(I,J)
C     must again be normalized.
C
      DO 110 I=1,NFAX
      COMP1=0.0
      COMP2=0.0
      DO 100 J=1,NITEMS
      COMP2=COMP2+WTXITM(I,J)
      COMP1=COMP1+WTXITM(I,J)*WTXITM(I,J)
  100 CONTINUE
      AVERAG=COMP2/NITEMS
      COMP2=(COMP2*COMP2)/NITEMS
      VAR=(COMP1-COMP2)/(NITEMS-1.0)
      STDEV=SQRT(VAR)
      DO 110 J=1,NITEMS
      WTXITM(I,J)=(WTXITM(I,J)-AVERAG)/STDEV
  110 CONTINUE
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       MAIN03       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE MAIN03
      CHARACTER IDEFVA*1,NAME*60
      REAL DISG(200)
      INTEGER IDISG(200)
      LOGICAL LXFS, LPCA

      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL03/ VARNCE,STDDEV,F(8),FACRXX(8)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      COMMON /ANAL05/ XBAR,NDEFS(8),SE(8),IVALUE(15)
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
C
C     Old terminology: Rank statement totals with each factor
C     for table with statements' factor scores and corresponing ranks
C
      DO 40 I=1,NFAX
      DO 30 J=1,NITEMS
      IRANK0=1
      DO 20 K=1,NITEMS
      IF (J.EQ.K) GO TO 20
      IF (WTXITM(I,J)-WTXITM(I,K)) 10,10,20
   10 CONTINUE
      IRANK0=IRANK0+1
   20 CONTINUE
      IRANK(I,J)=IRANK0
   30 CONTINUE
   40 CONTINUE
      CALL QMAT2
C
      CALL ZMATRI
C
C SMK (2.30): QMAT3 prints table with exact factor scores.
C In 2.20 it was forgotten to make this dependent on the existence
C of the exact factor scores 
C
      IF (LXFS) CALL QMAT3
C
C     Uses values and freq in control card to assign scores for
C     the rank statements
C
C     Free-dist data has no standard distribution and factor scores
C
      N=IVALUE(1)
      DO 70 I=1,NFAX
      DO 70 J=1,NITEMS
      ISUM=0
      DO 50 K=1,N
      IFREQ=INT(FREQ(K))
      ISUM=ISUM+IFREQ
      IF (IRANK(I,J).LE.ISUM) GO TO 60
   50 CONTINUE
   60 CONTINUE
      IRANK(I,J)=IVALUE(K)-INT(XBAR)
   70 CONTINUE
C
C     Print factor arrays
C
      IF (LLINES.GT.(MLNSPG-NITEMS-6)) CALL PAGE
      WRITE(15,810)
  810 FORMAT(/,'Factor Q-Sort Values for Each Statement')
      WRITE(15,820)
  820 FORMAT(/,77X,'Factor Arrays')
      WRITE(15,830) (JJ,JJ=1,NFAX)
  830 FORMAT(/,'No.  Statement',52X,'No.',5X,8(I4,3X))
      WRITE(15,840)
  840 FORMAT(' ')
      LLINES = LLINES + 6
      DO 80 J=1,NITEMS
      WRITE(15,850) J,NAME(J),J,(IRANK(I,J),I=1,NFAX)
  850 FORMAT(I3,2X,A60,I4,2X,8(5X,I2))
      LLINES = LLINES + 1
      IF (LLINES.GT.MLNSPG) THEN
         CALL PAGE
         WRITE(15,820)
         WRITE(15,830) (JJ,JJ=1,NFAX)
         WRITE(15,840)
         LLINES = LLINES + 6
      ENDIF
   80 CONTINUE
      WRITE(15,860) VARNCE,STDDEV
  860 FORMAT(//,'Variance =',F7.3,'  St. Dev. =',F7.3)
      LLINES = LLINES + 2
C
C     Consensus vs. Disagreement table (skip if NFAX < 2)
C
C     Compute variance (=DISG) of factor z-scores for all statements
C     
C
      IF (NFAX.LT.2) GOTO 91
      DO 110 J=1,NITEMS 
      COMP1=0.0
      COMP2=0.0
      DO 100 I=1,NFAX
      COMP2=COMP2+WTXITM(I,J)
      COMP1=COMP1+WTXITM(I,J)*WTXITM(I,J)
  100 CONTINUE
      COMP2=(COMP2*COMP2)/NFAX
  110 DISG(J)=(COMP1-COMP2)/(NFAX-1.0)
C
      CALL DSCND (DISG,1,IDISG,NITEMS,200,NITEMS,1)
C
C     Print factor arrays sorted by DISG
C
      IF (LLINES.GT.(MLNSPG-NITEMS-6)) CALL PAGE
      WRITE(15,811)
  811 FORMAT(
     1 /,'Factor Q-Sort Values for Statements sorted by ',
     2   'Consensus vs. Disagreement (Variance across ',
     3   'Factor Z-Scores)')
      WRITE(15,820)
      WRITE(15,830) (JJ,JJ=1,NFAX)
      WRITE(15,840)
      LLINES = LLINES + 6
      DO 150 J=NITEMS,1,-1
      JD=IDISG(J)
      WRITE(15,851) JD,NAME(JD),JD,(IRANK(I,JD),I=1,NFAX)
  851 FORMAT(I3,2X,A60,I4,2X,8(5X,I2))
      LLINES = LLINES + 1
      IF (LLINES.GT.MLNSPG) THEN
         CALL PAGE
         WRITE(15,820)
         WRITE(15,830) (JJ,JJ=1,NFAX)
         WRITE(15,840)
         LLINES = LLINES + 6
      ENDIF
  150 CONTINUE
C
C Initialize work areas for future subroutines
C
   91 DO 90 I=1,8
      SE(I)=0.0
      FACRXX(I)=0.0
   90 CONTINUE
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    FAXDAT   ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C  
C  Subroutine FAXDAT outputs factors in the raw data file format. 
C  Output is directed to file FAX.DAT; if that file exists aleady,
C  the new data are appended.
C  (2.20) A second file is output with the "exact" factor scores in
C  T-Score units (Mean=50, Std Dev=10) 
C  (2.34) Added a BACKSPACE for units 17 and 18, such that the next write
C  will not be behind the EOF. This correction of invalid code is not required
C  for G77 but for GFORTRAN.
C  
C
      SUBROUTINE FAXDAT
C
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
C
      INTEGER  LOW, HIGH, VERTSZ(-6:13), ITSC(8,200) 
      CHARACTER*9  HLDDAT, BUF*1, TIM*8
      LOGICAL LXFS
C
C
C  Read in design specs.
C
      REWIND (14)
      READ(14,800) LOW,HIGH,VERTSZ
  800 FORMAT(/22(I3))
C
C  Open output files and read until end
C
      OPEN (17,FILE='fax.dat')
   10 READ(17,'(A)',END=11) BUF
      GOTO 10
   11 BACKSPACE 17
   
      IF (LXFS) THEN
        OPEN (18,FILE='xfax.dat')
   20   READ(18,'(A)',END=21) BUF
        GOTO 20
   21   BACKSPACE 18 
      END IF
C
C  Write out stats; 'title': project title, project (-file) name,
C  date/time; and design
C
      CALL SSDATE (HLDDAT)
      CALL SSTIME (TIM)
C
      WRITE(17,810) 0,NFAX,NITEMS,'Factors: ',
     1 PRTITL(1:LENGTH(PRTITL)),' (see ', FNAME(1:LENGTH(FNAME)),
     2 '.lis, generated at ',
     2 HLDDAT, ' ', TIM, ')'
      WRITE(17,820) LOW,HIGH,VERTSZ
C
      IF (LXFS) THEN
      WRITE(18,810) 0,NFAX,NITEMS,'Exact F-Scores: ',
     1 PRTITL(1:LENGTH(PRTITL)),' (see ', FNAME(1:LENGTH(FNAME)),
     2 '.lis, generated at ',
     2 HLDDAT, ' ', TIM, ')'
       WRITE(18,820) LOW,HIGH,VERTSZ
       END IF
C
  810 FORMAT(3I3,1X,9A)
  820 FORMAT(22(I3))
C
C  Write out factor scores 
C(2.20) Exact Factor T-Scores are cut to the range 0 - 99, to
C  fit in the PQMethod I2-Format
C
      DO 50 I=1,NFAX
      WRITE(17,830) I,NFAX,(IRANK(I,J),J=1,NITEMS)
  830 FORMAT('F',I1,'of',I1,5X,200(I2))
   50 CONTINUE
C
      IF (LXFS) THEN
      DO 60 I=1,NFAX
      DO 61 J=1,NITEMS
      ITSC(I,J)=INT(50.5+10*XFS(I,J))
      ITSC(I,J)=MIN0(ITSC(I,J),99)
      ITSC(I,J)=MAX0(ITSC(I,J),0)
   61 CONTINUE
      WRITE(18,831) I,NFAX,(ITSC(I,J),J=1,NITEMS)
  831 FORMAT('XFS',I1,'of',I1,3X,200(I2))
   60 Continue
      CLOSE (18)
      END IF
C
      CLOSE (17)
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       MAIN04       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
CSMK: Added sorting of 'Distinguishing Statements' tables
C    Used added array IR for that
C     
C
      SUBROUTINE MAIN04
      CHARACTER IDEFVA*1,NAME*60
      INTEGER IR (200)
C
      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL03/ VARNCE,STDDEV,F(8),FACRXX(8)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      COMMON /ANAL05/ XBAR,NDEFS(8),SE(8),IVALUE(15)
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
      REAL SED(8,8),SED01(8,8),SED05(8,8),SQRT2, HLDSED(8)
      CHARACTER*1 FLAG01(8,200),FLAG05(8,200)
C      CHARACTER*1 CFLG01(8,200),CFLG05(8,200)
      CHARACTER*1  HLDFLG
      CHARACTER*120 FMT
C
CSMK 2.10 MAIN04 does factor comparisons, therefore leave
C     if only 1 Factor
C
      IF (NFAX.EQ.1) RETURN
C
      DO 10 I=1,NFAX
      DEFVAR=FLOAT(NDEFS(I))
      FACRXX(I)=(DEFVAR*F(I))/(1.0+((DEFVAR-1.0)*F(I)))
C
C     SE(I) = Standard error (of normalized factors within a factor)
C
      SE(I)=SQRT(1.0-FACRXX(I))
   10 CONTINUE
      IF (LLINES.GT.MLNSPG-14) CALL PAGE
      WRITE(15,810)
  810 FORMAT(//,'Factor Characteristics')
      WRITE(15,820) (I,I=1,NFAX)
  820 FORMAT(37X,'Factors',//,31X,8I9)
      WRITE(15,830) (NDEFS(I),I=1,NFAX)
  830 FORMAT(/,'No. of Defining Variables',6X,8I9)
      WRITE(15,840) (F(I),I=1,NFAX)
  840 FORMAT(/,'Average Rel. Coef.',15X,8F9.3)
      WRITE(15,850) (FACRXX(I),I=1,NFAX)
  850 FORMAT(/,'Composite Reliability',12X,8F9.3)
      WRITE(15,860) (SE(I),I=1,NFAX)
  860 FORMAT(/,'S.E. of Factor Z-Scores',10X,8F9.3)
      LLINES = LLINES + 14
C
      DO 20 I=1,NFAX
      DO 20 J=1,NFAX
C
C     SED = Standard error of differences between factor scores
C           on different factors
C
      SED(I,J)=SQRT(SE(I)*SE(I)+SE(J)*SE(J))
      IF (I.EQ.J) HLDSED(I)=SED(I,J)
   20 CONTINUE
C
C     Adjust SED(I,I) to be equal to SE(I) * SQRT(2)
C
      ARG=2
      SQRT2=SQRT(ARG)
      DO 30 I=1,NFAX
      SED(I,I)=SE(I) * SQRT2
   30 CONTINUE
C
      NTOTMP = MLNSPG - (8 + 2*NFAX)
      IF (LLINES.GT.NTOTMP) CALL PAGE
      WRITE(15,870)
  870 FORMAT(3(/),'Standard Errors for Differences in ',
     1       'Factor Z-Scores')
      WRITE(15,880)
  880 FORMAT(/,'(Diagonal Entries Are S.E. Within Factors)')
      WRITE(15,890) (I,I=1,NFAX)
  890 FORMAT(/,12X,'Factors ',8I9)
C
      DO 40 I=1,NFAX
      WRITE(15,900) I,(SED(I,J),J=1,NFAX)
  900 FORMAT(/,14X,I3,5X,8F9.3)
   40 CONTINUE
      LLINES = LLINES + 8 + 2*NFAX
C
C  Make readjustment of SED(I,I)   ( Restore value held in HLDSED() )
C
      DO 50 I=1,NFAX
      SED(I,I)=HLDSED(I)
   50 CONTINUE
C
C  SED(I,J) is multiplied by .01 and .05 alphas to get standard
C  errors for determining defining statements for each factor.
C  Results are stored in SED01 and SED05 arrays.
C
      DO 60 I=1,NFAX
      DO 60 J=1,NFAX
      SED01(I,J)=SED(I,J)*2.58
      SED05(I,J)=SED(I,J)*1.96
   60 CONTINUE
C
      DO 70 J=1,NITEMS
      DO 70 K=1,NFAX
      FLAG05(K,J)=' '
      FLAG01(K,J)=' '
C      CFLG05(K,J)=' '
C      CFLG01(K,J)=' '
   70 CONTINUE
C
C---------------------------------------------------------------------
C
C Big loop - iterate for each factor, determining defining statements
C
CSMK (2.0e): Settled problem with definition of consensus items, hope-
C fully: In the original version (1.0), CLFG01/CFLG05 were simply
C duplicates of FLAG01/FLAG05: flag an item if all comparisons gt 
C standard error, with consensus being defined as unflagged.
C However, consensus should be defined as: all comparisons lt std.err.
C This definition is implemented now.
C Also detected now that in loops 90 and 110 the .LT. should rather be
C .LE.
C
      DO 150 IFACT=1,NFAX
C
C  If only two factors, bypass processing for the second one
C
      IF(IFACT.EQ.2.AND.NFAX.EQ.2) GO TO 150
C
C  Clean the flags from the last factor (except the first time)
C
      IF(IFACT.EQ.1)GO TO 81
C
      LASTF=IFACT-1
      DO 80 J=1,NITEMS
      FLAG05(LASTF,J)=' '
      FLAG01(LASTF,J)=' '
   80 CONTINUE
   81 continue
C
      DO 100 J=1,NITEMS
      DO 90 K=1,NFAX
C
C  Do not compare factor score with self
      IF(IFACT.EQ.K)GO TO 90
C
      IF(ABS(WTXITM(IFACT,J)-WTXITM(K,J)).LE.SED05(IFACT,K))GO TO 100
   90 CONTINUE
C
C  All comparisons greater than the standard error
C
      FLAG05(IFACT,J)='*'
CSMK: that was wrong!      CFLG05(IFACT,J)='*'
  100 CONTINUE
C
      DO 120 J=1,NITEMS
      DO 110 K=1,NFAX
C
C  Now check for significance at the .01 level
C
C  Do not compare factor score with self
      IF(IFACT.EQ.K)GO TO 110
C
      IF(ABS(WTXITM(IFACT,J)-WTXITM(K,J)).LE.SED01(IFACT,K))GO TO 120
  110 CONTINUE
C
C  All comparisons greater than the standard error
C
      FLAG01(IFACT,J)='*'
CSMK: that was wrong!      CFLG01(IFACT,J)='*'
  120 CONTINUE
C
C Now print out the statements that differentiate the factors
C
      IF (LLINES.GT.MLNSPG-30) CALL PAGE
C
      WRITE(15,910) IFACT
  910 FORMAT(//,'Distinguishing Statements for Factor ',I2,//,
     1        ' (P < .05 ; ',
     2        ' Asterisk (*) Indicates Significance at P < .01)',//,
     3        'Both the Factor Q-Sort Value (Q-SV) ',
     4        'and the Z-Score (Z-SCR) are Shown.')
C
      IF (NFAX.GT.4) WRITE(15,920) (L,L=1,NFAX)
      IF (NFAX.LE.4) WRITE(15,930) (L,L=1,NFAX)
  920 FORMAT (/,35X,'Factors',//,' ',29X,8(11X,I1))
  930 FORMAT (/,72X,'Factors',//,' ',66X,8(11X,I1))
C
      IF (NFAX.GT.4) WRITE(FMT,940) NFAX
      IF (NFAX.LE.4) WRITE(FMT,950) NFAX
  940 FORMAT ('(14H No. Statement,17X,4HNo. ,',
     1         I1,'(12HQ-SV Z-SCR  ),/)')
  950 FORMAT ('(14H No. Statement,51X,4HNo. ,2X,',
     1         I1,'(12HQ-SV Z-SCR  ),/)')
C
      WRITE(15,FMT)
      LLINES = LLINES + 14
C
      JJ=0
C
C Sort array according to descending WTXITM(K,J)
C
      CALL DSCND(WTXITM,-IFACT,IR,NITEMS,8,NFAX,NITEMS)
C 
      DO 140 J=1,NITEMS
      JR=IR(J)
      IF(FLAG05(IFACT,JR).EQ.' ')GO TO 140
      JJ=JJ+1
      IF(NFAX.LE.4) GO TO 130
      WRITE(15,960) JR,NAME(JR),JR,
     1   (IRANK(K,JR),WTXITM(K,JR),FLAG01(K,JR),K=1,NFAX)
  960 FORMAT (I4,1X,A22,' ...',I3,8(3X,I2,1X,F5.2,A1))
      LLINES = LLINES + 1
      GO TO 140
C
  130 CONTINUE
C
      WRITE(15,970) JR,NAME(JR),JR,
     1   (IRANK(K,JR),WTXITM(K,JR),FLAG01(K,JR),K=1,NFAX)
  970 FORMAT (I4,1X,A60,I3,2X,4(3X,I2,1X,F5.2,A1))
      LLINES = LLINES + 1
C
  140 CONTINUE
C
      IF (JJ.EQ.0) THEN
         WRITE(15,980) IFACT
         LLINES = LLINES + 2
      ENDIF
  980 FORMAT(/'There Were NO Distinguishing Statements for Factor',I2)
C
  150 CONTINUE
C
      LASTF=NFAX
      IF(NFAX.EQ.2)LASTF=1
      DO 160 J=1,NITEMS
      FLAG05(LASTF,J)=' '
      FLAG01(LASTF,J)=' '
  160 CONTINUE
C
C
C---------------------------------------------------------------------
C
C  Now do the consensus statements.
CSMK (2.0e): No 'Cflags' required any more. Hope that's it!
C
      IF (LLINES.GT.MLNSPG-30) CALL PAGE
      WRITE(15,990)
  990 FORMAT(//,'Consensus Statements  --  Those That Do Not ',
     1       'Distinguish Between ANY Pair of Factors.',//,
     2       'All Listed Statements are Non-Significant at P>.01, ',
     3       'and Those Flagged With an * are also ',
     4       'Non-Significant at P>.05.',/,' ',/)
C
      IF (NFAX.GT.4) WRITE(15,1000) (L,L=1,NFAX)
      IF (NFAX.LE.4) WRITE(15,1010) (L,L=1,NFAX)
 1000 FORMAT (/,50X,'Factors',//,30X,8(11X,I1))
 1010 FORMAT (/,87X,'Factors',//,67X,8(11X,I1))
C
      IF (NFAX.GT.4) WRITE(FMT,1020) NFAX
      IF (NFAX.LE.4) WRITE(FMT,1030) NFAX
 1020 FORMAT ('(15H No.  Statement,17X,4HNo. ,',
     1         I1,'(12HQ-SV Z-SCR  ),/)')
 1030 FORMAT ('(15H No.  Statement,51X,4HNo. ,2X,',
     1         I1,'(12HQ-SV Z-SCR  ),/)')
C
      WRITE(15,FMT)
      LLINES = LLINES + 12
C
      JJ=0
      DO 200 J=1,NITEMS
      DO 170 K=1,NFAX-1
      DO 170 L=K+1,NFAX
      IF(ABS(WTXITM(K,J)-WTXITM(L,J)).GT.SED01(K,L))GOTO 200
  170 CONTINUE
      JJ=JJ+1
C
      HLDFLG='*'
      DO 180 K=1,NFAX-1
      DO 180 L=K+1,NFAX
      IF(ABS(WTXITM(K,J)-WTXITM(L,J)).GT.SED05(K,L)) HLDFLG=' '
  180 CONTINUE
C
      IF(NFAX.LE.4) GO TO 190
      WRITE(15,1040) J,HLDFLG,NAME(J),J,
     1   (IRANK(K,J),WTXITM(K,J),FLAG05(K,J),FLAG01(K,J),K=1,NFAX)
 1040 FORMAT (I4,A1,1X,A22,' ...',I3,1X,8(2X,I2,1X,F5.2,2A1))
      LLINES=LLINES + 1
      GO TO 200
C
  190 CONTINUE
C
      WRITE(15,1050) J,HLDFLG,NAME(J),J,
     1   (IRANK(K,J),WTXITM(K,J),FLAG05(K,J),FLAG01(K,J),K=1,NFAX)
 1050 FORMAT (I4,A1,1X,A60,I3,3X,4(2X,I2,1X,F5.2,2A1))
      LLINES=LLINES + 1
C
  200 CONTINUE
      IF (JJ.EQ.0) THEN
         WRITE(15,1060)
         LLINES=LLINES + 2
      ENDIF
 1060 FORMAT(/,'There Were NO Consensus Statements')
C
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       ZMATRI       <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE ZMATRI

      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
      DIMENSION FRAY(200,8),ZSC(200,8),ZSC2(200,8)
      DIMENSION XCORR(8,8),ISUB(200)
C
C     Make switch
C
      DO 10 J=1,NFAX
      DO 10 K=1,NITEMS
      FRAY(K,J)=WTXITM(J,K)
   10 CONTINUE
      XNO=NITEMS
C
C     Compute Z-score
C
      DO 40 L=1,NFAX
      SUM=0.0
      SSX=0.0
      DO 30 J=1,NITEMS
      SSX=SSX+FRAY(J,L)*FRAY(J,L)
      SUM=SUM+FRAY(J,L)
   30 CONTINUE
C
      XMN=SUM/XNO
      SDEV=SQRT((SSX/XNO)-(XMN*XMN))
      DO 40 J=1,NITEMS
      XMN=0.0
      SDEV=1.0
      ZSC(J,L)=(FRAY(J,L)-XMN)/SDEV
   40 CONTINUE
C
C     Compute correlation between types
C
      DO 60 L=1,NFAX
      DO 60 LL=1,NFAX
      SUM1=0.0
      SUM2=0.0
      SSXY=0.0
      SSX=0.0
      SSY=0.0
      DO 50 J=1,NITEMS
      SUM1=SUM1+ZSC(J,L)
      SUM2=SUM2+ZSC(J,LL)
      SSXY=SSXY+ZSC(J,LL)*ZSC(J,L)
      SSX=SSX+ZSC(J,L)*ZSC(J,L)
      SSY=SSY+ZSC(J,LL)*ZSC(J,LL)
   50 CONTINUE
      XMN1=SUM1/XNO
      XMN2=SUM2/XNO
      T1=SQRT((SSX/XNO)-XMN1*XMN1)
      T2=SQRT((SSY/XNO)-XMN2*XMN2)
      XCORR(L,LL)=((XNO*SSXY)-SUM1*SUM2)/(T1*T2*XNO*XNO)
   60 CONTINUE
      NTOTMP = MLNSPG - (6 + 2*NFAX)
      IF (LLINES.GT.NTOTMP) CALL PAGE
      WRITE(15,810)
  810 FORMAT(3(/),5X,'Correlations Between Factor Scores')
      WRITE(15,820) (I,I=1,NFAX)
  820 FORMAT(/,8X,8I8)
      DO 70 L=1,NFAX
      WRITE(15,830) L,(XCORR(L,LL),LL=1,NFAX)
  830 FORMAT(/,I5,3X,8F8.4)
   70 CONTINUE
      LLINES = LLINES + 6 + 2*NFAX
C
C     Print descending array of z-scores and item descriptions
C
      DO 80 L=1,NFAX
      CALL DSCND (ZSC,L,ISUB,NITEMS,200,NITEMS,NFAX)
      CALL PRIN1 (ZSC,ZSC2,1,L,L1,ISUB)
   80 CONTINUE
C
C     Print item descriptions and descending array of differences
C
      DO 100 L=1,NFAX
      LP1=L+1
      IF (LP1.GT.NFAX) GO TO 101
      DO 100 LL=LP1,NFAX
      DO 90 J=1,NITEMS
      ZSC2(J,L)=ZSC(J,L)-ZSC(J,LL)
   90 CONTINUE
      CALL DSCND (ZSC2,L,ISUB,NITEMS,200,NITEMS,NFAX)
      CALL PRIN1 (ZSC,ZSC2,2,L,LL,ISUB)
  100 CONTINUE
  101 continue
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       PRIN2        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE PRIN2 (L2,L3,L4)

      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
C
C     Title routine for print subroutine
C
C      IF (LLINES.GT.MLNSPG-8-NITEMS) CALL PAGE
      LLINES = LLINES + 6
      IF(L2.EQ.2)GO TO 10
      WRITE(15,810) L3
  810 FORMAT(3(/),'Factor Scores -- For Factor',I5)
      WRITE(15,820)
  820 FORMAT(/' No.',2X,'Statement',50X,'  No.     Z-SCORES')
      WRITE(15,830)
  830 FORMAT(' ')
      RETURN
   10 CONTINUE
      WRITE(15,840) L3,L4
  840 FORMAT(//,'Descending Array of Differences Between Factors',
     1        I4,' and',I4)
      WRITE(15,850) L3,L4
  850 FORMAT(/,' No.  Statement',50X,'  No.     Type',I4,
     1       '  Type',I4,'  Difference')
      WRITE(15,830)
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       PRIN1        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE PRIN1 (Z1,Z2,L2,L3,L4,ISUB)
      CHARACTER IDEFVA*1,NAME*60

      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      DIMENSION Z1(200,8),Z2(200,8)
      DIMENSION ISUB(200)
C
C     Print routine for Q-analysis
C
      NTOTMP = MLNSPG - (NITEMS + 6)
      IF (LLINES.GT.NTOTMP) THEN
         CALL PAGE
      ENDIF
      CALL PRIN2 (L2,L3,L4)
C
      DO 30 K=1,NITEMS
      J=ISUB(K)
      IF(L2.EQ.2) GO TO 10
      WRITE(15,810) J,NAME(J),J,Z1(J,L3)
  810 FORMAT(I4,2X,A60,I4,6X,F7.3)
      GO TO 20
   10 CONTINUE
      WRITE(15,820) J,NAME(J),J,Z1(J,L3),Z1(J,L4),Z2(J,L3)
  820 FORMAT(I4,2X,A60,I4,6X,F7.3,F10.3,F12.3)
   20 CONTINUE
      LLINES=LLINES+1
      IF (LLINES.GE.MLNSPG) THEN
         CALL PAGE
         CALL PRIN2 (L2,L3,L4)
      ENDIF
   30 CONTINUE
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       DSCND        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE DSCND (ARRAY,L1,ISUB,LSUB,ML,NL,NC)
      DIMENSION ARRAY(ML,NC),ISUB(LSUB),TEMP(200)
C
C     Routine to array subscripts in order
C     L1: line or col of matrix on which sort is based;
C     sign of L1 decides wether ARRAY's rows or columns used
C     ISUB: ordered subscripts
C     LSUB: actual length of line or column and subs. index
C     ML: ARRAY's first dimension size
C     NL: ARRAY's actual no of lines
C     NC: ARRAY's actual no of columns
C
      I1=L1
      IF (I1.GE.0) THEN
        N=NL
        DO 11 J=1,N
        ISUB(J)=J
   11   TEMP(J)=ARRAY(J,I1)
      ELSE
        N=NC
        I1=ABS(I1)
        DO 12 J=1,N
        ISUB(J)=J
   12   TEMP(J)=ARRAY(I1,J)
      ENDIF
C
      DO 30 J=2,N
      MAX=J-1
      DO 20 K=J,N
      IF (TEMP(MAX).LT.TEMP(K)) MAX=K
   20 CONTINUE
      TEMP1=TEMP(MAX)
      TEMP(MAX)=TEMP(J-1)
      TEMP(J-1)=TEMP1
      ISUB1=ISUB(MAX)
      ISUB(MAX)=ISUB(J-1)
      ISUB(J-1)=ISUB1
   30 CONTINUE
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       QMAT1        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE QMAT1
      CHARACTER IDEFVA*1,NAME*60
      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
      REAL SS(8)

      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
C
C     Routine to output factor matrices
C
C 
C  Initialize SS, 'explained variance'
C
      DO 5 K=1,NFAX
    5 SS(K)=0.0
C
      NTOTMP = MLNSPG-9-NSORTS
      IF (LLINES.GT.NTOTMP) CALL PAGE
C
      WRITE(15,810)
  810 FORMAT(/,'Factor Matrix with an X Indicating a Defining Sort')
      WRITE(15,820)
  820 FORMAT(/,16X,'Loadings')
      WRITE(15,830) (K,K=1,NFAX)
  830 FORMAT(/,' QSORT',4X,8(8X,I2))
      WRITE(15,840)
  840 FORMAT (' ')
      LLINES = LLINES + 7
C
      DO 10 J=1,NSORTS
      WRITE(15,850) J,SORTID(J),(FLOAD(J,K),IDEFVA(J,K),K=1,NFAX)
  850 FORMAT(I3,1X,A8,2X,10(F9.4,A1))
      LLINES=LLINES+1
      IF (LLINES.GE.MLNSPG) THEN
         CALL PAGE
         WRITE(15,'(/A)')
     1   'Factor Matrix with an X Indicating a Defining Sort '
     2   //'(continued)'
         WRITE(15,820)
         WRITE(15,830) (K,K=1,NFAX)
         WRITE(15,840)
         LLINES = LLINES + 7
      ENDIF
      DO 10 K=1,NFAX
      SS(K)=SS(K)+FLOAD(J,K)*FLOAD(J,K)
   10 CONTINUE
      WRITE(15,851) ( INT(0.5+100.*SS(K)/NSORTS) , K=1,NFAX )
  851 FORMAT(/' % expl.Var.',1X,8(2X,I8))
      LLINES = LLINES +2
C
C(2.08) Issue warning for cases with Zero Communality 
C
      DO 20 I=1,NSORTS
      NZ=0
      DO 21 J=1,NFAX
   21 IF (FLOAD(I,J).NE.0.0) GOTO 20
       LLINES=LLINES + 1
       WRITE(15,860) I,SORTID(I)
       WRITE(*,860) I,SORTID(I)
       WRITE(*,*) 'Press <ENTER> to continue '
       READ(*,*)
   20 CONTINUE
  860 FORMAT('WARNING! Check data of case ',I3,1X,A8,
     1 ' (all loadings = 0.0!)' )
C
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       QMAT2        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE QMAT2
      CHARACTER IDEFVA*1,NAME*60

      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
C
C     Routine to print rank statement totals
C
      L1=1
      L2=5
   10 CONTINUE
      IF (L1.GT.NFAX) RETURN
      IF (L2.GT.NFAX) L2=NFAX
      NTOTMP = MLNSPG-6- NITEMS
      IF (LLINES.GT.NTOTMP) CALL PAGE
      WRITE(15,850)
  850 FORMAT(//,'Factor Scores with Corresponding Ranks')
      WRITE(15,840)
  840 FORMAT(78X,'Factors')
      WRITE(15,830) (K,K=L1,L2)
  830 FORMAT('No.  Statement',47X,'No.',8(7X,I4))
      WRITE(15,820)
  820 FORMAT(' ')
      LLINES = LLINES + 6
C
      DO 20 J=1,NITEMS
      WRITE(15,810) J,NAME(J),J,(WTXITM(K,J),IRANK(K,J),K=L1,L2)
  810 FORMAT(I3,2X,A54,I5,3X,8(F7.2,I4))
      LLINES=LLINES+1
      IF (LLINES.GE.MLNSPG) THEN
         CALL PAGE
         WRITE(15,850)
         WRITE(15,840)
         WRITE(15,830) (K,K=L1,L2)
         WRITE(15,820)
         LLINES = LLINES + 8
         ENDIF
   20 CONTINUE
      L1=L1+5
      L2=L2+5
      GO TO 10
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>>>>>       QMAT3        <<<<<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE QMAT3
      CHARACTER IDEFVA*1,NAME*60

      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL02/ IDEFVA(299,8),NAME(200)
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
      COMMON /ANAL06/ IRANK(8,200),RDATA(299,200),WTXITM(8,200),
     1  LXFS,XFS(8,200)
C
C(2.20) Routine to print table with exact factor scores
C    For simplicity sake based on QMAT2
C
      L1=1
      L2=5
   10 CONTINUE
      IF (L1.GT.NFAX) RETURN
      IF (L2.GT.NFAX) L2=NFAX
      NTOTMP = MLNSPG-6- NITEMS
      IF (LLINES.GT.NTOTMP) CALL PAGE
      WRITE(15,850)
  850 FORMAT(//
     1 'Exact Factor Scores ( la SPSS) in Z-Score and T-Score',
     2 ' units')
      WRITE(15,840)
  840 FORMAT(78X,'Factors')
      WRITE(15,830) (K,K=L1,L2)
  830 FORMAT('No.  Statement',47X,'No.',8(7X,I4))
      WRITE(15,820)
  820 FORMAT(' ')
      LLINES = LLINES + 6
C
      DO 20 J=1,NITEMS
      WRITE(15,810) J,NAME(J),J,(XFS(K,J),
     1  INT(50.5+10*XFS(K,J)),K=L1,L2)
  810 FORMAT(I3,2X,A54,I5,3X,8(F7.2,I4))
      LLINES=LLINES+1
      IF (LLINES.GE.MLNSPG) THEN
         CALL PAGE
         WRITE(15,850)
         WRITE(15,840)
         WRITE(15,830) (K,K=L1,L2)
         WRITE(15,820)
         LLINES = LLINES + 8
         ENDIF
   20 CONTINUE
      L1=L1+5
      L2=L2+5
      GO TO 10
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***MATMPI with Dep.**<*<*<<<<<<<<<<<< <--MAIN ROUTINE-->
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C  MATMPI by Charlie Reeve(with all dependencies included in this code) 
C  is required for computing the "exact" factor scores.
      SUBROUTINE MATMPI (X,WORK,S,E,V,N,M,NX,MX,K,IFLAG)
C    http://www.itl.nist.gov/div898/software/reeves/homepage.htm
C-----------------------------------------------------------------------
C   MATMPI   WRITTEN BY CHARLES P. REEVE, STATISTICAL ENGINEERING
C            DIVISION, NATIONAL BUREAU OF STANDARDS, GAITHERSBURG,
C            MARYLAND  20899
C
C   FOR: COMPUTING THE MOORE-PENROSE PSEUDO-INVERSE OF AN NXM MATRIX
C        X WHERE N >= M.  THE TRANSPOSE OF THE INVERSE IS RETURNED IN 
C        THE ORIGINAL MATRIX.  A LINPACK ROUTINE IS USED TO PERFORM
C        A SINGULAR VALUE DECOMPOSITION OF X FROM WHICH THE INVERSE
C        X+ IS COMPUTED.  IF X IS OF FULL RANK THEN X+ = INV(X'X)*X'. 
C
C   NOTE: RNDERR IS A MACHINE DEPENDENT CONSTANT WHICH IS THE MACHINE 
C         ROUNDING ERROR (OR A LITTLE LARGER).  IT IS USED TO DETERMINE
C         WHEN A SINGULAR VALUE IS ZERO (IN CASES WHERE THE USER HAS
C         REQUESTED AUTOMATIC DETERMINATION OF RANK BY INPUTTING K=0).
C         SEE DISCUSSION OF THIS POINT ON PAGE 11.2 OF REFERENCE 1.
C
C   SUBPROGRAMS CALLED: SSVDC (LINPACK) 
C
C   CURRENT VERSION COMPLETED DECEMBER 14, 1989
C
C   REFERENCES: 
C
C   1) DONGARRA, J.J., MOLER, C.B., BUNCH, J.R., AND STEWART, G.W.,
C      "LINPACK USERS' GUIDE", SIAM, PHILADELPHIA, 1979, CH. 11.
C
C   2) LAWSON, CHARLES L. AND HANSON, RICHARD J., "SOLVING LEAST
C      SQUARES PROBLEMS", PRENTICE-HALL, INC., CH. 7.
C-----------------------------------------------------------------------
C   DEFINITION OF PASSED PARAMETERS: 
C
C    * X(NX,*) = MATRIX (SIZE N BY M) WHOSE PSEUDO-INVERSE IS TO BE
C                COMPUTED.  THE SECOND DIMENSION OF X, DEFINED IN THE 
C                CALLING PROGRAM, MUST BE >=M. [REAL]
C
C      WORK(*) = VECTOR (LENGTH N) USED AS WORKSPACE [REAL] 
C
C         S(*) = VECTOR (LENGTH M) OF SINGULAR VALUES IN DESCENDING
C                ORDER ON RETURN, PROVIDED INFO=0 ON RETURN [REAL]
C
C         E(*) = VECTOR (LENGTH M) OF ZEROS ON RETURN, PROVIDED INFO=0
C                ON RETURN [REAL]
C
C      V(MX,*) = MATRIX (SIZE M BY M) USED FOR INTERMEDIATE 
C                COMPUTATIONS [REAL]
C
C          * N = NUMBER OF ROWS IN MATRIX X [INTEGER]
C
C          * M = NUMBER OF COLUMNS IN MATRIX X (M<=N) [INTEGER]
C
C         * NX = LEADING DIMENSION OF MATRIX X (NX>=N) [INTEGER]
C
C         * MX = LEADING DIMENSION OF MATRIX V (MX>=M) [INTEGER]
C
C          * K = ON INPUT: K>0 INDICATES KNOWN RANK OF MATRIX X.
C                          K=0 INDICATES RANK SHOULD BE AUTOMATICALLY 
C                              DETERMINED BY PROGRAM.
C                ON OUTPUT: = UNCHANGED IF K>0 ON INPUT.
C                           = COMPUTED RANK OF X IF K=0 ON INPUT.
C
C        IFLAG = ERROR INDICATOR ON OUTPUT [INTEGER]  INTERPRETATION: 
C                1 -> N>NX OR M>MX.
C                2 -> N<M.
C                3 -> INFO<>0 RETURNED FROM SSVDC (SINGULAR VALUES WERE
C                     NOT COMPUTED CORRECTLY, THUS MOORE-PENROSE
C                     PSEUDO-INVERSE NOT COMPUTED).
C                4 -> K<0 ON INPUT.
C
C   * INDICATES PARAMETERS REQUIRING INPUT VALUES 
C-----------------------------------------------------------------------
C
      DIMENSION X(NX,*),WORK(*),S(*),E(*),V(MX,*) 
      DATA RNDERR / 1.0E-14 / 
      IFLAG = 0
      IF (N.GT.NX.OR.M.GT.MX) THEN
         IFLAG = 1
         RETURN
C
      ENDIF
      IF (N.LT.M) THEN
         IFLAG = 2
         RETURN
C
      ENDIF
      IF (K.LT.0) THEN
         IFLAG = 4
         RETURN
C
      ENDIF
      IF (K.EQ.0) THEN
C
C--- COMPUTE LARGEST ELEMENT OF X (IN ABSOLUTE VALUE)
C
         XMAX = 0.0 
         DO 20 I = 1, N
            DO 10 J = 1, M
               XMAX = AMAX1(XMAX,ABS(X(I,J)))
   10       CONTINUE
   20    CONTINUE
C
C--- COMPUTE CUTOFF POINT FOR A SINGULAR VALUE BEING ZERO
C
         CUTOFF = 10.0*RNDERR*XMAX
      ENDIF
C
C--- PERFORM SINGULAR VALUE FACTORIZATION USING LINPACK
C
      CALL SSVDC (X,NX,N,M,S,E,X,NX,V,MX,WORK,21,INFO)
C
C--- CHECK WHETHER SINGULAR VALUES HAVE BEEN COMPUTED CORRECTLY
C
      IF (INFO.NE.0) THEN
         IFLAG = 3
         RETURN
C
      ENDIF
      IF (K.EQ.0) THEN
C
C--- DETERMINE NUMBER OF NONZERO SINGULAR VALUES
C
         K = 0
         DO 30 J = 1, M
            IF (ABS(S(J)).GT.CUTOFF) THEN
               K = K+1
            ELSE
               GO TO 40
C
            ENDIF
   30    CONTINUE
      ENDIF
C
C--- COMPUTE THE MOORE-PENROSE PSEUDO-INVERSE OF X (TRANSPOSED)
C
   40 DO 60 J = 1, M
         DO 50 L = 1, K
            V(J,L) = V(J,L)/S(L)
   50    CONTINUE
   60 CONTINUE
      DO 100 I = 1, N
         DO 80 J = 1, M
            T = 0.0 
            DO 70 L = 1, K
               T = T+V(J,L)*X(I,L)
   70       CONTINUE
            E(J) = T
   80    CONTINUE
         DO 90 J = 1, M
            X(I,J) = E(J)
   90    CONTINUE
  100 CONTINUE
      RETURN
C
      END       
      SUBROUTINE SAXPY(N,SA,SX,INCX,SY,INCY)
*     .. Scalar Arguments ..
      REAL SA
      INTEGER INCX,INCY,N
*     ..
*     .. Array Arguments ..
      REAL SX(*),SY(*)
*     ..
*
*  Purpose
*  =======
*
*     SAXPY constant times a vector plus a vector.
*     uses unrolled loops for increments equal to one.
*
*  Further Details
*  ===============
*
*     jack dongarra, linpack, 3/11/78.
*     modified 12/3/93, array(1) declarations changed to array(*)
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER I,IX,IY,M,MP1
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC MOD
*     ..
      IF (N.LE.0) RETURN
      IF (SA.EQ.0.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) THEN
*
*        code for both increments equal to 1
*
*
*        clean-up loop
*
         M = MOD(N,4)
         IF (M.NE.0) THEN
            DO I = 1,M
               SY(I) = SY(I) + SA*SX(I)
            END DO
         END IF
         IF (N.LT.4) RETURN
         MP1 = M + 1
         DO I = MP1,N,4
            SY(I) = SY(I) + SA*SX(I)
            SY(I+1) = SY(I+1) + SA*SX(I+1)
            SY(I+2) = SY(I+2) + SA*SX(I+2)
            SY(I+3) = SY(I+3) + SA*SX(I+3)
         END DO
      ELSE
*
*        code for unequal increments or equal increments
*          not equal to 1
*
         IX = 1
         IY = 1
         IF (INCX.LT.0) IX = (-N+1)*INCX + 1
         IF (INCY.LT.0) IY = (-N+1)*INCY + 1
         DO I = 1,N
          SY(IY) = SY(IY) + SA*SX(IX)
          IX = IX + INCX
          IY = IY + INCY
         END DO
      END IF
      RETURN
      END
      REAL FUNCTION SDOT(N,SX,INCX,SY,INCY)
*     .. Scalar Arguments ..
      INTEGER INCX,INCY,N
*     ..
*     .. Array Arguments ..
      REAL SX(*),SY(*)
*     ..
*
*  Purpose
*  =======
*
*     SDOT forms the dot product of two vectors.
*     uses unrolled loops for increments equal to one.
*
*  Further Details
*  ===============
*
*     jack dongarra, linpack, 3/11/78.
*     modified 12/3/93, array(1) declarations changed to array(*)
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL STEMP
      INTEGER I,IX,IY,M,MP1
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC MOD
*     ..
      STEMP = 0.0e0
      SDOT = 0.0e0
      IF (N.LE.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) THEN
*
*        code for both increments equal to 1
*
*
*        clean-up loop
*
         M = MOD(N,5)
         IF (M.NE.0) THEN
            DO I = 1,M
               STEMP = STEMP + SX(I)*SY(I)
            END DO
            IF (N.LT.5) THEN
               SDOT=STEMP
            RETURN
            END IF
         END IF
         MP1 = M + 1
         DO I = MP1,N,5
          STEMP = STEMP + SX(I)*SY(I) + SX(I+1)*SY(I+1) +
     $            SX(I+2)*SY(I+2) + SX(I+3)*SY(I+3) + SX(I+4)*SY(I+4)
         END DO
      ELSE
*
*        code for unequal increments or equal increments
*          not equal to 1
*
         IX = 1
         IY = 1
         IF (INCX.LT.0) IX = (-N+1)*INCX + 1
         IF (INCY.LT.0) IY = (-N+1)*INCY + 1
         DO I = 1,N
            STEMP = STEMP + SX(IX)*SY(IY)
            IX = IX + INCX
            IY = IY + INCY
         END DO
      END IF
      SDOT = STEMP
      RETURN
      END
      REAL FUNCTION SNRM2(N,X,INCX)
*     .. Scalar Arguments ..
      INTEGER INCX,N
*     ..
*     .. Array Arguments ..
      REAL X(*)
*     ..
*
*  Purpose
*  =======
*
*  SNRM2 returns the euclidean norm of a vector via the function
*  name, so that
*
*     SNRM2 := sqrt( x'*x ).
*
*  Further Details
*  ===============
*
*  -- This version written on 25-October-1982.
*     Modified on 14-October-1993 to inline the call to SLASSQ.
*     Sven Hammarling, Nag Ltd.
*
*  =====================================================================
*
*     .. Parameters ..
      REAL ONE,ZERO
      PARAMETER (ONE=1.0E+0,ZERO=0.0E+0)
*     ..
*     .. Local Scalars ..
      REAL ABSXI,NORM,SCALE,SSQ
      INTEGER IX
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC ABS,SQRT
*     ..
      IF (N.LT.1 .OR. INCX.LT.1) THEN
          NORM = ZERO
      ELSE IF (N.EQ.1) THEN
          NORM = ABS(X(1))
      ELSE
          SCALE = ZERO
          SSQ = ONE
*        The following loop is equivalent to this call to the LAPACK
*        auxiliary routine:
*        CALL SLASSQ( N, X, INCX, SCALE, SSQ )
*
          DO 10 IX = 1,1 + (N-1)*INCX,INCX
              IF (X(IX).NE.ZERO) THEN
                  ABSXI = ABS(X(IX))
                  IF (SCALE.LT.ABSXI) THEN
                      SSQ = ONE + SSQ* (SCALE/ABSXI)**2
                      SCALE = ABSXI
                  ELSE
                      SSQ = SSQ + (ABSXI/SCALE)**2
                  END IF
              END IF
   10     CONTINUE
          NORM = SCALE*SQRT(SSQ)
      END IF
*
      SNRM2 = NORM
      RETURN
*
*     End of SNRM2.
*
      END
      SUBROUTINE SROT(N,SX,INCX,SY,INCY,C,S)
*     .. Scalar Arguments ..
      REAL C,S
      INTEGER INCX,INCY,N
*     ..
*     .. Array Arguments ..
      REAL SX(*),SY(*)
*     ..
*
*  Purpose
*  =======
*
*     applies a plane rotation.
*
*  Further Details
*  ===============
*
*     jack dongarra, linpack, 3/11/78.
*     modified 12/3/93, array(1) declarations changed to array(*)
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL STEMP
      INTEGER I,IX,IY
*     ..
      IF (N.LE.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) THEN
*
*       code for both increments equal to 1
*
         DO I = 1,N
            STEMP = C*SX(I) + S*SY(I)
            SY(I) = C*SY(I) - S*SX(I)
            SX(I) = STEMP
         END DO
      ELSE
*
*       code for unequal increments or equal increments not equal
*         to 1
*
         IX = 1
         IY = 1
         IF (INCX.LT.0) IX = (-N+1)*INCX + 1
         IF (INCY.LT.0) IY = (-N+1)*INCY + 1
         DO I = 1,N
            STEMP = C*SX(IX) + S*SY(IY)
            SY(IY) = C*SY(IY) - S*SX(IX)
            SX(IX) = STEMP
            IX = IX + INCX
            IY = IY + INCY
         END DO
      END IF
      RETURN
      END
      SUBROUTINE SROTG(SA,SB,C,S)
*     .. Scalar Arguments ..
      REAL C,S,SA,SB
*     ..
*
*  Purpose
*  =======
*
*     SROTG construct givens plane rotation.
*
*  Further Details
*  ===============
*
*     jack dongarra, linpack, 3/11/78.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL R,ROE,SCALE,Z
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC ABS,SIGN,SQRT
*     ..
      ROE = SB
      IF (ABS(SA).GT.ABS(SB)) ROE = SA
      SCALE = ABS(SA) + ABS(SB)
      IF (SCALE.EQ.0.0) THEN
         C = 1.0
         S = 0.0
         R = 0.0
         Z = 0.0
      ELSE
         R = SCALE*SQRT((SA/SCALE)**2+ (SB/SCALE)**2)
         R = SIGN(1.0,ROE)*R
         C = SA/R
         S = SB/R
         Z = 1.0
         IF (ABS(SA).GT.ABS(SB)) Z = S
         IF (ABS(SB).GE.ABS(SA) .AND. C.NE.0.0) Z = 1.0/C
      END IF
      SA = R
      SB = Z
      RETURN
      END
      SUBROUTINE SSCAL(N,SA,SX,INCX)
*     .. Scalar Arguments ..
      REAL SA
      INTEGER INCX,N
*     ..
*     .. Array Arguments ..
      REAL SX(*)
*     ..
*
*  Purpose
*  =======
*
*     scales a vector by a constant.
*     uses unrolled loops for increment equal to 1.
*
*  Further Details
*  ===============
*
*     jack dongarra, linpack, 3/11/78.
*     modified 3/93 to return if incx .le. 0.
*     modified 12/3/93, array(1) declarations changed to array(*)
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER I,M,MP1,NINCX
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC MOD
*     ..
      IF (N.LE.0 .OR. INCX.LE.0) RETURN
      IF (INCX.EQ.1) THEN
*
*        code for increment equal to 1
*
*
*        clean-up loop
*
         M = MOD(N,5)
         IF (M.NE.0) THEN
            DO I = 1,M
               SX(I) = SA*SX(I)
            END DO
            IF (N.LT.5) RETURN
         END IF
         MP1 = M + 1
         DO I = MP1,N,5
            SX(I) = SA*SX(I)
            SX(I+1) = SA*SX(I+1)
            SX(I+2) = SA*SX(I+2)
            SX(I+3) = SA*SX(I+3)
            SX(I+4) = SA*SX(I+4)
         END DO
      ELSE
*
*        code for increment not equal to 1
*
         NINCX = N*INCX
         DO I = 1,NINCX,INCX
            SX(I) = SA*SX(I)
         END DO
      END IF
      RETURN
      END
C     http://www.netlib.org/linpack/ssvdc.f
      subroutine ssvdc(x,ldx,n,p,s,e,u,ldu,v,ldv,work,job,info)
      integer ldx,n,p,ldu,ldv,job,info
*changed  1->*      real x(ldx,1),s(1),e(1),u(ldu,1),v(ldv,1),work(1)
      real x(ldx,*),s(*),e(*),u(ldu,*),v(ldv,*),work(*)
c
c
c     ssvdc is a subroutine to reduce a real nxp matrix x by
c     orthogonal transformations u and v to diagonal form.  the
c     diagonal elements s(i) are the singular values of x.  the
c     columns of u are the corresponding left singular vectors,
c     and the columns of v the right singular vectors.
c
c     on entry
c
c         x         real(ldx,p), where ldx.ge.n.
c                   x contains the matrix whose singular value
c                   decomposition is to be computed.  x is
c                   destroyed by ssvdc.
c
c         ldx       integer.
c                   ldx is the leading dimension of the array x.
c
c         n         integer.
c                   n is the number of rows of the matrix x.
c
c         p         integer.
c                   p is the number of columns of the matrix x.
c
c         ldu       integer.
c                   ldu is the leading dimension of the array u.
c                   (see below).
c
c         ldv       integer.
c                   ldv is the leading dimension of the array v.
c                   (see below).
c
c         work      real(n).
c                   work is a scratch array.
c
c         job       integer.
c                   job controls the computation of the singular
c                   vectors.  it has the decimal expansion ab
c                   with the following meaning
c
c                        a.eq.0    do not compute the left singular
c                                  vectors.
c                        a.eq.1    return the n left singular vectors
c                                  in u.
c                        a.ge.2    return the first min(n,p) singular
c                                  vectors in u.
c                        b.eq.0    do not compute the right singular
c                                  vectors.
c                        b.eq.1    return the right singular vectors
c                                  in v.
c
c     on return
c
c         s         real(mm), where mm=min(n+1,p).
c                   the first min(n,p) entries of s contain the
c                   singular values of x arranged in descending
c                   order of magnitude.
c
c         e         real(p).
c                   e ordinarily contains zeros.  however see the
c                   discussion of info for exceptions.
c
c         u         real(ldu,k), where ldu.ge.n.  if joba.eq.1 then
c                                   k.eq.n, if joba.ge.2 then
c                                   k.eq.min(n,p).
c                   u contains the matrix of left singular vectors.
c                   u is not referenced if joba.eq.0.  if n.le.p
c                   or if joba.eq.2, then u may be identified with x
c                   in the subroutine call.
c
c         v         real(ldv,p), where ldv.ge.p.
c                   v contains the matrix of right singular vectors.
c                   v is not referenced if job.eq.0.  if p.le.n,
c                   then v may be identified with x in the
c                   subroutine call.
c
c         info      integer.
c                   the singular values (and their corresponding
c                   singular vectors) s(info+1),s(info+2),...,s(m)
c                   are correct (here m=min(n,p)).  thus if
c                   info.eq.0, all the singular values and their
c                   vectors are correct.  in any event, the matrix
c                   b = trans(u)*x*v is the bidiagonal matrix
c                   with the elements of s on its diagonal and the
c                   elements of e on its super-diagonal (trans(u)
c                   is the transpose of u).  thus the singular
c                   values of x and b are the same.
c
c     linpack. this version dated 03/19/79 .
c              correction to shift calculation made 2/85.
c     g.w. stewart, university of maryland, argonne national lab.
c
c     ***** uses the following functions and subprograms.
c
c     external srot
c     blas saxpy,sdot,sscal,sswap,snrm2,srotg
c     fortran abs,amax1,max0,min0,mod,sqrt
c
c     internal variables
c
      integer i,iter,j,jobu,k,kase,kk,l,ll,lls,lm1,lp1,ls,lu,m,maxit,
     *        mm,mm1,mp1,nct,nctp1,ncu,nrt,nrtp1
      real sdot,t,r
      real b,c,cs,el,emm1,f,g,snrm2,scale,shift,sl,sm,sn,smm1,t1,test,
     *     ztest
      logical wantu,wantv
c
c
c     set the maximum number of iterations.
c
      maxit = 30
c
c     determine what is to be computed.
c
      wantu = .false.
      wantv = .false.
      jobu = mod(job,100)/10
      ncu = n
      if (jobu .gt. 1) ncu = min0(n,p)
      if (jobu .ne. 0) wantu = .true.
      if (mod(job,10) .ne. 0) wantv = .true.
c
c     reduce x to bidiagonal form, storing the diagonal elements
c     in s and the super-diagonal elements in e.
c
      info = 0
      nct = min0(n-1,p)
      nrt = max0(0,min0(p-2,n))
      lu = max0(nct,nrt)
      if (lu .lt. 1) go to 170
      do 160 l = 1, lu
         lp1 = l + 1
         if (l .gt. nct) go to 20
c
c           compute the transformation for the l-th column and
c           place the l-th diagonal in s(l).
c
            s(l) = snrm2(n-l+1,x(l,l),1)
            if (s(l) .eq. 0.0e0) go to 10
               if (x(l,l) .ne. 0.0e0) s(l) = sign(s(l),x(l,l))
               call sscal(n-l+1,1.0e0/s(l),x(l,l),1)
               x(l,l) = 1.0e0 + x(l,l)
   10       continue
            s(l) = -s(l)
   20    continue
         if (p .lt. lp1) go to 50
         do 40 j = lp1, p
            if (l .gt. nct) go to 30
            if (s(l) .eq. 0.0e0) go to 30
c
c              apply the transformation.
c
               t = -sdot(n-l+1,x(l,l),1,x(l,j),1)/x(l,l)
               call saxpy(n-l+1,t,x(l,l),1,x(l,j),1)
   30       continue
c
c           place the l-th row of x into  e for the
c           subsequent calculation of the row transformation.
c
            e(j) = x(l,j)
   40    continue
   50    continue
         if (.not.wantu .or. l .gt. nct) go to 70
c
c           place the transformation in u for subsequent back
c           multiplication.
c
            do 60 i = l, n
               u(i,l) = x(i,l)
   60       continue
   70    continue
         if (l .gt. nrt) go to 150
c
c           compute the l-th row transformation and place the
c           l-th super-diagonal in e(l).
c
            e(l) = snrm2(p-l,e(lp1),1)
            if (e(l) .eq. 0.0e0) go to 80
               if (e(lp1) .ne. 0.0e0) e(l) = sign(e(l),e(lp1))
               call sscal(p-l,1.0e0/e(l),e(lp1),1)
               e(lp1) = 1.0e0 + e(lp1)
   80       continue
            e(l) = -e(l)
            if (lp1 .gt. n .or. e(l) .eq. 0.0e0) go to 120
c
c              apply the transformation.
c
               do 90 i = lp1, n
                  work(i) = 0.0e0
   90          continue
               do 100 j = lp1, p
                  call saxpy(n-l,e(j),x(lp1,j),1,work(lp1),1)
  100          continue
               do 110 j = lp1, p
                  call saxpy(n-l,-e(j)/e(lp1),work(lp1),1,x(lp1,j),1)
  110          continue
  120       continue
            if (.not.wantv) go to 140
c
c              place the transformation in v for subsequent
c              back multiplication.
c
               do 130 i = lp1, p
                  v(i,l) = e(i)
  130          continue
  140       continue
  150    continue
  160 continue
  170 continue
c
c     set up the final bidiagonal matrix or order m.
c
      m = min0(p,n+1)
      nctp1 = nct + 1
      nrtp1 = nrt + 1
      if (nct .lt. p) s(nctp1) = x(nctp1,nctp1)
      if (n .lt. m) s(m) = 0.0e0
      if (nrtp1 .lt. m) e(nrtp1) = x(nrtp1,m)
      e(m) = 0.0e0
c
c     if required, generate u.
c
      if (.not.wantu) go to 300
         if (ncu .lt. nctp1) go to 200
         do 190 j = nctp1, ncu
            do 180 i = 1, n
               u(i,j) = 0.0e0
  180       continue
            u(j,j) = 1.0e0
  190    continue
  200    continue
         if (nct .lt. 1) go to 290
         do 280 ll = 1, nct
            l = nct - ll + 1
            if (s(l) .eq. 0.0e0) go to 250
               lp1 = l + 1
               if (ncu .lt. lp1) go to 220
               do 210 j = lp1, ncu
                  t = -sdot(n-l+1,u(l,l),1,u(l,j),1)/u(l,l)
                  call saxpy(n-l+1,t,u(l,l),1,u(l,j),1)
  210          continue
  220          continue
               call sscal(n-l+1,-1.0e0,u(l,l),1)
               u(l,l) = 1.0e0 + u(l,l)
               lm1 = l - 1
               if (lm1 .lt. 1) go to 240
               do 230 i = 1, lm1
                  u(i,l) = 0.0e0
  230          continue
  240          continue
            go to 270
  250       continue
               do 260 i = 1, n
                  u(i,l) = 0.0e0
  260          continue
               u(l,l) = 1.0e0
  270       continue
  280    continue
  290    continue
  300 continue
c
c     if it is required, generate v.
c
      if (.not.wantv) go to 350
         do 340 ll = 1, p
            l = p - ll + 1
            lp1 = l + 1
            if (l .gt. nrt) go to 320
            if (e(l) .eq. 0.0e0) go to 320
               do 310 j = lp1, p
                  t = -sdot(p-l,v(lp1,l),1,v(lp1,j),1)/v(lp1,l)
                  call saxpy(p-l,t,v(lp1,l),1,v(lp1,j),1)
  310          continue
  320       continue
            do 330 i = 1, p
               v(i,l) = 0.0e0
  330       continue
            v(l,l) = 1.0e0
  340    continue
  350 continue
c
c     main iteration loop for the singular values.
c
      mm = m
      iter = 0
  360 continue
c
c        quit if all the singular values have been found.
c
c     ...exit
         if (m .eq. 0) go to 620
c
c        if too many iterations have been performed, set
c        flag and return.
c
         if (iter .lt. maxit) go to 370
            info = m
c     ......exit
            go to 620
  370    continue
c
c        this section of the program inspects for
c        negligible elements in the s and e arrays.  on
c        completion the variables kase and l are set as follows.
c
c           kase = 1     if s(m) and e(l-1) are negligible and l.lt.m
c           kase = 2     if s(l) is negligible and l.lt.m
c           kase = 3     if e(l-1) is negligible, l.lt.m, and
c                        s(l), ..., s(m) are not negligible (qr step).
c           kase = 4     if e(m-1) is negligible (convergence).
c
         do 390 ll = 1, m
            l = m - ll
c        ...exit
            if (l .eq. 0) go to 400
            test = abs(s(l)) + abs(s(l+1))
            ztest = test + abs(e(l))
            if (ztest .ne. test) go to 380
               e(l) = 0.0e0
c        ......exit
               go to 400
  380       continue
  390    continue
  400    continue
         if (l .ne. m - 1) go to 410
            kase = 4
         go to 480
  410    continue
            lp1 = l + 1
            mp1 = m + 1
            do 430 lls = lp1, mp1
               ls = m - lls + lp1
c           ...exit
               if (ls .eq. l) go to 440
               test = 0.0e0
               if (ls .ne. m) test = test + abs(e(ls))
               if (ls .ne. l + 1) test = test + abs(e(ls-1))
               ztest = test + abs(s(ls))
               if (ztest .ne. test) go to 420
                  s(ls) = 0.0e0
c           ......exit
                  go to 440
  420          continue
  430       continue
  440       continue
            if (ls .ne. l) go to 450
               kase = 3
            go to 470
  450       continue
            if (ls .ne. m) go to 460
               kase = 1
            go to 470
  460       continue
               kase = 2
               l = ls
  470       continue
  480    continue
         l = l + 1
c
c        perform the task indicated by kase.
c
         go to (490,520,540,570), kase
c
c        deflate negligible s(m).
c
  490    continue
            mm1 = m - 1
            f = e(m-1)
            e(m-1) = 0.0e0
            do 510 kk = l, mm1
               k = mm1 - kk + l
               t1 = s(k)
               call srotg(t1,f,cs,sn)
               s(k) = t1
               if (k .eq. l) go to 500
                  f = -sn*e(k-1)
                  e(k-1) = cs*e(k-1)
  500          continue
               if (wantv) call srot(p,v(1,k),1,v(1,m),1,cs,sn)
  510       continue
         go to 610
c
c        split at negligible s(l).
c
  520    continue
            f = e(l-1)
            e(l-1) = 0.0e0
            do 530 k = l, m
               t1 = s(k)
               call srotg(t1,f,cs,sn)
               s(k) = t1
               f = -sn*e(k)
               e(k) = cs*e(k)
               if (wantu) call srot(n,u(1,k),1,u(1,l-1),1,cs,sn)
  530       continue
         go to 610
c
c        perform one qr step.
c
  540    continue
c
c           calculate the shift.
c
            scale = amax1(abs(s(m)),abs(s(m-1)),abs(e(m-1)),abs(s(l)),
     *                    abs(e(l)))
            sm = s(m)/scale
            smm1 = s(m-1)/scale
            emm1 = e(m-1)/scale
            sl = s(l)/scale
            el = e(l)/scale
            b = ((smm1 + sm)*(smm1 - sm) + emm1**2)/2.0e0
            c = (sm*emm1)**2
            shift = 0.0e0
            if (b .eq. 0.0e0 .and. c .eq. 0.0e0) go to 550
               shift = sqrt(b**2+c)
               if (b .lt. 0.0e0) shift = -shift
               shift = c/(b + shift)
  550       continue
            f = (sl + sm)*(sl - sm) + shift
            g = sl*el
c
c           chase zeros.
c
            mm1 = m - 1
            do 560 k = l, mm1
               call srotg(f,g,cs,sn)
               if (k .ne. l) e(k-1) = f
               f = cs*s(k) + sn*e(k)
               e(k) = cs*e(k) - sn*s(k)
               g = sn*s(k+1)
               s(k+1) = cs*s(k+1)
               if (wantv) call srot(p,v(1,k),1,v(1,k+1),1,cs,sn)
               call srotg(f,g,cs,sn)
               s(k) = f
               f = cs*e(k) + sn*s(k+1)
               s(k+1) = -sn*e(k) + cs*s(k+1)
               g = sn*e(k+1)
               e(k+1) = cs*e(k+1)
               if (wantu .and. k .lt. n)
     *            call srot(n,u(1,k),1,u(1,k+1),1,cs,sn)
  560       continue
            e(m-1) = f
            iter = iter + 1
         go to 610
c
c        convergence.
c
  570    continue
c
c           make the singular value  positive.
c
            if (s(l) .ge. 0.0e0) go to 580
               s(l) = -s(l)
               if (wantv) call sscal(p,-1.0e0,v(1,l),1)
  580       continue
c
c           order the singular value.
c
  590       if (l .eq. mm) go to 600
c           ...exit
               if (s(l) .ge. s(l+1)) go to 600
               t = s(l)
               s(l) = s(l+1)
               s(l+1) = t
               if (wantv .and. l .lt. p)
     *            call sswap(p,v(1,l),1,v(1,l+1),1)
               if (wantu .and. l .lt. n)
     *            call sswap(n,u(1,l),1,u(1,l+1),1)
               l = l + 1
            go to 590
  600       continue
            iter = 0
            m = m - 1
  610    continue
      go to 360
  620 continue
      return
      end
      SUBROUTINE SSWAP(N,SX,INCX,SY,INCY)
*     .. Scalar Arguments ..
      INTEGER INCX,INCY,N
*     ..
*     .. Array Arguments ..
      REAL SX(*),SY(*)
*     ..
*
*  Purpose
*  =======
*
*     interchanges two vectors.
*     uses unrolled loops for increments equal to 1.
*
*  Further Details
*  ===============
*
*     jack dongarra, linpack, 3/11/78.
*     modified 12/3/93, array(1) declarations changed to array(*)
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL STEMP
      INTEGER I,IX,IY,M,MP1
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC MOD
*     ..
      IF (N.LE.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) THEN
*
*       code for both increments equal to 1
*
*
*       clean-up loop
*
         M = MOD(N,3)
         IF (M.NE.0) THEN
            DO I = 1,M
               STEMP = SX(I)
               SX(I) = SY(I)
               SY(I) = STEMP
            END DO
            IF (N.LT.3) RETURN
         END IF
         MP1 = M + 1
         DO I = MP1,N,3
            STEMP = SX(I)
            SX(I) = SY(I)
            SY(I) = STEMP
            STEMP = SX(I+1)
            SX(I+1) = SY(I+1)
            SY(I+1) = STEMP
            STEMP = SX(I+2)
            SX(I+2) = SY(I+2)
            SY(I+2) = STEMP
         END DO
      ELSE
*
*       code for unequal increments or equal increments not equal
*         to 1
*
         IX = 1
         IY = 1
         IF (INCX.LT.0) IX = (-N+1)*INCX + 1
         IF (INCY.LT.0) IY = (-N+1)*INCY + 1
         DO I = 1,N
            STEMP = SX(IX)
            SX(IX) = SY(IY)
            SY(IY) = STEMP
            IX = IX + INCX
            IY = IY + INCY
         END DO
      END IF
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***The END of MATMPI**<*<*<<<<<<<<<<<< 
C ////////////----------------------\\\\\\\\\\\\\\\\
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    VIEWFS    ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE VIEWFS(PRNAME)

      CHARACTER PRNAME*8, VIEWER*64
      LOGICAL LEXIST
C**********************************************************************
C(2.35) Support for viewing multiple project files discontinued.
C  Now only viewing (and editing) the <project>.lis file is enacted
C  with starting QLISTING, as it is now called. 
C**********************************************************************
      CALL GETENV ("VIEWER",VIEWER)
      IF (VIEWER.NE." ") THEN
        INQUIRE(FILE=VIEWER,EXIST=LEXIST)
        IF(LEXIST) THEN
          WRITE(*,*) "Launching external file viewer ..."
		  WRITE(*,*) 
          WRITE(*,*) "When you are finished with viewing the ",
     1              "PQMethod output listing (.lis ) "
          WRITE(*,*) "and quit the program, you will return to ",
     1               "PQMethod"
          WRITE(*,*) "-don't forget to close PQMethod!"
	      WRITE(*,*)
          WRITE(*,*) "Hit <ENTER> to continue"
          READ(*,*)
          CALL CLOSFS
          CALL SYSTEM (VIEWER(1:LENGTH(VIEWER)) 
     1     // ' ' // PRNAME(1:LENGTH(PRNAME)) // '.lis'
     9     , ISTAT) 
        ELSE
          WRITE(*,*) "External viewer program: ",
     1    VIEWER(1:LENGTH(VIEWER)), " not found"
          WRITE(*,*) "Hit <ENTER> to continue"
          READ(*,*)
        END IF
      ELSE
        WRITE(*,*) "For viewing the PQMethod output file, ",
     1  PRNAME(1:LENGTH(PRNAME)) // ".lis, "
        WRITE(*,*) "an EXTERNAL viewer or editor program is required."
        WRITE(*,*) "This program file (with full path) must be set "
		WRITE(*,*) "as the environment variable VIEWER."
        WRITE(*,*) 
        WRITE(*,*) "Hit <ENTER> to continue"
        READ(*,*)
      END IF
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***     PAGE     ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE PAGE

      CHARACTER PRNAME*8, FNAME*64, PRTITL*68, SORTID(299)*8
C
      COMMON /STRINGS/ PRNAME,FNAME,PRTITL,SORTID
      COMMON /ANAL01/ NFAX,NSORTS,NITEMS,IPAGE
      COMMON /ANAL04/ FREQ(15),FLOAD(299,8),LLINES, MLNSPG, LPCA
C
      CHARACTER*9  HLDDAT
      CHARACTER*12 HEADER
      CHARACTER*1  FF
C
      LOGICAL FIRST
C
      SAVE FIRST, HLDDAT
C
      DATA FIRST/.TRUE./
C
C                  Page heading routine
C          First call of this routine computes date
C
      HEADER = 'PQMethod2.35'
      IPAGE = IPAGE + 1
      FF = CHAR (12)
C
C         The next block gets the date in mm/dd/yy form
C
      IF (FIRST) THEN
        CALL SSDATE (HLDDAT)
        WRITE(15,'(A1)') ' '
        FIRST  = .FALSE.
      ELSE
        WRITE(15,'(A1)') FF
      ENDIF
C
      WRITE(15,810)  HEADER, PRTITL, IPAGE
      WRITE(15,820) FNAME,HLDDAT
      LLINES = 3

C
  810 FORMAT(A12,15X,A68,18X,'PAGE ',I4)
  820 FORMAT('Path and Project Name: ',A64,26X,A9)
C   820 FORMAT(113X,A9)
C
      RETURN
      END
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    ERROR     ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
      SUBROUTINE ERROR (ICODE)
CSMK: Added copies of WRITE(15,.. as WRITE(*,...
C
      CALL PAGE
      WRITE(15,810)
      WRITE(*,810)
  810 FORMAT(/,' Execute Suspended for the Following Reason')
C
C     ICODE - contains error code
C
      GO TO (10,20,30,40,50,60,70) ICODE
   10 WRITE(15,830)
      WRITE(*,830)
  830 FORMAT(/,' You Have Exceeded the Limits of Program')
      GO TO 900
   20 WRITE(15,860)
      WRITE(*,860)
  860 FORMAT(/,' Error in Input Data - Alphabetical Data in Numeric ',
     1       'Field')
      GO TO 900
C
   30 WRITE(15,870)
      WRITE(*,870)
  870 FORMAT(/,' Correlation File not Found -- Cannot Continue ')
      GO TO 900
C
   40 WRITE(15,880)
      WRITE(*,880)
  880 FORMAT(/,' Unrotated Matrix File Not Found -- Cannot Continue ')
      GO TO 900
C
   50 WRITE(15,890)
      WRITE(*,890)
  890 FORMAT(/,' Factors Have Been Included That Are Not Flagged as',
     1       ' a Defining Factor ',/,
     2  ' or the File Does not Exist at all-- Fix the .rot File.')
      GO TO 900
C
   60 WRITE(15,895)
      WRITE(*,895)
  895 FORMAT(/,' Not Enough Statements or missing final hard return',
     1 /' -- Rerun STATES Option to fix.')
      GO TO 900
C
   70 WRITE(15,896)
      WRITE(*,896)
  896 FORMAT(
     1 /,' Raw data file (.dat) not found-- Run QENTER .')
  900 CONTINUE
C
C
      CALL EXITPR
C
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    INERR     ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
CSMK (2.11): Error msg 13, added QPCA

      SUBROUTINE INERR(NUM)
      WRITE(*,*) 'INPUT FILE NOT FOUND (or too few records).'
      IF (NUM.EQ.3) WRITE(*,*) 'No previous rotation on record.'
      IF (NUM.EQ.16) WRITE(*,*)
     1   'No rawdata file (.dat) - you must run QENTER routine.'
      IF (NUM.EQ.161) WRITE(*,*)
     1   'Error in rawdata file (.dat) - alphabetical data in ',
     1   ' numeric field'
      IF (NUM.EQ.12) WRITE(*,*)
     1   'No corrout - you must run correlation.'
      IF (NUM.EQ.13) WRITE(*,*)
     1   'You must run QCENT (min. 2 factors!) or QPCA first.'
      WRITE(*,*) ' '
      WRITE(*,*) 'Press <ENTER> to continue '
      READ(*,*) 
      RETURN
      END
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    PUTTMP    ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
CMS      SUBROUTINE PUTTMP (BUF)
C  Outputs string BUF to unit 9 (scratch file opened in ASSFIL)
C  This subroutine is used as a workaround to substitute list-directed
C  internal file I/O which is not allowed in MS-FORTRAN (P. Schmolck)
C
CMS      CHARACTER*(*) BUF
CMS      REWIND 9
CMS      WRITE(9,*) BUF
CMS      REWIND 9

CMS      RETURN

CMS      END

C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    ASSFIL    ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE ASSFIL (FIRST,PRNAME,FNAME)
C
C  This module assigns filenames and opens the files. It substitutes
C  John's VMS/VAX batch-file xq.com.
C  Asks (or queries command line) for project name if FIRST=.TRUE. only.
C ( Also opens unit 9 as scratch file (if FIRST=.TRUE.) -obsolete)
C(2.0e): Opening file 15 (.lis) now transferred to sub QANAL
C(2.07): Using non-standard-ANSI function GETARG, projectname can 
C       be read from command line
C(2.34): For the sake of GFORTRAN compatibility the separator characters are now 
C  defined using the CHAR function instead of as "\/" and "\\".
C
C+----------+----------+----------+--------------------------------------------+
C| File Ext | Output   |Input To  |Description                                 |
C|(Mainfr.) |  From    |          |                                            |
C+----------+----------+----------+--------------------------------------------+
C|   .sta   | STATES   |(STATES)  |Each record contains the text of one state- |
C| (STATES) |          |QANALYZE  |ment.  The same order as the numbers used   |
C|          |          |          |in the q-sorts is required.                 |
C+----------+----------+----------+--------------------------------------------+
C|   .ent   | QENTER   |(QENTER)  |The first three records contain all of the  |
C|($HLDENT$)|          |          |design information.  Other records contain  |
C|          |          |          |qsort shape info for each sort entered.     |
C|          |          |          |Used only if QENTER is used again for add-  |
C|          |          |          |ing more q-sorts. This file isn't required  |
C|          |          |          |any more in PQMethod 2.0. (There are several|
C|          |          |          |lines of commented code in this source,     |
C|          |          |          |that would allow to output a valid .ent for |
C|          |          |          |use with older QMethod version. Look for    |
C|          |          |          |the string 'WRITE(2'.                      |
C+----------+----------+----------+--------------------------------------------+
C|   .raw   | QENTER   |(QENTER)  |The first two records contain design infor- |
C|(RAWDATA) |          |  QCORR   |mation, and the rest contain the data       |
C|          |          |QANALIZE  |entered in for all of the q-sorts. (Trans-  |
C|          |          |          |posed data matrix) This file / data format  |
C|          |          |          |is superseded by the new format .dat file   |
C|          |          |          |since PQMethod 2.0. However, for the sake of|
C|          |          |          |downward compatibility this file is recog-  |
C|          |          |          |nized as valid input as well as automatical-|
C|          |          |          |ly written out whenever QENTER (or QCORR) is|
C|          |          |          |executed. Case labels, if available, follow |
C|          |          |          |after the data matrix (col 1-8).            |
C+----------+----------+----------+--------------------------------------------+
C|   .dat   | QENTER   |(QENTER)  |New version of raw data file since PQMethod |
C|          |          |  QCORR   |2.0 with first two records same as in .raw. |
C|          |          |QANALIZE  |Data matrix is not transposed, i.e., there  |
C|          |          |          |is now one record for every subject:        |
C|          |          |          |Col 1-8: Case label, Cols 11 - (max.) 250:  |
C|          |          |          |item responses. If there exists a .raw but  |
C|          |          |          |no .dat, QENTER automatically converts it   |
C|          |          |          |to the new .dat format. If both, .dat and   |
C|          |          |          |.raw exist, .dat takes precedence, and .raw |
C|          |          |          |will be overwritten with the content of .dat|
C+----------+----------+----------+--------------------------------------------+
C|   .cor   |  QCORR   |  QCENT   |First two records are standard design       |
C|(CORROUT) |          | (QANA-   |information and the rest of the file is a   |
C|          |          |  LYZE)   |correlation matrix.                         |
C+----------+----------+----------+--------------------------------------------+
C|   .unr   |  QCENT   | QROTATE  |First two records are standard and the rest |
C|(UNROTFX) |          |QVARIMAX  |contain the unrotated factor loadings.      |
C|          |          | (QANA-   |                                            |
C|          |          |  LYZE)   |                                            |
C+----------+----------+----------+--------------------------------------------+
C|   .hro   | QROTATE  |(QROTATE) |Same format as the unrotated factor matrix, |
C|($HLDROT$)|          |          |but reflects all rotations applied in QRO-  |
C|          |          |          |TATE.  This file is only used if QROTATE is |
C|          |          |          |run again to continue rotations.            |
C+----------+----------+----------+--------------------------------------------+
C|   .qan   | QROTATE  |QANALYZE  |The first two records are heading.  Remain- |
C|(QANGLES) |          |          |der indicate rotations of factors.          |
C+----------+----------+----------+--------------------------------------------+
C|   .rot   | QROTATE  |QANALYZE  |The first two records are standard and the  |
C| (ROTFX)  |QVARIMAX  |          |rest is the rotated factor matrix.  How-    |
C|          |          |          |ever, ONLY the factors requested to be out- |
C|          |          |          |put are here.                               |
C+----------+----------+----------+--------------------------------------------+
C|   .lis   |QANALYZE  |          |This is the Q analysis report.              |
C|(LISTING) |          |          |                                            |
C+----------+----------+----------+--------------------------------------------+
CSMK (231): added data output to .tsv 
C+----------+----------+----------+--------------------------------------------+
C|   .TSV   |QENTER    |          |Tab-separated data file                     |
C+----------+----------+----------+--------------------------------------------+

C



      LOGICAL FIRST
      CHARACTER PRNAME*8,FNAME*64
      CHARACTER*1 SLSH,CSLSH
C
      SLSH=CHAR(47)   ! defining slash (/) as string variable
      CSLSH=CHAR(92)  ! defining counterslash (\) 
C
      IF(.NOT.FIRST) GOTO 5
C 
C Get [path\]project-name from command line or otherwise ask user
C

      CALL GETARG(1,FNAME)
C      IF (LENGTH(FNAME).GT.0) THEN
      IF (FNAME.NE.' ') THEN
        WRITE(*,*) 'Hit ENTER to begin '
        READ(*,*)
        GOTO 2
      ELSE
        GOTO 1
      END IF

1     WRITE(*,*) ' Enter [Path and] Project Name: '
      READ(*,'(A)') FNAME
      IF (INDEX(FNAME(1:LENGTH(FNAME)), ' ') .NE. 0 )  THEN
         WRITE(*,*) ' The project name must be ONE word, please!'
         GOTO 1
      END IF
C
 2    CONTINUE
C
C replace all "\" by "/" (under Win-NT djgpp-compiled executable 
C does not like the "\")
C
      ISEP=INDEX(FNAME,CSLSH)
      DO WHILE (ISEP.NE.0) 
        FNAME(ISEP:ISEP)=SLSH
        ISEP=INDEX(FNAME,CSLSH)
      END DO
C
C Get filename part without filename extension as project name
C as well as project directory-path name
C CHDIR into project directory 

      ISEP=MAX0(LINDEX(FNAME,':'),LINDEX(FNAME,CSLSH), 
     1         LINDEX(FNAME,SLSH))

      PRNAME=FNAME(ISEP+1:)
      IDOT=LINDEX(PRNAME,'.')
      IF (IDOT.GT.1) PRNAME=PRNAME(1:IDOT-1)
      IF(ISEP.GT.0) THEN
        ISTAT=CHDIR(FNAME(1:ISEP))
        IF(ISTAT.GT.0) THEN 
          WRITE(*,*) 'Directory ',FNAME(1:ISEP), 
     1      ' does not exist. Please repeat'
          GOTO 1
        ENDIF
      ENDIF
C
C Now use GetCwd to get _absolute_ directory-path, store it
C in FNAME, and add "/"+PRNAME 
C
      ISTAT=GETCWD(FNAME)
      FNAME=FNAME(1:LENGTH(FNAME))//SLSH//PRNAME
C
CMS     OPEN (9,STATUS='SCRATCH')
C
 5    CONTINUE
      L=LENGTH(FNAME)
      OPEN (1,FILE=FNAME(1:L)//'.sta')
C      OPEN (2,FILE=FNAME(1:L)//'.ent')
      OPEN (3,FILE=FNAME(1:L)//'.hro')
      OPEN (4,FILE=FNAME(1:L)//'.qan')
      OPEN (11,FILE=FNAME(1:L)//'.raw')
      OPEN (12,FILE=FNAME(1:L)//'.cor')
      OPEN (13,FILE=FNAME(1:L)//'.unr')
      OPEN (14,FILE=FNAME(1:L)//'.rot')
C      OPEN (15,FILE=FNAME(1:L)//'.lis')
      OPEN (16,FILE=FNAME(1:L)//'.dat')
      OPEN (19,FILE=FNAME(1:L)//'.tsv')
C
      RETURN
      END
C
C
      FUNCTION LENGTH (CHR)
C
C    Length of a string without trailing blanks
C
      CHARACTER*(*) CHR
      DO 10 I=LEN(CHR),1,-1
 10   IF(CHR(I:I).NE.' ') GOTO 19
 19   LENGTH=MAX(1,I)
      END
C
C
      INTEGER FUNCTION LINDEX(STR,SSTR)
C
C    Last occurrence of substring SSTR in STR 
C
      CHARACTER*(*) STR,SSTR
      L0 = INDEX(STR, SSTR)
      IF(L0.EQ.0.OR.L0.EQ.LEN(STR)) THEN
        LINDEX = L0
        RETURN
      ELSE
        DO WHILE (L0.GT.0)
          LINDEX = L0
          L0 = INDEX(STR(L0+1:),SSTR)
          IF(L0.NE.0) L0=L0+LINDEX
        END DO
      END IF
      RETURN
      END
C
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    CLOSFS    ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C
      SUBROUTINE CLOSFS
C
C  This module closes all files --but not the scratch-file '9'
C  neither files 17 and 18 (opened and closed in FAXDAT).
C  
C  (P. Schmolck)
C
      CLOSE (1)
C      CLOSE (2)
      CLOSE (3)
      CLOSE (4)
      CLOSE (11)
      CLOSE (12)
      CLOSE (13)
      CLOSE (14)
      CLOSE (15)
      CLOSE (16)
      CLOSE (19)
C
      RETURN
      END
C
C
C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    EXITPR      ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C  Before exiting close all files opened in ASSFIL and 
C  delete all empty files
C
      SUBROUTINE EXITPR
C
      CHARACTER*1 BUF
      INTEGER IT (9)
C
      DATA IT /1,3,4,11,12,13,14,16,19/
C
      DO 10 I=1,9
      REWIND (IT(I))
      READ(IT(I),'(A)',END=12,ERR=12) BUF
      CLOSE (IT(I))
      GOTO 10
   12 CLOSE (IT(I),STATUS='DELETE')
   10 CONTINUE
C
      WRITE(*,*) ' '
      WRITE(*,*) 'Thank you for using PQMethod'
      WRITE(*,*) 'Press <ENTER> to exit'
      READ(*,*)
      STOP
      END

C \\\\\\\\\\\\----------------------////////////////

C >>>>>>>>>*>*>***    SSDATE   ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C  
C  Subroutine SsDate (system-specific date) is a wrapper that contains
C  the compiler-specific syntax that will render a 9-byte date string, 
C  e.g., 'MM/DD/YY'. In the original form of this 'wrapper' all
C  the lines with system-specific syntax are commented out using 
C  special strings ('CVU', 'CMS') as leading characters. If you do *not*
C  uncomment any version (delete such a string), SSDATE renders an empty 
C  string (all blank) instead of the actual date of execution.
C
C  Many systems/compilers (Vax, Unix, etc.) contain the Intrinsic DATE. 
C  To find out if this is the case for your compiler, uncomment the 
C  'CALL DATE (DAT)' statement (delete 'CVU'), and if you do not get an 
C  error message after compiling (and binding), it's OK.

      SUBROUTINE SSDATE (DAT)
      CHARACTER*9 DAT
      CHARACTER*24 BUF
      DAT ='         '
C
C Vax / Unix and other compilers:
CVU      CALL DATE (DAT)
C
C
C G77, Y2K compliant:
C
      CALL FDATE(BUF)
      DAT=BUF(5:11)//BUF(23:24)
C
C Microsoft-Compilers: 
CMS      CALL GETDAT(IYR,IMON,IDAY)
CMS      IYR=IYR-1900
CMS      IF (IYR.GT.99) IYR=IYR-100
CMS      WRITE(DAT,'(1X,I2,1H/,I2,1H/,I2)') IMON,IDAY,IYR
C
      RETURN
      END

C \\\\\\\\\\\\----------------------////////////////
C >>>>>>>>>*>*>***    SSTIME   ***<*<*<<<<<<<<<<<<
C ////////////----------------------\\\\\\\\\\\\\\\\
C  
C  Subroutine SsTime (system-specific time) is a wrapper that contains
C  the compiler-specific syntax that will render a 8-byte time string, 
C  e.g., 'hh/mm/ss'. 
C  The 'CALL TIME ()' intrinsic is supported by various compilers,
C  simply uncomment that statement (delete 'CVU'), to try out, or find
C  out how to get the equivalent with your compiler.
C  

      SUBROUTINE SSTIME (TIM)
      CHARACTER*8 TIM
      CHARACTER*24 BUF
      TIM ='        '
C
C Vax / Unix and other compilers:
CVU      CALL TIME (TIM)
C
C
C G77, Y2K compliant:
C
      CALL FDATE(BUF)
      TIM=BUF(12:19)
C
      RETURN
      END

